/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.butterflies.desktop.game;

import com.tjger.butterflies.desktop.game.ButterfliesState;
import com.tjger.butterflies.desktop.game.PREYCOLOR;
import com.tjger.butterflies.desktop.game.move.MovePreyMove;
import com.tjger.butterflies.desktop.game.move.RollDiceMove;
import java.util.ArrayList;
import java.util.Collection;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.MoveInformation;
import tjger.game.SimpleGameRules;

public class ButterfliesRules
extends SimpleGameRules {
    @Override
    public boolean isRoundFinished(GameState gameState) {
        return !((ButterfliesState)gameState).isFreePreyAvailable();
    }

    @Override
    public boolean isGameFinished(GameState gameState) {
        return this.isRoundFinished(gameState);
    }

    @Override
    public void doScoring(GamePlayer[] playerToScore, GameState gameState) {
    }

    @Override
    public boolean isValidMove(MoveInformation move, GameState gameState) {
        ButterfliesState state = (ButterfliesState)gameState;
        if (move instanceof RollDiceMove) {
            return this.isRollDiceAllowed(state);
        }
        if (move instanceof MovePreyMove) {
            return this.isMovePreyAllowed(state, ((MovePreyMove)move).getPrey());
        }
        return false;
    }

    public Collection<MoveInformation> getPossibleMoves(GameState gameState) {
        ArrayList<MoveInformation> moves = new ArrayList<MoveInformation>();
        RollDiceMove rollDiceMove = new RollDiceMove();
        if (this.isValidMove(rollDiceMove, gameState)) {
            moves.add(rollDiceMove);
        }
        PREYCOLOR[] pREYCOLORArray = PREYCOLOR.values();
        int n = pREYCOLORArray.length;
        int n2 = 0;
        while (n2 < n) {
            PREYCOLOR prey = pREYCOLORArray[n2];
            MovePreyMove movePreyMove = new MovePreyMove(prey);
            if (this.isValidMove(movePreyMove, gameState)) {
                moves.add(movePreyMove);
            }
            ++n2;
        }
        return moves;
    }

    public boolean isRollDiceAllowed(ButterfliesState state) {
        return !state.mustChoosePrey();
    }

    public boolean isMovePreyAllowed(ButterfliesState state) {
        return state.mustChoosePrey();
    }

    public boolean isMovePreyAllowed(ButterfliesState state, PREYCOLOR prey) {
        return !state.isPreySave(prey);
    }
}

