/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.butterflies.desktop.game;

import com.tjger.butterflies.desktop.game.DICECOLOR;
import com.tjger.butterflies.desktop.game.PREYCOLOR;
import com.tjger.butterflies.desktop.game.move.MovePreyMove;
import com.tjger.butterflies.desktop.game.move.RollDiceMove;
import com.tjger.butterflies.desktop.ui.game.ButterfliesGamePanel;
import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.MainFrame;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.MoveInformation;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.SingleField;
import tjger.lib.AbstractXmlCollectionByAttributeConverter;
import tjger.lib.AbstractXmlMapByAttributeConverter;
import tjger.lib.XmlUtil;

public class ButterfliesState
implements GameState {
    private static final String SOUND_ROLL_DICE = "soundrolldice";
    private static final String SAVEKEY_CHASER_POSITION = "chaserposition";
    private static final String SAVEKEY_MUST_CHOOSE_PREY = "mustchooseprey";
    private static final String SAVEKEY_CURRENT_DICE_COLOR = "currentdicecolor";
    private static final String SAVEKEY_PREY_POSITIONS = "preypositions";
    private static final String SAVEKEY_PREYCOLOR = "preycolor";
    private static final String SAVEKEY_CAUGHT_PREY = "caughtprey";
    private Map<PREYCOLOR, String> preyPositions;
    private String chaserPosition;
    private DICECOLOR currentDiceColor;
    private Collection<PREYCOLOR> caughtPrey;
    private boolean mustChoosePrey;

    @Override
    public void resetGame(GameEngine engine) {
        this.preyPositions = new HashMap<PREYCOLOR, String>();
        PlayingField field = ButterfliesGamePanel.getActivePlayingField();
        this.initPreyStartPositions(field);
        this.initChaserStartPosition(field);
        this.currentDiceColor = DICECOLOR.GREEN;
        this.caughtPrey = new ArrayList<PREYCOLOR>();
        this.mustChoosePrey = false;
    }

    private void initPreyStartPositions(PlayingField field) {
        SingleField preyStart = field.getFirstFieldWithProperty("type", "startprey");
        PREYCOLOR[] pREYCOLORArray = PREYCOLOR.values();
        int n = pREYCOLORArray.length;
        int n2 = 0;
        while (n2 < n) {
            PREYCOLOR preyColor = pREYCOLORArray[n2];
            this.setPreyPosition(preyColor, preyStart.getId());
            ++n2;
        }
    }

    private void initChaserStartPosition(PlayingField field) {
        SingleField chaserStart = field.getFirstFieldWithProperty("type", "startchaser");
        this.setChaserPosition(chaserStart.getId());
    }

    private void setPreyPosition(PREYCOLOR preyColor, String fieldId) {
        this.preyPositions.put(preyColor, fieldId);
    }

    private String getPreyPosition(PREYCOLOR preyColor) {
        return this.preyPositions.get((Object)preyColor);
    }

    public Map<String, Set<PREYCOLOR>> getPreyPositions() {
        HashMap<String, Set<PREYCOLOR>> positions = new HashMap<String, Set<PREYCOLOR>>();
        PREYCOLOR[] pREYCOLORArray = PREYCOLOR.values();
        int n = pREYCOLORArray.length;
        int n2 = 0;
        while (n2 < n) {
            PREYCOLOR prey = pREYCOLORArray[n2];
            String preyPosition = this.getPreyPosition(prey);
            Set preysAtPosition = positions.getOrDefault(preyPosition, new HashSet());
            preysAtPosition.add(prey);
            positions.put(preyPosition, preysAtPosition);
            ++n2;
        }
        return positions;
    }

    private Collection<PREYCOLOR> getPrey(String positionId) {
        if (!HGBaseTools.hasContent(positionId)) {
            return new ArrayList<PREYCOLOR>();
        }
        ArrayList<PREYCOLOR> preys = new ArrayList<PREYCOLOR>();
        PREYCOLOR[] pREYCOLORArray = PREYCOLOR.values();
        int n = pREYCOLORArray.length;
        int n2 = 0;
        while (n2 < n) {
            PREYCOLOR prey = pREYCOLORArray[n2];
            String preyPosition = this.getPreyPosition(prey);
            if (positionId.equals(preyPosition)) {
                preys.add(prey);
            }
            ++n2;
        }
        return preys;
    }

    private String getFieldType(PlayingField field, String position) {
        return HGBaseTools.hasContent(position) ? field.getField(position).getProperty("type") : null;
    }

    public boolean isFreePreyAvailable() {
        PlayingField field = ButterfliesGamePanel.getActivePlayingField();
        PREYCOLOR[] pREYCOLORArray = PREYCOLOR.values();
        int n = pREYCOLORArray.length;
        int n2 = 0;
        while (n2 < n) {
            PREYCOLOR prey = pREYCOLORArray[n2];
            if (!this.isPreySave(prey, field) && !this.isPreyCaught(prey)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isPreySave(PREYCOLOR prey) {
        PlayingField field = ButterfliesGamePanel.getActivePlayingField();
        return this.isPreySave(prey, field);
    }

    private boolean isPreySave(PREYCOLOR prey, PlayingField field) {
        return this.isPreySaveField(field, this.getPreyPosition(prey));
    }

    private boolean isPreySaveField(PlayingField field, String position) {
        return "burrow".equals(this.getFieldType(field, position));
    }

    public boolean isPreyFreeField(PlayingField field, String position) {
        return !this.isPreySaveField(field, position);
    }

    public boolean isPreyCaught(PREYCOLOR prey) {
        return this.caughtPrey.contains((Object)prey);
    }

    private void setChaserPosition(String fieldId) {
        this.chaserPosition = fieldId;
    }

    public String getChaserPosition() {
        return this.chaserPosition;
    }

    public DICECOLOR getCurrentDiceColor() {
        return this.currentDiceColor;
    }

    public Collection<PREYCOLOR> getSavePrey() {
        ArrayList<PREYCOLOR> savePrey = new ArrayList<PREYCOLOR>();
        PlayingField field = ButterfliesGamePanel.getActivePlayingField();
        PREYCOLOR[] pREYCOLORArray = PREYCOLOR.values();
        int n = pREYCOLORArray.length;
        int n2 = 0;
        while (n2 < n) {
            PREYCOLOR prey = pREYCOLORArray[n2];
            if (this.isPreySave(prey, field)) {
                savePrey.add(prey);
            }
            ++n2;
        }
        return savePrey;
    }

    public Collection<PREYCOLOR> getCaughtPrey() {
        return this.caughtPrey;
    }

    public boolean mustChoosePrey() {
        return this.mustChoosePrey;
    }

    @Override
    public void resetRound(GameEngine engine) {
    }

    @Override
    public void resetTurn(GameEngine engine) {
    }

    @Override
    public void stopGame() {
    }

    @Override
    public void changeState(GamePlayer player, MoveInformation move, GameEngine engine) {
        this.mustChoosePrey = false;
        if (move instanceof RollDiceMove) {
            this.playAudio(SOUND_ROLL_DICE);
            RollDiceMove rollDiceMove = (RollDiceMove)move;
            this.currentDiceColor = rollDiceMove.getRolledColor();
            this.moveFigure(rollDiceMove.getRolledColor());
        } else if (move instanceof MovePreyMove) {
            this.movePrey(((MovePreyMove)move).getPrey());
        }
    }

    @Override
    public void undoMove(GamePlayer player, MoveInformation move) {
    }

    @Override
    public int save(Document doc, Element root) {
        root.setAttribute(SAVEKEY_CHASER_POSITION, this.chaserPosition);
        root.setAttribute(SAVEKEY_MUST_CHOOSE_PREY, String.valueOf(this.mustChoosePrey));
        root.setAttribute(SAVEKEY_CURRENT_DICE_COLOR, this.currentDiceColor.name());
        XmlUtil.saveMap(doc, root, SAVEKEY_PREY_POSITIONS, SAVEKEY_PREYCOLOR, this.preyPositions, new PreyPositionsXmlMapConverter());
        XmlUtil.saveCollection(doc, root, SAVEKEY_CAUGHT_PREY, SAVEKEY_PREYCOLOR, this.caughtPrey, new CaughtPreyXmlCollectionConverter());
        return 0;
    }

    @Override
    public int load(Node node) {
        this.chaserPosition = HGBaseXMLTools.getAttributeValue(node, SAVEKEY_CHASER_POSITION);
        this.mustChoosePrey = HGBaseXMLTools.getAttributeBooleanValue(node, SAVEKEY_MUST_CHOOSE_PREY);
        this.currentDiceColor = DICECOLOR.valueOf(HGBaseXMLTools.getAttributeValue(node, SAVEKEY_CURRENT_DICE_COLOR));
        ChildNodeIterator.run(new ChildNodeIterator(node, (Object)this){

            @Override
            public void performNode(Node node, int index, Object obj) {
                String nodeName = node.getNodeName();
                if (ButterfliesState.SAVEKEY_PREY_POSITIONS.equals(nodeName)) {
                    ButterfliesState.this.preyPositions = XmlUtil.loadMap(node, ButterfliesState.SAVEKEY_PREYCOLOR, new PreyPositionsXmlMapConverter());
                } else if (ButterfliesState.SAVEKEY_CAUGHT_PREY.equals(nodeName)) {
                    ButterfliesState.this.caughtPrey = XmlUtil.loadCollection(node, ButterfliesState.SAVEKEY_PREYCOLOR, new CaughtPreyXmlCollectionConverter());
                }
            }
        });
        return 0;
    }

    @Override
    public String toNetworkString() {
        return null;
    }

    @Override
    public boolean fromNetworkString(String data) {
        return false;
    }

    @Override
    public String toNetworkStringMove(MoveInformation move) {
        return null;
    }

    @Override
    public MoveInformation fromNetworkStringMove(String data) {
        return null;
    }

    @Override
    public Object clone() {
        return null;
    }

    private void moveFigure(DICECOLOR color) {
        if (color.isChaser()) {
            this.moveChaser();
        } else {
            this.movePrey(PREYCOLOR.valueOf(color));
        }
    }

    private String getNextFieldPosition(String position) {
        PlayingField field = ButterfliesGamePanel.getActivePlayingField();
        Collection<SingleField> neighbours = field.getNeighbours(field.getField(position));
        if (neighbours.size() > 0) {
            return neighbours.iterator().next().getId();
        }
        return null;
    }

    private void moveChaser() {
        String nextPos = this.getNextFieldPosition(this.getChaserPosition());
        if (HGBaseTools.hasContent(nextPos)) {
            this.setChaserPosition(nextPos);
            this.catchPrey(nextPos);
        }
    }

    private void movePrey(PREYCOLOR preyColor) {
        if (this.isPreySave(preyColor)) {
            this.mustChoosePrey = true;
        } else if (this.isPreyCaught(preyColor)) {
            this.moveChaser();
        } else {
            String nextPos = this.getNextFieldPosition(this.getPreyPosition(preyColor));
            if (HGBaseTools.hasContent(nextPos)) {
                this.setPreyPosition(preyColor, nextPos);
            }
        }
    }

    private void catchPrey(String positionId) {
        Collection<PREYCOLOR> preys = this.getPrey(positionId);
        this.caughtPrey.addAll(preys);
        for (PREYCOLOR prey : preys) {
            this.preyPositions.remove((Object)prey);
        }
    }

    private void playAudio(String media) {
        MainFrame frame = GameManager.getInstance().getMainFrame();
        frame.playAudio(media);
    }

    private class CaughtPreyXmlCollectionConverter
    extends AbstractXmlCollectionByAttributeConverter<PREYCOLOR> {
        private CaughtPreyXmlCollectionConverter() {
        }

        @Override
        protected PREYCOLOR stringToValue(String valueString) {
            return PREYCOLOR.valueOf(valueString);
        }
    }

    private class PreyPositionsXmlMapConverter
    extends AbstractXmlMapByAttributeConverter<PREYCOLOR, String> {
        private PreyPositionsXmlMapConverter() {
        }

        @Override
        protected String keyToString(PREYCOLOR key) {
            return key == null ? "" : key.name();
        }

        @Override
        protected PREYCOLOR stringToKey(String keyString) {
            return PREYCOLOR.valueOf(keyString);
        }

        @Override
        protected String stringToValue(String valueString) {
            return valueString;
        }
    }
}

