/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.butterflies.desktop.game.move;

import com.tjger.butterflies.desktop.game.ButterfliesState;
import com.tjger.butterflies.desktop.game.DICECOLOR;
import com.tjger.butterflies.desktop.game.PREYCOLOR;
import tjger.game.SplitableMove;
import tjger.game.completed.GameEngine;
import tjger.lib.DiceUtil;

public class RollDiceMove
implements SplitableMove {
    private DICECOLOR color = this.rollDice();
    private boolean moveComplete = this.checkMoveComplete();

    private boolean checkMoveComplete() {
        ButterfliesState state = (ButterfliesState)GameEngine.getInstance().getGameState();
        boolean complete = this.color.isChaser() || !state.isPreySave(PREYCOLOR.valueOf(this.getRolledColor()));
        return complete;
    }

    private DICECOLOR rollDice() {
        DICECOLOR[] values = DICECOLOR.values();
        int min = values[0].ordinal();
        int max = values[values.length - 1].ordinal();
        return values[DiceUtil.throwDice(min, max)];
    }

    public DICECOLOR getRolledColor() {
        return this.color;
    }

    @Override
    public boolean isMoveComplete() {
        return this.moveComplete;
    }
}

