/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.butterflies.desktop.game.player.computer;

import com.tjger.butterflies.desktop.game.ButterfliesRules;
import com.tjger.butterflies.desktop.game.ButterfliesState;
import java.util.Collection;
import java.util.Random;
import javax.swing.ImageIcon;
import tjger.game.GamePlayer;
import tjger.game.MoveInformation;
import tjger.lib.TimeAction;

public class ComputerPlayer
extends GamePlayer {
    private static final long MIN_TURN_DURATION = 500L;
    protected MoveInformation move;

    public ComputerPlayer(String playerType, String playerName, ImageIcon playerImage, String pieceColor) {
        super(playerType, playerName, playerImage, pieceColor);
    }

    protected long getTurnMinDuration() {
        return 500L;
    }

    protected final ButterfliesRules getRules() {
        return (ButterfliesRules)this.getGameRules();
    }

    protected final ButterfliesState getState() {
        return (ButterfliesState)this.getGameState();
    }

    protected MoveInformation calculateMove() {
        return this.pickRandomMove(this.getRules().getPossibleMoves(this.getState()));
    }

    protected final MoveInformation pickRandomMove(Collection<MoveInformation> moves) {
        if (moves == null || moves.size() == 0) {
            return null;
        }
        MoveInformation[] movesArray = moves.toArray(new MoveInformation[0]);
        Random random = new Random();
        return movesArray[random.nextInt(movesArray.length)];
    }

    @Override
    public void considerMove() {
        TimeAction.run(new TimeAction(this.getTurnMinDuration()){

            @Override
            public void doAction() {
                ComputerPlayer.this.move = ComputerPlayer.this.calculateMove();
            }

            @Override
            public void afterAction() {
                if (ComputerPlayer.this.move != null) {
                    ComputerPlayer.this.performMove(ComputerPlayer.this.move);
                }
            }
        });
    }
}

