/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.butterflies.desktop.ui.frame;

import com.tjger.butterflies.desktop.game.ButterfliesRules;
import com.tjger.butterflies.desktop.game.ButterfliesState;
import com.tjger.butterflies.desktop.ui.game.ButterfliesGamePanel;
import hgb.lib.HGBaseText;
import tjger.MainFrame;
import tjger.game.GameState;
import tjger.game.completed.GameEngine;
import tjger.lib.SimpleStatusBar;

public class ButterfliesStatusBar
extends SimpleStatusBar {
    private static final String MSG_ROLL_DICE = "status_moveinfo_roll_dice";
    private static final String MSG_CHOOSE_PREY_HARE_HUNT = "status_moveinfo_choose_prey_harehunt";
    private static final String MSG_CHOOSE_PREY_BUTTERFLY_HUNT = "status_moveinfo_choose_prey_butterflyhunt";

    public ButterfliesStatusBar(MainFrame frame) {
        int[] nArray = new int[3];
        nArray[1] = 50;
        nArray[2] = 100;
        super(nArray, frame);
        this.setZoomPanel(1);
        this.setProgressPanel(2);
    }

    @Override
    public void gameStateBeforeMove(GameState state, GameEngine engine) {
        ButterfliesState hareState;
        String moveInfo = null;
        ButterfliesRules rules = (ButterfliesRules)engine.getGameManager().getGameRules();
        if (rules.isRollDiceAllowed(hareState = (ButterfliesState)state)) {
            moveInfo = HGBaseText.getText(MSG_ROLL_DICE, new String[0]);
        } else if (rules.isMovePreyAllowed(hareState)) {
            String arrangementName = ButterfliesGamePanel.getActiveArrangementName();
            if ("arrange_harehunt".equals(arrangementName)) {
                moveInfo = HGBaseText.getText(MSG_CHOOSE_PREY_HARE_HUNT, new String[0]);
            } else if ("arrange_butterflyhunt".equals(arrangementName)) {
                moveInfo = HGBaseText.getText(MSG_CHOOSE_PREY_BUTTERFLY_HUNT, new String[0]);
            }
        }
        if (moveInfo != null) {
            this.setText(String.valueOf(this.getDefaultGameStateText()) + " - " + moveInfo);
        } else {
            super.gameStateBeforeMove(state, engine);
        }
    }
}

