/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.butterflies.desktop.ui.game;

import com.tjger.butterflies.desktop.game.ButterfliesState;
import com.tjger.butterflies.desktop.game.PREYCOLOR;
import com.tjger.butterflies.desktop.ui.game.ButterfliesGamePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.gui.GameDialogs;
import tjger.gui.completed.Part;
import tjger.gui.internal.PartsDlg;
import tjger.gui.internal.PreviewPanel;

public class ButterfliesGameDialogs
extends GameDialogs {
    @Override
    protected JPanel createScorePanel(GameEngine engine, int scoreType, int[] ranks) {
        if (scoreType == 4) {
            return this.createGameScorePanel(engine);
        }
        return super.createScorePanel(engine, scoreType, ranks);
    }

    protected JPanel createGameScorePanel(GameEngine engine) {
        ButterfliesState state = (ButterfliesState)engine.getGameState();
        GameConfig config = engine.getGameManager().getGameConfig();
        JPanel panel = new JPanel(new FlowLayout(0, 50, 0));
        panel.add(this.createCaughtPreyPanel(state, config));
        panel.add(this.createSavePreyPanel(state, config));
        return panel;
    }

    protected JLabel getPartImageLabel(Part part) {
        return new JLabel(part.getImage());
    }

    protected JPanel createCaughtPreyPanel(ButterfliesState state, GameConfig config) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getPartImageLabel(ButterfliesGamePanel.getChaserPart(config)), "West");
        panel.add((Component)this.createPreyListPanel(state.getCaughtPrey(), config), "Center");
        return panel;
    }

    protected JPanel createSavePreyPanel(ButterfliesState state, GameConfig config) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getPartImageLabel(ButterfliesGamePanel.getBurrowPart(config)), "West");
        panel.add((Component)this.createPreyListPanel(state.getSavePrey(), config), "Center");
        return panel;
    }

    protected JPanel createPreyListPanel(Collection<PREYCOLOR> preyList, GameConfig config) {
        JPanel panel = new JPanel(new FlowLayout(0, 10, 0));
        for (PREYCOLOR prey : preyList) {
            panel.add(this.getPartImageLabel(ButterfliesGamePanel.getPreyPart(prey, config)));
        }
        return panel;
    }

    @Override
    public PreviewPanel getPreviewPanel(PartsDlg dlg, int width, int height) {
        return null;
    }
}

