/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.butterflies.desktop.ui.game;

import com.tjger.butterflies.desktop.game.ButterfliesRules;
import com.tjger.butterflies.desktop.game.ButterfliesState;
import com.tjger.butterflies.desktop.game.DICECOLOR;
import com.tjger.butterflies.desktop.game.PREYCOLOR;
import com.tjger.butterflies.desktop.ui.game.GamePanelMouseListener;
import hgb.lib.HGBaseTools;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import tjger.game.GamePlayer;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.PlayingFieldManager;
import tjger.gui.GamePanel;
import tjger.gui.completed.Part;
import tjger.gui.completed.PartSet;
import tjger.gui.completed.playingfield.PlayingFieldPaintUtil;
import tjger.gui.completed.playingfield.SingleFieldPainter;
import tjger.gui.completed.playingfield.SingleFieldPartPainter;
import tjger.lib.PartUtil;

public class ButterfliesGamePanel
extends GamePanel {
    public static final String PROPERTY_KEY_TYPE = "type";
    public static final String PROPERTY_VALUE_PREY_START = "startprey";
    public static final String PROPERTY_VALUE_CHASER_START = "startchaser";
    public static final String PROPERTY_VALUE_BURROW = "burrow";
    private static final String PROPERTY_VALUE_DICE_POS = "dice";
    private static final String PROPERTY_VALUE_CAUGHT_PREY_POS = "caughtprey";
    private static final String PROPERTY_VALUE_PLAYERNAME_POS = "playername";
    public static final String ARRANGEMENT_HAREHUNT = "arrange_harehunt";
    public static final String ARRANGEMENT_BUTTERFLYHUNT = "arrange_butterflyhunt";
    private static final String PART_TYPE_CHASER = "chaser_figure";
    private static final String PART_TYPE_FIELDIMAGE = "fieldimage";
    private static final String PART_COLOR_CHASER = "chaser";
    private static final String PART_COLOR_BURROW = "burrow";
    private static final String PART_COLOR_PREY_MARKER = "marker";
    private static final String PART_TYPE_CHASER_PART = "chaser_figure.part";
    private static final String PART_TYPE_PREY = "prey_figure";
    private static final String PART_TYPE_PREY_MARKER = "prey_marker";
    private static final String PART_TYPE_PREY_PART = "prey_figure.part";
    private static final String PART_TYPE_DICE = "dice";
    public static final int X_SPACING_PREY = 30;
    public static final int Y_SPACING_PREY = 15;
    private static final int PLAYINGFIELD_ZOOM = 100;
    public static final int PREY_HORIZONTAL_ALIGNMENT = 0;
    public static final int PREY_VERTICAL_ALIGNMENT = 0;
    private final SingleFieldPainter fieldPainter = new SingleFieldPartPainter("fieldimage", 100);

    public ButterfliesGamePanel() {
        this.addMouseListener(new GamePanelMouseListener(this, this.getButterfliesState(), (ButterfliesRules)this.getGameRules(), this.getGameEngine()));
    }

    public static String getActiveArrangementName() {
        return GameConfig.getInstance().getActiveArrangement().getName();
    }

    public static PlayingField getActivePlayingField() {
        String arrangementName = ButterfliesGamePanel.getActiveArrangementName();
        String fieldName = null;
        if (ARRANGEMENT_HAREHUNT.equals(arrangementName)) {
            fieldName = "harehunt";
        } else if (ARRANGEMENT_BUTTERFLYHUNT.equals(arrangementName)) {
            fieldName = "butterflyhunt";
        }
        if (fieldName != null) {
            return PlayingFieldManager.getInstance().getField(fieldName);
        }
        return null;
    }

    private ButterfliesState getButterfliesState() {
        return (ButterfliesState)this.getGameState();
    }

    @Override
    protected int getAnimationDuration() {
        return 200;
    }

    @Override
    protected int getAnimationSteps() {
        return 50;
    }

    @Override
    protected boolean shallAnimatePart(Part part, int x, int y) {
        String type = part.getType();
        return PART_TYPE_CHASER_PART.equals(type) || PART_TYPE_PREY_PART.equals(type);
    }

    @Override
    protected void paintParts(Graphics g) {
        super.paintParts(g);
        GameEngine gameEngine = this.getGameEngine();
        if (gameEngine.isActiveGame() || !gameEngine.isStoppedGame()) {
            ButterfliesState state = this.getButterfliesState();
            PlayingField field = ButterfliesGamePanel.getActivePlayingField();
            this.paintPlayingField(field, g);
            this.paintFigures(field, state, g);
            this.paintDice(field, state, g);
            this.paintPlayerName(field, state, g);
        }
    }

    private void paintPlayingField(PlayingField field, Graphics g) {
        if (field != null) {
            PlayingFieldPaintUtil.drawAllFields(field, this.fieldPainter, this, g);
        }
    }

    private void paintFigures(PlayingField field, ButterfliesState state, Graphics g) {
        this.paintChaserFigure(field, state, g);
        this.paintPreyFigures(field, state, g);
    }

    private Part getChaserPart() {
        return ButterfliesGamePanel.getChaserPart(this.getGameConfig());
    }

    public static Part getChaserPart(GameConfig config) {
        PartSet partSet = config.getActivePartSet(PART_TYPE_CHASER);
        return partSet.getPart(PART_COLOR_CHASER, 0);
    }

    private void paintChaserFigure(PlayingField field, ButterfliesState state, Graphics g) {
        this.drawPart(field, state.getChaserPosition(), 0, -1, this.getChaserPart(), g);
    }

    private Part[] getPreyParts(PartSet partSet, Collection<PREYCOLOR> preys) {
        return this.getPreyParts(partSet, preys.toArray(new PREYCOLOR[0]));
    }

    public Part[] getPreyParts(PartSet partSet, PREYCOLOR[] preys) {
        Part[] preyParts = new Part[preys.length];
        int i = 0;
        while (i < preys.length) {
            preyParts[i] = partSet.getPart(preys[i].getPartColor(), 0);
            ++i;
        }
        return preyParts;
    }

    public PartSet getPreyPartSet() {
        return ButterfliesGamePanel.getPreyPartSet(this.getGameConfig());
    }

    private static PartSet getPreyPartSet(GameConfig config) {
        return config.getActivePartSet(PART_TYPE_PREY);
    }

    private Part getPreyMarkerPart() {
        return ButterfliesGamePanel.getPreyMarkerPart(this.getGameConfig());
    }

    private static Part getPreyMarkerPart(GameConfig config) {
        PartSet partSet = config.getActivePartSet(PART_TYPE_PREY_MARKER);
        return partSet.getPart(PART_COLOR_PREY_MARKER, 0);
    }

    private void paintPreyFigures(PlayingField field, ButterfliesState state, Graphics g) {
        PartSet partSet = this.getPreyPartSet();
        this.paintFreePreyFigures(field, state, partSet, g);
        this.paintCaughtPreyFigures(field, state, partSet, g);
    }

    private void paintFreePreyFigures(PlayingField field, ButterfliesState state, PartSet partSet, Graphics g) {
        Map<String, Set<PREYCOLOR>> preyPositions = state.getPreyPositions();
        Set<String> fieldPositions = preyPositions.keySet();
        Part preyMarkerPart = this.getPreyMarkerPart();
        for (String fieldPos : fieldPositions) {
            if (!HGBaseTools.hasContent(fieldPos)) continue;
            Set<PREYCOLOR> preys = preyPositions.get(fieldPos);
            if (state.mustChoosePrey() && state.isPreyFreeField(field, fieldPos)) {
                Part[] markerParts = PartUtil.multiplyParts(preyMarkerPart, preys.size());
                this.drawParts(field, fieldPos, 0, 0, markerParts, 30, 15, g);
            }
            this.drawParts(field, fieldPos, 0, 0, this.getPreyParts(partSet, preys), 30, 15, g);
        }
    }

    private void paintCaughtPreyFigures(PlayingField field, ButterfliesState state, PartSet partSet, Graphics g) {
        this.drawParts(field, this.getCaughtPreyPosition(field), 0, 0, this.getPreyParts(partSet, state.getCaughtPrey()), 30, 15, g);
    }

    private String getCaughtPreyPosition(PlayingField field) {
        return field.getFirstFieldWithProperty(PROPERTY_KEY_TYPE, PROPERTY_VALUE_CAUGHT_PREY_POS).getId();
    }

    public String getDicePosition(PlayingField field) {
        return field.getFirstFieldWithProperty(PROPERTY_KEY_TYPE, "dice").getId();
    }

    private void paintDice(PlayingField field, ButterfliesState state, Graphics g) {
        this.drawPart(field, this.getDicePosition(field), 1, 1, this.getDicePart(state, state.getCurrentDiceColor()), g);
    }

    public Part getDicePart(ButterfliesState state, DICECOLOR diceColor) {
        PartSet partset = this.getGameConfig().getActivePartSet("dice");
        return partset.getPart(diceColor.getPartColor(), diceColor.getPartSequence(state));
    }

    private String getPlayerNamePosition(PlayingField field) {
        return field.getFirstFieldWithProperty(PROPERTY_KEY_TYPE, PROPERTY_VALUE_PLAYERNAME_POS).getId();
    }

    private void paintPlayerName(PlayingField field, ButterfliesState state, Graphics g) {
        if (state.mustChoosePrey()) {
            return;
        }
        this.changeColor(Color.WHITE, g);
        this.changeFont(50.0f, g);
        GamePlayer currentPlayer = this.getGameEngine().getCurrentPlayer();
        if (currentPlayer == null) {
            return;
        }
        this.drawString(currentPlayer.getName(), field, this.getPlayerNamePosition(field), 0, g);
    }

    public boolean isHumanActionAllowed() {
        return this.isHumanPlayer();
    }

    public static Part getBurrowPart(GameConfig config) {
        PartSet partSet = config.getActivePartSet(PART_TYPE_FIELDIMAGE);
        return partSet.getPart("burrow", 0);
    }

    public static Part getPreyPart(PREYCOLOR prey, GameConfig config) {
        return ButterfliesGamePanel.getPreyPartSet(config).getPart(prey.getPartColor(), 0);
    }
}

