/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.butterflies.desktop.ui.game;

import com.tjger.butterflies.desktop.game.ButterfliesRules;
import com.tjger.butterflies.desktop.game.ButterfliesState;
import com.tjger.butterflies.desktop.game.PREYCOLOR;
import com.tjger.butterflies.desktop.game.move.MovePreyMove;
import com.tjger.butterflies.desktop.game.move.RollDiceMove;
import com.tjger.butterflies.desktop.ui.game.ButterfliesGamePanel;
import hgb.lib.HGBaseTools;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Set;
import tjger.game.MoveInformation;
import tjger.game.completed.GameEngine;
import tjger.game.completed.playingfield.PlayingField;
import tjger.gui.completed.Part;
import tjger.gui.completed.PartSet;
import tjger.lib.PartUtil;

public class GamePanelMouseListener
extends MouseAdapter {
    private ButterfliesGamePanel gamePanel;
    private ButterfliesState state;
    private ButterfliesRules rules;
    private GameEngine engine;

    public GamePanelMouseListener(ButterfliesGamePanel gamePanel, ButterfliesState state, ButterfliesRules rules, GameEngine engine) {
        this.gamePanel = gamePanel;
        this.state = state;
        this.rules = rules;
        this.engine = engine;
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        super.mouseClicked(ev);
        if (!this.gamePanel.isHumanActionAllowed()) {
            return;
        }
        if (ev.getClickCount() == 1 && ev.getButton() == 1) {
            PlayingField field = ButterfliesGamePanel.getActivePlayingField();
            this.performMove(this.state, this.rules, this.gamePanel, this.engine, field, this.gamePanel.getMouseX(), this.gamePanel.getMouseY());
        }
    }

    private void performMove(ButterfliesState state, ButterfliesRules rules, ButterfliesGamePanel gamePanel, GameEngine engine, PlayingField field, int x, int y) {
        MoveInformation move = null;
        if (this.wasDiceClicked(state, rules, gamePanel, field, x, y)) {
            move = new RollDiceMove();
        } else {
            PREYCOLOR clickedPrey = this.getClickedPrey(state, rules, gamePanel, field, x, y);
            if (clickedPrey != null) {
                move = new MovePreyMove(clickedPrey);
            }
        }
        if (move != null) {
            engine.getCurrentPlayer().performMove(move);
        }
    }

    private boolean wasDiceClicked(ButterfliesState state, ButterfliesRules rules, ButterfliesGamePanel gamePanel, PlayingField field, int x, int y) {
        return rules.isRollDiceAllowed(state) ? PartUtil.getSelectedPart(gamePanel.getDicePart(state, state.getCurrentDiceColor()), x, y, field, gamePanel.getDicePosition(field), 100) : false;
    }

    private PREYCOLOR getClickedPrey(ButterfliesState state, ButterfliesRules rules, ButterfliesGamePanel gamePanel, PlayingField field, int x, int y) {
        if (!rules.isMovePreyAllowed(state)) {
            return null;
        }
        Map<String, Set<PREYCOLOR>> preyPositions = state.getPreyPositions();
        Set<String> fieldPositions = preyPositions.keySet();
        PartSet partSet = gamePanel.getPreyPartSet();
        for (String fieldPos : fieldPositions) {
            PREYCOLOR[] preys;
            Part[] parts;
            int partIndex;
            if (!HGBaseTools.hasContent(fieldPos) || (partIndex = PartUtil.getSelectedPart(parts = gamePanel.getPreyParts(partSet, preys = preyPositions.get(fieldPos).toArray(new PREYCOLOR[0])), x, y, field, fieldPos, 0, 0, 30, 15)) == -1) continue;
            return rules.isMovePreyAllowed(state, preys[partIndex]) ? preys[partIndex] : null;
        }
        return null;
    }
}

