/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui;

import hgb.gui.HGBaseFileFilter;
import hgb.gui.util.JValidValueSlider;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import hgb.lib.internal.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class HGBaseGuiTools {
    private static final Map<String, ImageIcon> imageMap = new HashMap<String, ImageIcon>();

    public static JComboBox<Integer> createRangeComboBox(int min, int max, int diff, int width, int height) {
        JComboBox<Integer> cb = new JComboBox<Integer>();
        if (max < min) {
            int help = max;
            max = min;
            min = help;
        }
        int start = Math.min(min, max);
        int end = Math.max(min, max);
        int i = start;
        while (i <= end) {
            cb.addItem(i);
            i += diff;
        }
        cb.setPreferredSize(new Dimension(width, height));
        return cb;
    }

    public static <T> JComboBox<T> createArrayComboBox(T[] list, int width, int height) {
        JComboBox<T> cb = new JComboBox<T>();
        int i = 0;
        while (list != null && i < list.length) {
            if (list[i] != null) {
                cb.addItem(list[i]);
            }
            ++i;
        }
        cb.setPreferredSize(new Dimension(width, height));
        return cb;
    }

    public static JSlider createRangeSlider(int min, int max, int diff, int width, int height) {
        JValidValueSlider slider = new JValidValueSlider(min, max, min);
        slider.setMinorTickSpacing(diff);
        slider.setSnapToTicks(true);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setPreferredSize(new Dimension(width, height));
        return slider;
    }

    private static JFileChooser createFileChooser(HGBaseFileFilter filter, int selectionMode, String path) {
        File swingFile;
        String currDir;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(selectionMode);
        if (filter != null) {
            fc.setFileFilter(filter);
        }
        String setDir = currDir = String.valueOf(HGBaseFileTools.getCurrentDir()) + File.separator;
        if (path != null && path.length() > 0) {
            setDir = String.valueOf(setDir) + path + File.separator;
        }
        if ((swingFile = new File(setDir)).exists()) {
            fc.setCurrentDirectory(swingFile);
        }
        return fc;
    }

    public static JFileChooser createFileChooser(String description, String extensions, String path) {
        HGBaseFileFilter filter = null;
        if (extensions != null) {
            filter = new HGBaseFileFilter();
            StringTokenizer st = new StringTokenizer(extensions, ";");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                filter.addExtension(t);
            }
            if (description != null) {
                filter.setDescription(description);
            }
        }
        return HGBaseGuiTools.createFileChooser(filter, 0, path);
    }

    public static JFileChooser createFolderChooser(String path) {
        return HGBaseGuiTools.createFileChooser(null, 1, path);
    }

    public static void setFontBold(JComponent field) {
        Font tfFont = field.getFont();
        field.setFont(tfFont.deriveFont(1));
    }

    public static Color getBackgroundColor() {
        return new JPanel().getBackground();
    }

    public static Color getBackgroundColorDarker() {
        Color back = HGBaseGuiTools.getBackgroundColor();
        return new Color(back.getRed() - 5, back.getGreen() - 5, back.getBlue() - 5);
    }

    public static Color getFieldBackgroundColor() {
        return new JTextField("").getBackground();
    }

    public static Color getSelectColor() {
        return new JTextField("").getSelectionColor();
    }

    public static Color getSelectTextColor() {
        return new JTextField("").getSelectedTextColor();
    }

    public static Color getTooltipColor() {
        return new JToolTip().getBackground();
    }

    public static int getFieldHeight() {
        int h = HGBaseTools.toInt(HGBaseSettings.get("fieldHeight"));
        return h == -2147483631 ? 18 : h;
    }

    public static Color getForegroundColor(boolean label) {
        if (label) {
            return new JLabel("").getForeground();
        }
        return new JTextField("").getForeground();
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static void setEnabledNullSafe(Component c, boolean enable) {
        if (c != null) {
            c.setEnabled(enable);
        }
    }

    public static ImageIcon loadImage(String file) {
        if (file != null && file.getClass() != null) {
            URL url;
            ImageIcon img = imageMap.get(file);
            if (img == null && (img = HGBaseGuiTools.loadImage(url = HGBaseGuiTools.class.getResource(file))) != null) {
                imageMap.put(file, img);
            }
            return img;
        }
        return null;
    }

    public static ImageIcon loadImage(URL url) {
        ImageIcon img = null;
        if (url != null && (img = new ImageIcon(url)).getIconHeight() < 0) {
            img = null;
        }
        return img;
    }

    public static JScrollPane createScrollPane(JComponent component, int w, int h, boolean alwaysShowScrollbars) {
        JScrollPane scroller = new JScrollPane();
        if (alwaysShowScrollbars) {
            scroller.setHorizontalScrollBarPolicy(32);
            scroller.setVerticalScrollBarPolicy(22);
        } else {
            scroller.setHorizontalScrollBarPolicy(30);
            scroller.setVerticalScrollBarPolicy(20);
        }
        scroller.getHorizontalScrollBar().setUnitIncrement(50);
        scroller.getVerticalScrollBar().setUnitIncrement(50);
        JViewport vp = scroller.getViewport();
        vp.setPreferredSize(new Dimension(w, h));
        vp.add(component);
        return scroller;
    }

    public static ImageIcon getBrighterImage(Component imgComp, ImageIcon img) {
        return HGBaseGuiTools.getModifiedImage(imgComp, img, 150);
    }

    public static ImageIcon getDarkerImage(Component imgComp, ImageIcon img) {
        return HGBaseGuiTools.getModifiedImage(imgComp, img, 50);
    }

    private static ImageIcon getModifiedImage(Component imgComp, ImageIcon img, int percent) {
        if (img != null) {
            ImageProducer imgProd = img.getImage().getSource();
            HGBaseColorPercentImgFilter imgFilter = new HGBaseColorPercentImgFilter(percent);
            Image modifiedImg = imgComp.createImage(new FilteredImageSource(imgProd, imgFilter));
            return new ImageIcon(modifiedImg);
        }
        return null;
    }

    public static Polygon createPolygon(Point[] positions) {
        int[] x = new int[positions.length];
        int[] y = new int[positions.length];
        int i = 0;
        while (i < positions.length) {
            x[i] = positions[i].x;
            y[i] = positions[i].y;
            ++i;
        }
        return new Polygon(x, y, positions.length);
    }

    public static boolean isPointInPolygon(Point point, Point[] polygon) {
        return HGBaseGuiTools.createPolygon(polygon).contains(point);
    }

    public static Point getCenterOfPolygon(Point ... polygon) {
        if (polygon == null || polygon.length == 0) {
            return null;
        }
        if (polygon.length == 1) {
            return polygon[0];
        }
        if (polygon.length == 2) {
            int leftX = Math.min(polygon[0].x, polygon[1].x);
            int rightX = Math.max(polygon[0].x, polygon[1].x);
            int centerX = leftX + (rightX - leftX + 1) / 2;
            int topY = Math.min(polygon[0].y, polygon[1].y);
            int bottomY = Math.max(polygon[0].y, polygon[1].y);
            int centerY = topY + (bottomY - topY + 1) / 2;
            return new Point(centerX, centerY);
        }
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        while (i < polygon.length) {
            x += (double)polygon[i].x;
            y += (double)polygon[i].y;
            ++i;
        }
        return new Point((int)(x /= (double)polygon.length), (int)(y /= (double)polygon.length));
    }

    public static void openURLwithBrowser(URL urlToOpen) {
        if (!HGBaseGuiTools.openURLDesktop(urlToOpen)) {
            BrowserLauncher.openURL(urlToOpen.toString());
        }
    }

    private static boolean openURLDesktop(URL url) {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()) != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(url.toURI());
                return true;
            }
            catch (IOException | URISyntaxException e) {
                return false;
            }
        }
        return false;
    }

    public static Set<Component> getAllCompenentsByState(Container parent, final boolean enabled) {
        final Set<Component> components = Collections.newSetFromMap(new WeakHashMap());
        new HierarchyWalker(){

            @Override
            protected void perform(Component component) {
                if (component.isEnabled() == enabled) {
                    components.add(component);
                }
            }
        }.walk(parent);
        return components;
    }

    public static void enableAllComponents(Container parent, Component ... except) {
        HashSet<Component> exceptSet = new HashSet<Component>(Arrays.asList(except));
        new EnableDisableWalker(true, exceptSet).walk(parent);
    }

    public static void disableAllComponents(Container parent, Component ... except) {
        HashSet<Component> exceptSet = new HashSet<Component>(Arrays.asList(except));
        new EnableDisableWalker(false, exceptSet).walk(parent);
    }

    public static ImageIcon getScaledImageIcon(ImageIcon icon, int width, int height) {
        if (icon == null) {
            return null;
        }
        return new ImageIcon(icon.getImage().getScaledInstance(width, height, 4));
    }

    private static class EnableDisableWalker
    extends HierarchyWalker {
        private final boolean enable;
        private final Set<Component> exceptSet;

        public EnableDisableWalker(boolean enable, Set<Component> exceptSet) {
            this.enable = enable;
            this.exceptSet = exceptSet;
        }

        @Override
        protected void perform(Component component) {
            if (!this.exceptSet.contains(component)) {
                component.setEnabled(this.enable);
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).setEditable(this.enable);
                }
            }
        }
    }

    private static class HGBaseColorPercentImgFilter
    extends RGBImageFilter {
        int percent;

        public HGBaseColorPercentImgFilter(int percent) {
            this.canFilterIndexColorModel = true;
            this.percent = percent;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            r = Math.min(255, r * this.percent / 100);
            g = Math.min(255, g * this.percent / 100);
            b = Math.min(255, b * this.percent / 100);
            return (rgb & 0xFF000000) + (r << 16) + (g << 8) + b;
        }
    }

    private static abstract class HierarchyWalker {
        private HierarchyWalker() {
        }

        public final void walk(Container parent) {
            this.perform(parent);
            Component[] componentArray = parent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                if (child instanceof JTable) {
                    JTable table = (JTable)child;
                    this.walk((Container)child);
                    int rows = table.getRowCount();
                    int cols = table.getColumnCount();
                    int x = 0;
                    while (x < rows) {
                        int y = 0;
                        while (y < cols) {
                            TableCellRenderer renderer;
                            TableCellEditor editor = table.getCellEditor(x, y);
                            if (editor instanceof Component) {
                                this.perform((Component)((Object)editor));
                            }
                            if ((renderer = table.getCellRenderer(x, y)) instanceof Component) {
                                this.perform((Component)((Object)renderer));
                            }
                            ++y;
                        }
                        ++x;
                    }
                } else if (child instanceof Container) {
                    this.walk((Container)child);
                } else if (child != null && !child.isVisible()) {
                    this.perform(child);
                }
                ++n2;
            }
        }

        protected abstract void perform(Component var1);
    }
}

