/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui;

import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBasePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class HGBaseMultiTextPanel
extends HGBasePanel {
    private static final long serialVersionUID = 424781075L;
    protected HGBasePanel[] pnMulti = null;
    protected JLabel[] txtLabel = null;
    protected int centeredPanel = -1;
    protected int height;
    protected boolean alwaysTooltip;
    protected boolean hasSeperators;
    protected boolean hasTextFieldFont;
    protected boolean hasBorder;

    public HGBaseMultiTextPanel(int[] panelWidths, int panelHeight, boolean hasBorder, boolean hasSeperators, boolean hasTextFieldFont, boolean alwaysTooltip) {
        super(new BorderLayout());
        this.height = panelHeight;
        this.hasBorder = hasBorder;
        this.hasSeperators = hasSeperators;
        this.hasTextFieldFont = hasTextFieldFont;
        this.alwaysTooltip = alwaysTooltip;
        this.createPanels(panelWidths);
        this.setFocusable(false);
        if (hasBorder) {
            this.setBorder(new LineBorder(HGBaseGuiTools.getBackgroundColor().darker(), 1));
        }
    }

    private Font getTextFont() {
        float fontSize = (float)this.height * 0.6f;
        return new JTextField().getFont().deriveFont(1, fontSize);
    }

    @Override
    public void actualizeLaf() {
        if (this.hasTextFieldFont) {
            Font defaultFont = this.getTextFont();
            int i = 0;
            while (this.txtLabel != null && i < this.txtLabel.length) {
                this.txtLabel[i].setFont(defaultFont);
                ++i;
            }
        }
    }

    public int length() {
        return this.pnMulti == null ? 0 : this.pnMulti.length;
    }

    private void createPanels(int[] panels) {
        int nullPanels = this.countNullPanels(panels);
        int numPanels = panels.length;
        if (nullPanels == 0) {
            ++numPanels;
        } else if (nullPanels > 1) {
            numPanels = numPanels - nullPanels + 1;
        }
        this.pnMulti = new HGBasePanel[numPanels];
        this.txtLabel = new JLabel[numPanels];
        HGBasePanel pnWest = new HGBasePanel(new GridBagLayout());
        pnWest.setOpaque(false);
        HGBasePanel pnCenter = new HGBasePanel(new BorderLayout());
        pnCenter.setOpaque(false);
        HGBasePanel pnEast = new HGBasePanel(new GridBagLayout());
        pnEast.setOpaque(false);
        int idx = 0;
        if (nullPanels == 0) {
            HGBasePanel pn = this.createPanel(idx, 0);
            pnCenter.add(pn);
            this.centeredPanel = idx;
            idx = 1;
        }
        int i = 0;
        while (i < panels.length) {
            HGBasePanel pn;
            if (panels[i] == 0) {
                if (this.centeredPanel < 0) {
                    pn = this.createPanel(idx, 0);
                    pnCenter.add(pn);
                    this.centeredPanel = idx++;
                }
            } else {
                pn = this.createPanel(idx, panels[i]);
                if (this.centeredPanel >= 0) {
                    if (this.hasSeperators) {
                        pnEast.add(this.createSeparator());
                    }
                    pnEast.add(pn);
                } else {
                    pnWest.add(pn);
                    if (this.hasSeperators) {
                        pnWest.add(this.createSeparator());
                    }
                }
                ++idx;
            }
            ++i;
        }
        this.add((Component)pnWest, "West");
        this.add((Component)pnCenter, "Center");
        this.add((Component)pnEast, "East");
    }

    private JSeparator createSeparator() {
        JSeparator s = new JSeparator(1);
        s.setPreferredSize(new Dimension(3, this.height - 2));
        return s;
    }

    private HGBasePanel createPanel(int idx, int width) {
        HGBasePanel pn = new HGBasePanel(new BorderLayout());
        pn.setOpaque(false);
        pn.setFocusable(false);
        JLabel txt = new JLabel(){
            private static final long serialVersionUID = 189670726985750934L;

            @Override
            public Point getToolTipLocation(MouseEvent event) {
                return new Point(event.getX(), event.getY() - 20);
            }
        };
        if (this.hasTextFieldFont) {
            txt.setFont(this.getTextFont());
        }
        txt.setBorder(null);
        txt.setFocusable(false);
        pn.add((Component)txt, "Center");
        if (width > 0) {
            pn.setPreferredSize(new Dimension(width, this.height));
        }
        this.pnMulti[idx] = pn;
        this.txtLabel[idx] = txt;
        return pn;
    }

    private int countNullPanels(int[] panels) {
        int num = 0;
        int i = 0;
        while (i < panels.length) {
            if (panels[i] == 0) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public HGBasePanel getPanel(int index) {
        if (index < 0 || index >= this.pnMulti.length) {
            return null;
        }
        return this.pnMulti[index];
    }

    public JLabel getLabel(int index) {
        if (index < 0 || index >= this.pnMulti.length) {
            return null;
        }
        return this.txtLabel[index];
    }

    public void setText(int index, String text) {
        if (index >= 0 && index < this.pnMulti.length) {
            this.txtLabel[index].setText(" " + text);
            if (this.alwaysTooltip) {
                this.txtLabel[index].setToolTipText(text);
            }
        }
    }
}

