/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.util.fontchooser;

import hgb.gui.util.AbstractDialog;
import hgb.gui.util.fontchooser.HGBaseFontChangedEvent;
import hgb.gui.util.fontchooser.HGBaseFontChangedListener;
import hgb.gui.util.fontchooser.HGBaseFontStyle;
import hgb.lib.HGBaseText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HGBaseFontChooser
extends JComponent
implements ListSelectionListener {
    private static final long serialVersionUID = -1339379186264313412L;
    private static final String MSG_FONT_FAMILY = "dlg.fontfamily";
    private static final String MSG_FONT_STYLE = "dlg.fontstyle";
    private static final String MSG_FONT_SIZE = "dlg.fontsize";
    private static final String MSG_FONT_SAMPLE = "dlg.fontsample";
    private static final String LOREM_IPSUM = "Lorem ipsum dolor sit amet, consectetaur adipisicing...";
    private static final int GAP = 20;
    private JList<String> fontFamilyList;
    private JList<HGBaseFontStyle> fontStyleList;
    private JList<Integer> fontSizeList;
    private JTextField sampleTextField;
    private Vector<HGBaseFontChangedListener> fontChangedListeners = new Vector();
    private int lastSelectedFontFamilyIndex = -1;
    private int lastSelectedFontStyleIndex = -1;
    private int lastSelectedFontSizeIndex = -1;

    public HGBaseFontChooser() {
        this.fontFamilyList = this.createFontFamilyList();
        this.fontStyleList = this.createFontStyleList();
        this.fontSizeList = this.createFontSizeList();
        this.sampleTextField = this.createSampleTextPane();
    }

    public final void addFontChangedListener(HGBaseFontChangedListener l) {
        if (!this.fontChangedListeners.contains(l)) {
            this.fontChangedListeners.add(l);
        }
    }

    public final void removeFontChangedListener(HGBaseFontChangedListener l) {
        this.fontChangedListeners.remove(l);
    }

    protected JPanel getPanel() {
        JPanel pnChooser = new JPanel(new BorderLayout(20, 20));
        JPanel pnFontFamilyStyle = new JPanel(new BorderLayout(20, 0));
        pnFontFamilyStyle.add((Component)this.getFontFamilyPanel(), "Center");
        pnFontFamilyStyle.add((Component)this.getFontStylePanel(), "East");
        pnChooser.add((Component)pnFontFamilyStyle, "Center");
        pnChooser.add((Component)this.getFontSizePanel(), "East");
        pnChooser.add((Component)this.getSamplePanel(), "South");
        return pnChooser;
    }

    protected JPanel getFontFamilyPanel() {
        JPanel pnFamily = new JPanel(new BorderLayout());
        pnFamily.add((Component)new JLabel(HGBaseText.getText(MSG_FONT_FAMILY, new String[0])), "North");
        JScrollPane scrollPane = new JScrollPane(this.getFontFamilyList(), 20, 30);
        scrollPane.setPreferredSize(new Dimension(250, 150));
        pnFamily.add((Component)scrollPane, "Center");
        return pnFamily;
    }

    protected JPanel getFontStylePanel() {
        JPanel pnStyle = new JPanel(new BorderLayout());
        pnStyle.add((Component)new JLabel(HGBaseText.getText(MSG_FONT_STYLE, new String[0])), "North");
        JScrollPane scrollPane = new JScrollPane(this.getFontStyleList(), 20, 30);
        scrollPane.setPreferredSize(new Dimension(150, 0));
        pnStyle.add((Component)scrollPane, "Center");
        return pnStyle;
    }

    protected JPanel getFontSizePanel() {
        JPanel pnSize = new JPanel(new BorderLayout());
        pnSize.add((Component)new JLabel(HGBaseText.getText(MSG_FONT_SIZE, new String[0])), "North");
        JScrollPane scrollPane = new JScrollPane(this.getFontSizeList(), 20, 30);
        scrollPane.setPreferredSize(new Dimension(50, 0));
        pnSize.add((Component)scrollPane, "Center");
        return pnSize;
    }

    protected JPanel getSamplePanel() {
        JPanel pnSample = new JPanel(new BorderLayout());
        pnSample.add((Component)new JLabel(HGBaseText.getText(MSG_FONT_SAMPLE, new String[0])), "North");
        pnSample.add((Component)this.getSampleTextField(), "Center");
        return pnSample;
    }

    protected JList<String> createFontFamilyList() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        JList<String> lFamily = new JList<String>(env.getAvailableFontFamilyNames());
        lFamily.setSelectionMode(0);
        lFamily.addListSelectionListener(this);
        lFamily.setSelectedIndex(0);
        return lFamily;
    }

    protected JList<String> getFontFamilyList() {
        return this.fontFamilyList;
    }

    protected JList<HGBaseFontStyle> createFontStyleList() {
        JList<HGBaseFontStyle> lStyle = new JList<HGBaseFontStyle>(HGBaseFontStyle.values());
        lStyle.setSelectionMode(0);
        lStyle.addListSelectionListener(this);
        lStyle.setSelectedIndex(0);
        return lStyle;
    }

    protected JList<HGBaseFontStyle> getFontStyleList() {
        return this.fontStyleList;
    }

    protected JList<Integer> createFontSizeList() {
        Integer[] sizes = new Integer[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 56, 64, 72};
        JList<Integer> lSize = new JList<Integer>(sizes);
        lSize.setSelectionMode(0);
        lSize.addListSelectionListener(this);
        lSize.setSelectedIndex(0);
        return lSize;
    }

    protected JList<Integer> getFontSizeList() {
        return this.fontSizeList;
    }

    protected JTextField createSampleTextPane() {
        JTextField textField = new JTextField();
        textField.setBorder(new EtchedBorder(1));
        textField.setText(this.getSampleText());
        textField.setEditable(false);
        textField.setHorizontalAlignment(0);
        textField.setPreferredSize(new Dimension(0, 50));
        return textField;
    }

    protected JTextField getSampleTextField() {
        return this.sampleTextField;
    }

    protected String getSampleText() {
        return LOREM_IPSUM;
    }

    protected Font getSelectedFont() {
        String family = this.getFontFamilyList().getSelectedValue();
        HGBaseFontStyle style = this.getFontStyleList().getSelectedValue();
        Integer size = this.getFontSizeList().getSelectedValue();
        Font font = null;
        if (family != null && style != null && size != null) {
            font = new Font(family, style.getStyle(), size);
        }
        return font;
    }

    protected void ensureIndexIsVisible() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HGBaseFontChooser.this.getFontFamilyList().ensureIndexIsVisible(HGBaseFontChooser.this.getFontFamilyList().getSelectedIndex());
                HGBaseFontChooser.this.getFontStyleList().ensureIndexIsVisible(HGBaseFontChooser.this.getFontStyleList().getSelectedIndex());
                HGBaseFontChooser.this.getFontSizeList().ensureIndexIsVisible(HGBaseFontChooser.this.getFontSizeList().getSelectedIndex());
            }
        });
    }

    protected void setSelectedFont(Font font) {
        if (font != null) {
            this.getFontFamilyList().setSelectedValue(font.getFamily(), true);
            this.getFontStyleList().setSelectedValue((Object)HGBaseFontStyle.valueOf(font.getStyle()), true);
            this.getFontSizeList().setSelectedValue(font.getSize(), true);
        } else {
            this.getFontFamilyList().setSelectedIndex(0);
            this.getFontStyleList().setSelectedIndex(0);
            this.getFontSizeList().setSelectedIndex(0);
        }
        this.ensureIndexIsVisible();
        this.setLastSelectedFontIndex();
    }

    protected void setLastSelectedFontIndex() {
        this.lastSelectedFontFamilyIndex = this.getFontFamilyList().getSelectedIndex();
        this.lastSelectedFontStyleIndex = this.getFontStyleList().getSelectedIndex();
        this.lastSelectedFontSizeIndex = this.getFontSizeList().getSelectedIndex();
    }

    protected int getLastSelectedFontFamilyIndex() {
        return this.lastSelectedFontFamilyIndex;
    }

    protected int getLastSelectedFontStyleIndex() {
        return this.lastSelectedFontStyleIndex;
    }

    protected int getLastSelectedFontSizeIndex() {
        return this.lastSelectedFontSizeIndex;
    }

    protected void setSampleTextFieldFont(Font font) {
        this.getSampleTextField().setFont(font);
    }

    protected void ensureAttributeSelected(JList<?> list, int lastSelectedIndex) {
        if (list.getSelectedIndex() == -1) {
            list.setSelectedIndex(lastSelectedIndex == -1 ? 0 : lastSelectedIndex);
        }
    }

    protected void ensureFontSelected() {
        this.ensureAttributeSelected(this.getFontFamilyList(), this.getLastSelectedFontFamilyIndex());
        this.ensureAttributeSelected(this.getFontStyleList(), this.getLastSelectedFontStyleIndex());
        this.ensureAttributeSelected(this.getFontSizeList(), this.getLastSelectedFontSizeIndex());
        this.setLastSelectedFontIndex();
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        if (ev.getSource().equals(this.getFontFamilyList()) || ev.getSource().equals(this.getFontStyleList()) || ev.getSource().equals(this.getFontSizeList())) {
            this.ensureFontSelected();
            Font font = this.getSelectedFont();
            this.setSampleTextFieldFont(font);
            this.fontChanged(font);
        }
    }

    private final void fontChanged(Font font) {
        HGBaseFontChangedEvent ev = new HGBaseFontChangedEvent(this, font);
        Vector temp = (Vector)this.fontChangedListeners.clone();
        for (HGBaseFontChangedListener l : temp) {
            l.fontChanged(ev);
        }
    }

    public static Font showDialog(Frame parent, Font selectedFont) {
        HGBaseFontChooser pane = new HGBaseFontChooser();
        HGBaseFontChooserDlg dlg = new HGBaseFontChooserDlg(parent, pane, selectedFont);
        return dlg.show() ? pane.getSelectedFont() : null;
    }

    protected static class HGBaseFontChooserDlg
    extends AbstractDialog
    implements HGBaseFontChangedListener {
        private static final String MSG_FONT_DLG_TITLE = "dlg.fontdlgtitle";
        private HGBaseFontChooser chooserPane;

        public HGBaseFontChooserDlg(Frame parent, HGBaseFontChooser chooserPane, Font selectedFont) {
            super(parent, HGBaseText.getText(MSG_FONT_DLG_TITLE, new String[0]), true);
            this.chooserPane = chooserPane;
            this.chooserPane.addFontChangedListener(this);
            this.chooserPane.setSelectedFont(selectedFont);
        }

        @Override
        protected JPanel createContentPanel() {
            return this.chooserPane.getPanel();
        }

        @Override
        protected Object[] getOptionButtons() {
            return new Object[]{super.getOkButton(), super.getCancelButton()};
        }

        @Override
        protected Object getDefaultButton() {
            return super.getCancelButton();
        }

        @Override
        protected boolean isOkAllowed() {
            return this.chooserPane.getSelectedFont() != null;
        }

        @Override
        protected boolean isCancelAllowed() {
            return true;
        }

        @Override
        public void fontChanged(HGBaseFontChangedEvent ev) {
            this.enableButtons();
        }
    }
}

