/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.util.waittask;

import hgb.gui.util.waittask.WaitTaskEvent;
import hgb.gui.util.waittask.WaitTaskListener;
import java.util.Vector;
import java.util.concurrent.Callable;

public abstract class WaitTask
implements Callable<Boolean> {
    private Vector<WaitTaskListener> waitTaskListeners = new Vector();

    public final void addWaitTaskListener(WaitTaskListener l) {
        if (!this.waitTaskListeners.contains(l)) {
            this.waitTaskListeners.add(l);
        }
    }

    public final void removeWaitTaskListener(WaitTaskListener l) {
        this.waitTaskListeners.remove(l);
    }

    private final void taskCompleted() {
        WaitTaskEvent ev = new WaitTaskEvent(this);
        Vector temp = (Vector)this.waitTaskListeners.clone();
        for (WaitTaskListener l : temp) {
            l.taskCompleted(ev);
        }
    }

    private final void taskCanceled() {
        WaitTaskEvent ev = new WaitTaskEvent(this);
        Vector temp = (Vector)this.waitTaskListeners.clone();
        for (WaitTaskListener l : temp) {
            l.taskCanceled(ev);
        }
    }

    protected abstract Boolean performTask() throws InterruptedException;

    @Override
    public Boolean call() throws Exception {
        Boolean ret;
        try {
            ret = this.performTask();
            this.taskCompleted();
        }
        catch (InterruptedException e) {
            this.taskCanceled();
            ret = Boolean.FALSE;
        }
        return ret;
    }
}

