/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib;

import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import hgb.lib.internal.IntBooleanStringMap;
import java.awt.Color;
import java.awt.Font;

public final class HGBaseConfig {
    public static final String DEFAULT_LANGUAGE = "lan.en";
    public static final String LANGUAGE_OPTION = "language";
    public static final String LOOKANDFEEL_OPTION = "laf";
    private static final String CONFIGKEY_FONT_FAMILY = "family";
    private static final String CONFIGKEY_FONT_STYLE = "style";
    private static final String CONFIGKEY_FONT_SIZE = "size";
    private static IntBooleanStringMap textOptions = new IntBooleanStringMap();

    private HGBaseConfig() {
    }

    public static int fromFile() {
        String configFileName = HGBaseSettings.get("fileConfig");
        if (HGBaseTools.hasContent(configFileName)) {
            if (textOptions.fromFile(configFileName, "config", "option", "code", "value") == 0) {
                return 0;
            }
            return -10703;
        }
        return 0;
    }

    public static int toFile() {
        String configFileName = HGBaseSettings.get("fileConfig");
        if (HGBaseSettings.getBoolean("fileConfigReadOnly") || !HGBaseTools.hasContent(configFileName)) {
            return 0;
        }
        if (textOptions.toFile(configFileName, "config", "option", "code", "value") == 0) {
            return 0;
        }
        return -10704;
    }

    public static boolean existsKey(String key) {
        return textOptions.existsKey(key);
    }

    public static String[] getKeys() {
        return textOptions.getKeys();
    }

    public static String get(String key) {
        String s = textOptions.get(key);
        if (s != null) {
            return s;
        }
        if (key.equals(LANGUAGE_OPTION)) {
            HGBaseConfig.set(LANGUAGE_OPTION, DEFAULT_LANGUAGE);
            return HGBaseConfig.get(LANGUAGE_OPTION);
        }
        return "";
    }

    public static String get(String key, String defaultValue) {
        return textOptions.get(key, defaultValue);
    }

    public static int getInt(String key) {
        return textOptions.getInt(key);
    }

    public static int getInt(String key, int defaultValue) {
        return textOptions.getInt(key, defaultValue);
    }

    public static boolean getBoolean(String key) {
        return textOptions.getBoolean(key);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return textOptions.getBoolean(key, defaultValue);
    }

    public static Color getColor(String key) {
        int rgb = HGBaseConfig.getInt(key);
        return rgb == -2147483631 ? null : new Color(rgb);
    }

    public static Color getColor(String key, Color defaultColor) {
        Color c = HGBaseConfig.getColor(key);
        return c == null ? defaultColor : c;
    }

    public static Font getFont(String key) {
        String family = HGBaseConfig.get(String.valueOf(key) + CONFIGKEY_FONT_FAMILY);
        int style = HGBaseConfig.getInt(String.valueOf(key) + CONFIGKEY_FONT_STYLE, -2147483631);
        int size = HGBaseConfig.getInt(String.valueOf(key) + CONFIGKEY_FONT_SIZE, -2147483631);
        Font font = null;
        if (HGBaseTools.hasContent(family) && style != -2147483631 && size != -2147483631) {
            font = new Font(family, style, size);
        }
        return font;
    }

    public static Font getFont(String key, Font defaultFont) {
        Font font = HGBaseConfig.getFont(key);
        return font == null ? defaultFont : font;
    }

    public static boolean remove(String key) {
        return textOptions.remove(key);
    }

    public static void set(String key, String option) {
        textOptions.set(key, option);
    }

    public static void set(String key, int option) {
        textOptions.set(key, option);
    }

    public static void set(String key, boolean option) {
        textOptions.set(key, option);
    }

    public static void set(String key, Color color) {
        HGBaseConfig.set(key, String.valueOf(color.getRGB()));
    }

    public static void set(String key, Font font) {
        HGBaseConfig.set(String.valueOf(key) + CONFIGKEY_FONT_FAMILY, font != null ? font.getFamily() : "");
        HGBaseConfig.set(String.valueOf(key) + CONFIGKEY_FONT_STYLE, font != null ? String.valueOf(font.getStyle()) : "");
        HGBaseConfig.set(String.valueOf(key) + CONFIGKEY_FONT_SIZE, font != null ? String.valueOf(font.getSize()) : "");
    }
}

