/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib;

import hgb.gui.HGBaseItem;
import hgb.lib.HGBaseStringBuilder;
import hgb.lib.IFinderListener;
import hgb.lib.internal.SimpleHGBaseItem;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public final class HGBaseTools {
    public static final int INVALID_INT = -2147483631;
    public static final int INVALID = -2147483631;
    public static final float INVALID_FLOAT = -17.00017f;
    public static final double INVALID_DOUBLE = -17.00017;
    public static final long INVALID_LONG = -9223372036854775791L;
    private static final float DIFF_FLOAT = 1.0E-5f;
    private static final float DIFF_DOUBLE = 1.0E-5f;
    private static long lastTime = -1L;

    private HGBaseTools() {
    }

    public static boolean isEven(int value) {
        return value % 2 == 0;
    }

    public static boolean isOdd(int value) {
        return !HGBaseTools.isEven(value);
    }

    public static boolean isValid(float value) {
        return !HGBaseTools.isEqual(value, -17.00017f);
    }

    public static boolean isValid(double value) {
        return !HGBaseTools.isEqual(value, -17.00017);
    }

    public static boolean isValid(int value) {
        return value != -2147483631;
    }

    public static int toInt(String s) {
        try {
            Integer i = Integer.valueOf(s);
            return i;
        }
        catch (NumberFormatException e) {
            return -2147483631;
        }
    }

    public static int toInt(String s, int defaultValue) {
        int value = HGBaseTools.toInt(s);
        return value == -2147483631 ? defaultValue : value;
    }

    public static int toInt(boolean b) {
        return b ? 1 : 0;
    }

    public static float toFloat(String s) {
        try {
            Float f = Float.valueOf(s);
            return f.floatValue();
        }
        catch (NumberFormatException e) {
            return -17.00017f;
        }
    }

    public static double toDouble(String s) {
        try {
            Double d = Double.valueOf(s);
            return d;
        }
        catch (NumberFormatException e) {
            return -17.00017;
        }
    }

    public static double toDouble(String s, double defaultValue) {
        double value = HGBaseTools.toDouble(s);
        return HGBaseTools.isEqual(value, -17.00017) ? defaultValue : value;
    }

    public static long toLong(String s) {
        try {
            Long l = Long.valueOf(s);
            return l;
        }
        catch (NumberFormatException e) {
            return -9223372036854775791L;
        }
    }

    public static long toLong(String s, long defaultValue) {
        long value = HGBaseTools.toLong(s);
        return value == -9223372036854775791L ? defaultValue : value;
    }

    public static boolean isEqual(float f1, float f2) {
        return Math.abs(f1 - f2) < 1.0E-5f;
    }

    public static boolean isEqual(double d1, double d2) {
        return Math.abs(d1 - d2) < (double)1.0E-5f;
    }

    public static void checkCondition(boolean condition, String errorMessage) {
        if (!condition) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static boolean toBoolean(String value) {
        return HGBaseTools.toInt(value) > 0 || "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static String toString(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        t.printStackTrace(printWriter);
        return String.valueOf(HGBaseTools.toString(t.getMessage())) + "\n" + ((Object)writer).toString();
    }

    public static String toString(Object o) {
        return o == null ? "" : o.toString();
    }

    public static <T> T[] clone(T[] o) {
        return o == null ? null : (Object[])o.clone();
    }

    public static <T extends Cloneable> T clone(T o) {
        if (o == null) {
            return null;
        }
        try {
            Method cloneMethod = o.getClass().getMethod("clone", new Class[0]);
            return (T)((Cloneable)cloneMethod.invoke(o, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static int[] clone(int[] intArray) {
        return intArray == null ? null : Arrays.copyOf(intArray, intArray.length);
    }

    public static void orderList(Comparable<?>[] list) {
        HGBaseTools.orderList(list, false);
    }

    public static void orderList(Comparable<?>[] list, boolean inverse) {
        if (list != null && list.length > 1) {
            if (inverse) {
                Arrays.sort(list, Collections.reverseOrder());
            } else {
                Arrays.sort(list);
            }
        }
    }

    public static <K, V> V getOrCreateValue(Map<K, V> map, K key, V defaultValue) {
        V value = map.get(key);
        if (value == null && defaultValue != null) {
            value = defaultValue;
            map.put(key, value);
        }
        return value;
    }

    public static long testPerformance() {
        long diff = 0L;
        long now = new Date().getTime();
        if (lastTime != -1L) {
            diff = now - lastTime;
        }
        lastTime = now;
        return diff;
    }

    public static long testPerformance(String text) {
        long diff = HGBaseTools.testPerformance();
        System.out.println(String.valueOf(text) + ":" + diff);
        return diff;
    }

    public static int[] toIntArray(List<Integer> list) {
        return HGBaseTools.toIntArray(list.toArray(new Integer[list.size()]));
    }

    public static int[] toIntArray(Integer[] values) {
        int[] intList = new int[values.length];
        int i = 0;
        while (i < intList.length) {
            intList[i] = values[i];
            ++i;
        }
        return intList;
    }

    public static Integer[] toIntegerArray(int[] values) {
        Integer[] intList = new Integer[values.length];
        int i = 0;
        while (i < intList.length) {
            intList[i] = values[i];
            ++i;
        }
        return intList;
    }

    public static Float[] toFloatArray(float[] values) {
        Float[] fList = new Float[values.length];
        int i = 0;
        while (i < fList.length) {
            fList[i] = Float.valueOf(values[i]);
            ++i;
        }
        return fList;
    }

    public static HGBaseItem[] toHGBaseItemArray(String[] values) {
        HGBaseItem[] items = new HGBaseItem[values.length];
        int i = 0;
        while (i < values.length) {
            items[i] = new SimpleHGBaseItem(values[i]);
            ++i;
        }
        return items;
    }

    public static String[] toStringIdArray(HGBaseItem[] list) {
        String[] strIds = new String[list.length];
        int i = 0;
        while (i < strIds.length) {
            strIds[i] = list[i].getId();
            ++i;
        }
        return strIds;
    }

    public static String[] toStringArray(Collection<?> list) {
        String[] strLines = new String[list.size()];
        Iterator<?> it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            strLines[i] = it.next().toString();
            ++i;
        }
        return strLines;
    }

    public static String[] toStringArray(Object[] list) {
        String[] strLines = new String[list.length];
        int i = 0;
        while (i < strLines.length) {
            strLines[i] = list[i].toString();
            ++i;
        }
        return strLines;
    }

    public static String toStringText(String[] text, String separator) {
        HGBaseStringBuilder single = new HGBaseStringBuilder(separator);
        String[] stringArray = text;
        int n = text.length;
        int n2 = 0;
        while (n2 < n) {
            String singleText = stringArray[n2];
            single.append(singleText);
            ++n2;
        }
        return single.toString();
    }

    public static int getIndexOf(Object[] list, Object value) {
        int index = -1;
        int i = 0;
        while (index == -1 && list != null && i < list.length) {
            if (list[i].equals(value)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static boolean isSublist(List<?> completeList, List<?> subList) {
        if (completeList.size() >= subList.size()) {
            for (Object o : subList) {
                if (completeList.contains(o)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String invertString(String text) {
        StringBuffer sb = new StringBuffer(text);
        return sb.reverse().toString();
    }

    public static String[] split(String text, String token) {
        StringTokenizer st = new StringTokenizer(text, token);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return HGBaseTools.toStringArray(list);
    }

    public static boolean hasContent(String text) {
        return text != null && !text.isEmpty();
    }

    public static String shortenString(String text, int maxLen) {
        if (text.length() > maxLen) {
            return String.valueOf(text.substring(0, maxLen - 4)) + "...";
        }
        return text;
    }

    public static String capitalizeFirstLetter(String text) {
        if (HGBaseTools.hasContent(text)) {
            String firstLetter = text.substring(0, 1).toUpperCase(Locale.getDefault());
            text = String.valueOf(firstLetter) + text.substring(1, text.length());
        }
        return text;
    }

    public static Object[] sumArrays(Object[] array1, Object[] array2) {
        Object[] sum = new Object[array1.length + array2.length];
        HGBaseTools.sumArrays(sum, array1, array2);
        return sum;
    }

    public static void sumArrays(Object[] sum, Object[] array1, Object[] array2) {
        System.arraycopy(array1, 0, sum, 0, array1.length);
        System.arraycopy(array2, 0, sum, array1.length, array2.length);
    }

    public static long getTimeDifference(Date time1, Date time2) {
        return time2.getTime() - time1.getTime();
    }

    public static long getTimeDifference(Date time) {
        return HGBaseTools.getTimeDifference(time, new Date());
    }

    public static int getMaximum(int[] values) {
        if (values != null && values.length > 0) {
            int[] valuesClone = (int[])values.clone();
            Arrays.sort(valuesClone);
            return valuesClone[valuesClone.length - 1];
        }
        return 0;
    }

    public static int getMinimum(int[] values) {
        if (values != null && values.length > 0) {
            int[] valuesClone = (int[])values.clone();
            Arrays.sort(valuesClone);
            return valuesClone[0];
        }
        return 0;
    }

    public static Date convertString2Date(String day) {
        String[] s = HGBaseTools.split(day, "-");
        if (s.length == 3) {
            int year = HGBaseTools.toInt(s[0]);
            if (year < 100) {
                year = year > 50 ? (year += 1900) : (year += 2000);
            }
            Calendar cal = Calendar.getInstance();
            cal.set(year, HGBaseTools.toInt(s[1]) - 1, HGBaseTools.toInt(s[2]));
            return cal.getTime();
        }
        return null;
    }

    public static String convertDate2String(Date day) {
        if (day == null) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        int year = cal.get(1);
        int mon = cal.get(2) + 1;
        String dayText = String.valueOf(year) + "-";
        if (mon < 10) {
            dayText = String.valueOf(dayText) + "0";
        }
        dayText = String.valueOf(dayText) + mon + "-";
        if (cal.get(5) < 10) {
            dayText = String.valueOf(dayText) + "0";
        }
        dayText = String.valueOf(dayText) + cal.get(5);
        return dayText;
    }

    public static int compareInt(int i1, int i2) {
        return Integer.valueOf(i1).compareTo(i2);
    }

    public static boolean equalObject(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public static boolean equalClass(Object o1, Object o2) {
        return o1 != null && o2 != null && o1.getClass().equals(o2.getClass());
    }

    public static int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static <T> T findObject(T[] list, IFinderListener<T> fl) {
        int i = 0;
        while (list != null && i < list.length) {
            if (fl.test(list[i])) {
                return list[i];
            }
            ++i;
        }
        return null;
    }

    public static <T> int findIndex(T[] list, IFinderListener<T> fl) {
        int i = 0;
        while (list != null && i < list.length) {
            if (fl.test(list[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T extends HGBaseItem> T findItemById(T[] list, final String id) {
        return (T)((HGBaseItem)HGBaseTools.findObject(list, new IFinderListener<T>(){

            @Override
            public boolean test(T o) {
                return o.getId().equals(id);
            }
        }));
    }

    public static <T> Collection<T> findAll(T[] list, IFinderListener<T> fl) {
        ArrayList<T> newList = new ArrayList<T>();
        int i = 0;
        while (list != null && i < list.length) {
            if (fl.test(list[i])) {
                newList.add(list[i]);
            }
            ++i;
        }
        return newList;
    }

    public static <T> T getFirstOrNull(Collection<T> list) {
        return list == null || list.isEmpty() ? null : (T)list.iterator().next();
    }

    public static <T> T getSingleElementOrNull(Collection<T> list) {
        return list == null || list.size() != 1 ? null : (T)list.iterator().next();
    }

    public static <T> T getElementOrNull(T[] list, int index) {
        return list == null || list.length <= index ? null : (T)list[index];
    }

    public static String getStringWithIndex(String[] s, int i) {
        return i >= 0 && i < s.length ? s[i] : "";
    }

    public static void delay(long milliSeconds) {
        HGBaseTools.sleep(milliSeconds);
    }

    public static int getNumberDigits(long value) {
        int numDigits = 1;
        long rest = value;
        while (rest / 10L >= 1L) {
            rest /= 10L;
            ++numDigits;
        }
        return numDigits;
    }

    public static void throwAsRuntimeException(Exception e) {
        throw new IllegalStateException(e.getMessage(), e);
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean startJARApp(String appFilePath, String params, boolean waitFor) {
        return HGBaseTools.startJARApp(new File(appFilePath), params, waitFor);
    }

    public static boolean startJARApp(File appFile, String params, boolean waitFor) {
        boolean success;
        File parentDir = new File(appFile.getParent());
        String command = "java -jar " + appFile.getName();
        if (params == null) {
            params = "";
        }
        try {
            Process p = Runtime.getRuntime().exec(String.valueOf(command) + " " + params, null, parentDir);
            if (waitFor) {
                p.waitFor();
            }
            success = true;
        }
        catch (IOException | InterruptedException e) {
            success = false;
        }
        return success;
    }

    public static void ensureSize(Collection<?> collection, int minSize) {
        while (collection.size() < minSize) {
            collection.add(null);
        }
    }

    public static <T> T[] addArrayElement(T[] array, T element) {
        ArrayList<T> arrayList = new ArrayList<T>(Arrays.asList(array));
        arrayList.add(element);
        return arrayList.toArray(array);
    }
}

