/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib;

import hgb.lib.HGBaseVersionPart;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class HGBaseVersion
implements Comparable<HGBaseVersion> {
    private static final char DEFAULT_DELIM = '.';
    private String version;
    private char delim;

    public HGBaseVersion(String version) {
        this(version, '.');
    }

    public HGBaseVersion(String version, char delim) {
        this.setDelimiter(delim);
        this.setVersion(version);
    }

    public void setVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("version is null");
        }
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDelimiter(char delim) {
        this.delim = delim;
    }

    public char getDelimiter() {
        return this.delim;
    }

    protected List<HGBaseVersionPart> getParts() {
        StringTokenizer tokenizer = new StringTokenizer(this.getVersion(), Character.valueOf(this.getDelimiter()).toString());
        ArrayList<HGBaseVersionPart> parts = new ArrayList<HGBaseVersionPart>();
        while (tokenizer.hasMoreTokens()) {
            parts.add(new HGBaseVersionPart(tokenizer.nextToken()));
        }
        return parts;
    }

    public boolean equals(Object o2) {
        return o2 instanceof HGBaseVersion && this.compareTo((HGBaseVersion)o2) == 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    @Override
    public int compareTo(HGBaseVersion otherVersion) {
        if (otherVersion == null) {
            throw new IllegalArgumentException("other version is null");
        }
        List<HGBaseVersionPart> thisParts = this.getParts();
        List<HGBaseVersionPart> otherParts = otherVersion.getParts();
        int thisSize = thisParts.size();
        int otherSize = otherParts.size();
        int result = 0;
        int minSize = Math.min(thisSize, otherSize);
        int index = 0;
        while (index < minSize && result == 0) {
            result = thisParts.get(index).compareTo(otherParts.get(index));
            ++index;
        }
        if (result != 0) {
            return result;
        }
        result = thisSize > otherSize ? 1 : (thisSize < otherSize ? -1 : 0);
        return result;
    }
}

