/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib.update;

import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseHTMLPage;
import hgb.gui.menu.HGBaseMenu;
import hgb.lib.FileNameFilter;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import hgb.lib.HGBaseVersion;
import hgb.lib.internal.ClassFactory;
import hgb.lib.internal.IntBooleanStringMap;
import hgb.lib.update.HGBaseUpdateInfo;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JMenuItem;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HGBaseUpdate {
    public static final String SETTINGKEY_UPDATE_URL = "updateUrl";
    public static final String SETTINGKEY_APPVERSION = "appVersion";
    public static final String SETTINGKEY_UPDATE_FOLDER = "updateFolder";
    public static final String DEFAULT_UPDATE_FOLDER = ".update";
    public static final String SETTINGKEY_UPDATER_APP = "updaterApp";
    public static final String DEFAULT_UPDATER_APP = "HGBaseUpdater.jar";
    public static final String SETTINGKEY_ZIP_FILE_FILTER = "updateZipFileFilter";
    private static final String ICONID_UPDATING = "updating";
    private static final String MENUID_UPDATE_CHECK = "help.update.check";
    private static final String MSGKEY_DIALOGTITLE = "update.dialogtitle";
    private static final String MSGKEY_READFAILED = "update.err.readfailed";
    private static final String MSGKEY_MALFORMEDURL = "update.err.malformedurl";
    private static final String MSGKEY_NEWVERSIONAVAILABLE = "update.newversionavailable";
    private static final String MSGKEY_VERSIONUPTODATE = "update.versionuptodate";
    private static final String MSGKEY_OLDERVERSIONAVAILABLE = "update.olderversionavailable";
    private static final String MSGKEY_DOWNLOADBUTTON = "dlg.download";
    private static final String MSGKEY_INSTALLNEWVERSIONTITLE = "update.installnewversiontitle";
    private static final String MSGKEY_INSTALLNEWVERSION = "update.installnewversion";
    private static final String MSGKEY_CALL_UPDATER_ERROR = "update.err.callupdater";
    private static final String MSGKEY_UPDATER_APP_NOT_FOUND = "update.err.updaternotfound";
    private static final String MSGKEY_OK = "dlg.ok";
    private static final String MSGKEY_INSTALL = "dlg.install";
    private static final String MSGKEY_DOWNLOAD_UPDATER_ERROR = "update.err.downloadupdater";
    private static final String MSGKEY_DOWNLOAD_NEW_VERSION_ERROR = "update.err.downloadnewversion";
    private static final String MSGKEY_RESTART_APP = "update.restartapp";
    private static final String MSGKEY_NO_UPDATE_FOLDER_ERROR = "update.err.noupdatefolder";
    private static final String XMLKEY_VALUE = "value";
    private static final String XMLKEY_VERSION = "version";
    private static final String XMLKEY_DOWNLOADURL = "downloadurl";
    private static final String XMLKEY_UPDATERAPPURL = "updaterappurl";
    private static final String XMLKEY_UPDATEURL = "updateurl";
    private String updateErrorText = "";
    private boolean running = false;
    private boolean silent = false;

    private void setUpdateErrorText(String updateErrorText) {
        this.updateErrorText = updateErrorText;
    }

    private String getUpdateErrorText() {
        return this.updateErrorText;
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    private boolean isRunning() {
        return this.running;
    }

    private void setSilent(boolean silent) {
        this.silent = silent;
    }

    private boolean isSilent() {
        return this.silent;
    }

    protected HGBaseUpdateInfo readUpdateUrl() {
        String updateUrl = HGBaseSettings.get(SETTINGKEY_UPDATE_URL);
        HGBaseUpdateInfo info = this.readUpdateUrlXML(updateUrl);
        if (info == null) {
            info = this.readUpdateUrlTXT(updateUrl);
        }
        return info;
    }

    protected HGBaseUpdateInfo readUpdateUrlXML(String updateUrl) {
        try {
            URL url = new URL(updateUrl);
            DocumentBuilder build = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = null;
            doc = build.parse(url.openStream());
            Element root = doc.getDocumentElement();
            if (root != null) {
                final HGBaseUpdateInfo info = new HGBaseUpdateInfo();
                ChildNodeIterator.run(new ChildNodeIterator(root, null){

                    @Override
                    public void performNode(Node node, int index, Object obj) {
                        String nodeName = node.getNodeName();
                        if (HGBaseUpdate.XMLKEY_VERSION.equals(nodeName)) {
                            info.updateVersion = HGBaseXMLTools.getAttributeValue(node, HGBaseUpdate.XMLKEY_VALUE);
                        } else if (HGBaseUpdate.XMLKEY_DOWNLOADURL.equals(nodeName)) {
                            info.downloadUrl = HGBaseXMLTools.getAttributeValue(node, HGBaseUpdate.XMLKEY_VALUE);
                        } else if (HGBaseUpdate.XMLKEY_UPDATERAPPURL.equals(nodeName)) {
                            info.updaterAppUrl = HGBaseXMLTools.getAttributeValue(node, HGBaseUpdate.XMLKEY_VALUE);
                        } else if (HGBaseUpdate.XMLKEY_UPDATEURL.equals(nodeName)) {
                            info.updateUrl = HGBaseXMLTools.getAttributeValue(node, HGBaseUpdate.XMLKEY_VALUE);
                        }
                    }
                });
                return info;
            }
        }
        catch (MalformedURLException e) {
            HGBaseLog.logError(e.getMessage());
            this.setUpdateErrorText(HGBaseText.getText(MSGKEY_MALFORMEDURL, new String[0]));
            return null;
        }
        catch (Exception e) {
            HGBaseLog.logError(e.getMessage());
            this.setUpdateErrorText(HGBaseText.getText(MSGKEY_READFAILED, new String[0]));
            return null;
        }
        return null;
    }

    protected HGBaseUpdateInfo readUpdateUrlTXT(String updateUrl) {
        HGBaseUpdateInfo info;
        block7: {
            info = new HGBaseUpdateInfo();
            BufferedReader in = null;
            try {
                String inputLine;
                URL url = new URL(updateUrl);
                in = new BufferedReader(new InputStreamReader(url.openStream(), Charset.defaultCharset()));
                StringBuffer content = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
                info.updateVersion = content.toString();
            }
            catch (MalformedURLException e) {
                HGBaseLog.logError(e.getMessage());
                this.setUpdateErrorText(HGBaseText.getText(MSGKEY_MALFORMEDURL, new String[0]));
                info = null;
                HGBaseFileTools.closeStream(in);
                break block7;
            }
            catch (IOException e) {
                try {
                    HGBaseLog.logError(e.getMessage());
                    this.setUpdateErrorText(HGBaseText.getText(MSGKEY_READFAILED, new String[0]));
                    info = null;
                }
                catch (Throwable throwable) {
                    HGBaseFileTools.closeStream(in);
                    throw throwable;
                }
                HGBaseFileTools.closeStream(in);
                break block7;
            }
            HGBaseFileTools.closeStream(in);
        }
        return info;
    }

    private void setMenuIcon(String iconId) {
        JMenuItem menuItem;
        HGBaseMenu menu;
        HGBaseFrame frame = HGBaseFrame.getInstance();
        if (frame != null && (menu = frame.getMenu()) != null && (menuItem = (JMenuItem)menu.getMenuItem(MENUID_UPDATE_CHECK)) != null) {
            if (iconId != null) {
                menu.setMenuIcon(menuItem, iconId);
            } else {
                menu.removeMenuIcon(menuItem);
            }
        }
    }

    protected void checkVersion(HGBaseUpdateInfo info) {
        HGBaseVersion currentVersion = this.getCurrentAppVersion();
        HGBaseVersion availableVersion = new HGBaseVersion(info.updateVersion);
        switch (currentVersion.compareTo(availableVersion)) {
            case -1: {
                if (HGBaseTools.hasContent(info.updaterAppUrl) && HGBaseTools.hasContent(info.updateUrl)) {
                    this.showUpdateInfoDialog(HGBaseText.getText(MSGKEY_NEWVERSIONAVAILABLE, availableVersion.getVersion()), info.updaterAppUrl, info.updateUrl);
                    break;
                }
                if (HGBaseTools.hasContent(info.downloadUrl)) {
                    this.showDownloadInfoDialog(HGBaseText.getText(MSGKEY_NEWVERSIONAVAILABLE, availableVersion.getVersion()), info.downloadUrl);
                    break;
                }
                this.showInfoDialog(HGBaseText.getText(MSGKEY_NEWVERSIONAVAILABLE, availableVersion.getVersion()));
                break;
            }
            case 0: {
                if (this.isSilent()) break;
                this.showInfoDialog(HGBaseText.getText(MSGKEY_VERSIONUPTODATE, new String[0]));
                break;
            }
            case 1: {
                if (this.isSilent()) break;
                this.showErrorDialog(HGBaseText.getText(MSGKEY_OLDERVERSIONAVAILABLE, new String[0]));
            }
        }
    }

    private HGBaseVersion getCurrentAppVersion() {
        return new HGBaseVersion(HGBaseSettings.get(SETTINGKEY_APPVERSION));
    }

    protected void showInfoDialog(String message) {
        HGBaseDialog.showMessageDialog(HGBaseFrame.getInstance(), message, HGBaseText.getText(MSGKEY_DIALOGTITLE, new String[0]), 1);
    }

    protected void showDownloadInfoDialog(String message, String downloadUrl) {
        HGBaseHTMLPage htmlPage = this.buildDownloadInfoDialogHTMLPage(message, downloadUrl);
        if (htmlPage != null) {
            HGBaseDialog.showMessageDialog(HGBaseFrame.getInstance(), htmlPage, HGBaseText.getText(MSGKEY_DIALOGTITLE, new String[0]), -1);
        } else {
            this.showInfoDialog(message);
        }
    }

    protected void showUpdateInfoDialog(String message, String updaterAppUrl, String updateUrl) {
        String downloadedFileName;
        String title;
        Object[] options = new String[]{HGBaseText.getText(MSGKEY_OK, new String[0]), HGBaseText.getText(MSGKEY_INSTALL, new String[0])};
        HGBaseFrame frame = HGBaseFrame.getInstance();
        int answer = HGBaseDialog.showOptionDialog(frame, (Object)message, title = HGBaseText.getText(MSGKEY_DIALOGTITLE, new String[0]), -1, 1, null, options, 0);
        if (answer == 1 && HGBaseTools.hasContent(downloadedFileName = this.downloadUpdate(updaterAppUrl, updateUrl)) && (answer = HGBaseDialog.showConfirmDialog(frame, HGBaseText.getText(MSGKEY_RESTART_APP, new String[0]), title)) == 0) {
            File updateFolder = this.getUpdateFolder(false);
            File updaterApp = this.getUpdaterApp(updateFolder);
            if (updaterApp.exists()) {
                this.callUpdater(updaterApp, downloadedFileName);
                frame.getMenu().onExit();
            } else {
                this.showErrorDialog(HGBaseText.getText(MSGKEY_UPDATER_APP_NOT_FOUND, new String[0]));
            }
        }
    }

    protected String downloadUpdate(String updaterAppUrl, String updateUrl) {
        String downloadedFileName;
        block14: {
            block11: {
                block12: {
                    String extension;
                    File updateFolder = this.getUpdateFolder(true);
                    if (updateFolder == null) break block11;
                    if (!this.downloadFile(updaterAppUrl, this.getUpdaterApp(updateFolder).getAbsolutePath())) break block12;
                    switch (extension = HGBaseFileTools.getFileExtension(updateUrl)) {
                        case "jar": {
                            downloadedFileName = this.handleJarFileDownload(updateFolder, updateUrl);
                            break;
                        }
                        case "zip": {
                            downloadedFileName = this.handleZipFileDownload(updateFolder, updateUrl);
                            break;
                        }
                        default: {
                            downloadedFileName = this.handleOtherFileDownload(updateFolder, updateUrl);
                        }
                    }
                    if (!HGBaseTools.hasContent(downloadedFileName)) {
                        this.showErrorDialog(HGBaseText.getText(MSGKEY_DOWNLOAD_NEW_VERSION_ERROR, new String[0]));
                    }
                    break block14;
                }
                this.showErrorDialog(HGBaseText.getText(MSGKEY_DOWNLOAD_UPDATER_ERROR, new String[0]));
                downloadedFileName = null;
                break block14;
            }
            this.showErrorDialog(HGBaseText.getText(MSGKEY_NO_UPDATE_FOLDER_ERROR, new String[0]));
            downloadedFileName = null;
        }
        return downloadedFileName;
    }

    protected String handleJarFileDownload(File updateFolder, String updateUrl) {
        String destFile = this.getJarFilePath(updateFolder);
        String downloadedFileName = this.downloadFile(updateUrl, destFile) ? destFile : null;
        return downloadedFileName;
    }

    protected String handleZipFileDownload(File updateFolder, String updateUrl) {
        File targetFolder;
        String downloadedFileName = null;
        String filterClassPath = HGBaseSettings.get(SETTINGKEY_ZIP_FILE_FILTER);
        FileFilter filter = HGBaseTools.hasContent(filterClassPath) ? ClassFactory.createClass(filterClassPath, FileFilter.class, SETTINGKEY_ZIP_FILE_FILTER) : new FileNameFilter(this.getCurrentJarFileName());
        String zipFile = this.getTargetFilePath(updateFolder, updateUrl);
        if (HGBaseTools.hasContent(zipFile) && this.downloadFile(updateUrl, zipFile) && this.createFolder(targetFolder = this.getZipExtractFolder(updateFolder))) {
            try {
                if (HGBaseFileTools.extractZipFile(new ZipFile(zipFile), targetFolder, filter) > 0) {
                    downloadedFileName = targetFolder.getAbsolutePath();
                }
                HGBaseFileTools.deleteFileNowOrOnExit(new File(zipFile));
            }
            catch (IOException e) {
                HGBaseLog.logError(e.getMessage());
            }
        }
        return downloadedFileName;
    }

    private boolean createFolder(File folder) {
        if (folder.isFile()) {
            return false;
        }
        if (folder.isDirectory()) {
            return true;
        }
        return folder.mkdir();
    }

    protected String handleOtherFileDownload(File updateFolder, String updateUrl) {
        throw new UnsupportedOperationException("There is not standard implemention to download this kind of file!");
    }

    private boolean downloadFile(String url, String destFile) {
        try {
            HGBaseFileTools.downloadFile(url, destFile);
            return true;
        }
        catch (MalformedURLException e) {
            HGBaseLog.logError(e.getMessage());
        }
        catch (IOException e) {
            HGBaseLog.logError(e.getMessage());
        }
        return false;
    }

    protected HGBaseHTMLPage buildDownloadInfoDialogHTMLPage(String message, String downloadUrl) {
        HGBaseHTMLPage html = null;
        try {
            StringBuffer htmlBody = new StringBuffer(512);
            htmlBody.append("<html><div style=\"font-family:Arial,Verdana,System\">");
            htmlBody.append(String.valueOf(message) + "<br>");
            htmlBody.append("<a href=\"" + downloadUrl + "\">" + HGBaseText.getText(MSGKEY_DOWNLOADBUTTON, new String[0]) + "</a> (" + downloadUrl + ")");
            htmlBody.append("</div></html>");
            html = new HGBaseHTMLPage(htmlBody.toString());
        }
        catch (Exception e) {
            HGBaseLog.logError("Could not build update download page: " + e.getMessage());
        }
        return html;
    }

    protected void showErrorDialog(String message) {
        HGBaseDialog.showMessageDialog(HGBaseFrame.getInstance(), message, HGBaseText.getText(MSGKEY_DIALOGTITLE, new String[0]), 0);
    }

    public void doCheck(boolean silent) {
        if (this.isRunning()) {
            return;
        }
        this.setSilent(silent);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                HGBaseUpdate.this.setRunning(true);
                HGBaseUpdate.this.setMenuIcon(HGBaseUpdate.ICONID_UPDATING);
                HGBaseUpdateInfo info = HGBaseUpdate.this.readUpdateUrl();
                if (info != null) {
                    HGBaseUpdate.this.checkVersion(info);
                } else if (!HGBaseUpdate.this.isSilent()) {
                    HGBaseUpdate.this.showErrorDialog(HGBaseUpdate.this.getUpdateErrorText());
                }
                HGBaseUpdate.this.setMenuIcon(null);
                HGBaseUpdate.this.setRunning(false);
            }
        });
        t.start();
    }

    public void installNewVersion(String settingsFile) {
        File updateFolder = this.getUpdateFolder(false);
        if (updateFolder != null && updateFolder.isDirectory()) {
            File updaterApp = this.getUpdaterApp(updateFolder);
            String jarFilePath = HGBaseFileTools.searchFile(updateFolder, this.getCurrentJarFileName(), false);
            if (HGBaseTools.hasContent(jarFilePath)) {
                this.handleJarFileInstallation(settingsFile, updateFolder, updaterApp, jarFilePath);
            } else {
                File targetFolder = this.getZipExtractFolder(updateFolder);
                jarFilePath = HGBaseFileTools.searchFile(targetFolder, this.getCurrentJarFileName(), false);
                if (targetFolder.isDirectory() && HGBaseTools.hasContent(jarFilePath) && targetFolder.listFiles().length > 1) {
                    this.handleJarFileInstallation(settingsFile, targetFolder, updaterApp, jarFilePath);
                } else if (targetFolder.isDirectory() && this.filesToInstallAvailable(targetFolder, updaterApp)) {
                    this.handleZipFileInstallation(settingsFile, targetFolder, updaterApp);
                } else if (this.filesToInstallAvailable(updateFolder, updaterApp)) {
                    this.handleOtherFileInstallation(settingsFile, updateFolder, updaterApp);
                } else {
                    HGBaseFileTools.deleteFolder(updateFolder);
                }
            }
        }
    }

    protected boolean filesToInstallAvailable(File updateFolder, final File updaterApp) {
        if (!updateFolder.isDirectory()) {
            return false;
        }
        String[] files = updateFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File folder, String name) {
                File fileTotest = new File(folder, name);
                return !fileTotest.getAbsolutePath().equalsIgnoreCase(updaterApp.getAbsolutePath()) && !"zip".equalsIgnoreCase(HGBaseFileTools.getFileExtension(fileTotest));
            }
        });
        return files.length > 0;
    }

    protected void handleZipFileInstallation(String settingsFile, File updateFolder, File updaterApp) {
        String jarFilePath = HGBaseFileTools.searchFile(updateFolder, this.getCurrentJarFileName(), false);
        if (HGBaseTools.hasContent(jarFilePath)) {
            this.handleJarFileInstallation(settingsFile, updateFolder, updaterApp, updateFolder.getAbsolutePath());
        } else {
            HGBaseLog.logWarn("There is application jar file in the downloaded zip file!");
        }
    }

    protected void handleOtherFileInstallation(String settingsFile, File updateFolder, File updaterApp) {
        HGBaseLog.logWarn("There is not standard implemention to install this kind of file!");
    }

    protected void handleJarFileInstallation(String settingsFile, File updateFolder, File updaterApp, String jarFilePath) {
        HGBaseVersion newVersion;
        HGBaseVersion currentVersion;
        String newAppVersion = this.getNewAppVersion(jarFilePath, settingsFile);
        if (newAppVersion != null && (currentVersion = this.getCurrentAppVersion()).compareTo(newVersion = new HGBaseVersion(newAppVersion)) == -1) {
            if (updaterApp.exists()) {
                if (this.askCallUpdater(newAppVersion)) {
                    this.callUpdater(updaterApp, jarFilePath);
                }
            } else {
                this.showErrorDialog(HGBaseText.getText(MSGKEY_UPDATER_APP_NOT_FOUND, new String[0]));
            }
        }
    }

    protected void callUpdater(File updaterApp, String downloadedFileName) {
        String params = String.valueOf(downloadedFileName) + " " + this.getAppFolder() + " " + HGBaseText.getLanguage() + " " + this.getCurrentJarFileName();
        if (!HGBaseTools.startJARApp(updaterApp, params, false)) {
            this.showErrorDialog(HGBaseText.getText(MSGKEY_CALL_UPDATER_ERROR, new String[0]));
        }
        System.exit(0);
    }

    private boolean askCallUpdater(String newVersion) {
        int answer = HGBaseDialog.showConfirmDialog(HGBaseFrame.getInstance(), HGBaseText.getText(MSGKEY_INSTALLNEWVERSION, newVersion), HGBaseText.getText(MSGKEY_INSTALLNEWVERSIONTITLE, new String[0]));
        return answer == 0;
    }

    private String getAppFolder() {
        File jarFile = HGBaseFileTools.getExecutionFile(new HGBaseUpdate());
        return jarFile != null ? jarFile.getParent() : null;
    }

    private File getUpdaterApp(File updateFolder) {
        String updaterApp = HGBaseSettings.get(SETTINGKEY_UPDATER_APP, DEFAULT_UPDATER_APP);
        return new File(updateFolder.getAbsoluteFile(), updaterApp);
    }

    private File getUpdateFolder(boolean create) {
        String updateFolderName = HGBaseSettings.get(SETTINGKEY_UPDATE_FOLDER, DEFAULT_UPDATE_FOLDER);
        File updateFolder = new File(updateFolderName);
        if (updateFolder.isFile()) {
            updateFolder = null;
        } else if (!(updateFolder.exists() || create && updateFolder.mkdirs())) {
            updateFolder = null;
        }
        return updateFolder;
    }

    private String getNewAppVersion(String jarFilePath, String settingsFile) {
        String newVersion;
        block8: {
            JarFile file;
            block7: {
                newVersion = null;
                file = null;
                try {
                    try {
                        file = new JarFile(jarFilePath);
                        String entryName = settingsFile.startsWith("/") ? settingsFile.substring(1) : settingsFile;
                        ZipEntry settingsEntry = file.getEntry(entryName);
                        if (settingsEntry == null) break block7;
                        InputStream inputStream = file.getInputStream(settingsEntry);
                        try {
                            IntBooleanStringMap settings = new IntBooleanStringMap();
                            settings.fromFile(inputStream, "settings", "set", "name", XMLKEY_VALUE);
                            newVersion = settings.get(SETTINGKEY_APPVERSION);
                        }
                        finally {
                            HGBaseFileTools.closeStream(inputStream);
                        }
                    }
                    catch (IOException e) {
                        HGBaseLog.logError(e.getMessage());
                        HGBaseFileTools.closeZipFile(file, true);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    HGBaseFileTools.closeZipFile(file, true);
                    throw throwable;
                }
            }
            HGBaseFileTools.closeZipFile(file, true);
        }
        return newVersion;
    }

    private String getJarFilePath(File updateFolder) {
        return new File(updateFolder, this.getCurrentJarFileName()).getAbsolutePath();
    }

    private String getTargetFilePath(File updateFolder, String updateUrl) {
        try {
            String targetFileName = new File(new URL(updateUrl).getPath()).getName();
            return new File(updateFolder, targetFileName).getAbsolutePath();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private File getZipExtractFolder(File updateFolder) {
        String zipFileName = this.getCurrentJarFileName(false);
        return new File(updateFolder, zipFileName);
    }

    private String getCurrentJarFileName() {
        return this.getCurrentJarFileName(true);
    }

    private String getCurrentJarFileName(boolean withExtension) {
        File jarFile = HGBaseFileTools.getExecutionFile(new HGBaseUpdate());
        if (jarFile != null) {
            String name = jarFile.getName();
            return withExtension ? name : HGBaseFileTools.getFileName(name, false);
        }
        return null;
    }
}

