/*
 * Decompiled with CFR 0.152.
 */
package tjger;

import hgb.gui.HGBasePanel;
import hgb.lib.HGBaseConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import tjger.MainMenu;
import tjger.game.completed.GameConfig;
import tjger.gui.GamePanel;

public class MainPanel
extends HGBasePanel {
    private static final long serialVersionUID = 854371072L;
    private final JScrollPane scrollPane = new JScrollPane(20, 30);
    private GamePanel gamePanel;
    private Component statePanel;

    public MainPanel() {
        super(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    @Override
    public void actualizeLaf() {
        super.actualizeLaf();
        this.refresh();
    }

    public void refresh() {
        this.setGamePanelSize();
        this.getViewport().updateUI();
    }

    public GamePanel getGamePanel() {
        return this.gamePanel;
    }

    public void setGamePanel(GamePanel gamePanel) {
        this.gamePanel = gamePanel;
        this.getViewport().removeAll();
        this.getViewport().add(this.gamePanel);
        this.refresh();
        this.repositionStatePanel();
    }

    public JViewport getViewport() {
        return this.scrollPane.getViewport();
    }

    private void setGamePanelSize() {
        if (this.gamePanel != null) {
            GameConfig config = GameConfig.getInstance();
            this.gamePanel.calcFieldMargins();
            int w = this.gamePanel.transform(config.getFieldWidth());
            int h = this.gamePanel.transform(config.getFieldHeight());
            Dimension old = this.getGamePanel().getSize();
            if ((double)w != old.getWidth() || (double)h != old.getHeight()) {
                JScrollBar hsb = this.scrollPane.getHorizontalScrollBar();
                JScrollBar vsb = this.scrollPane.getVerticalScrollBar();
                hsb.setValue(w / 10);
                vsb.setValue(h / 10);
                hsb.setUnitIncrement(50);
                vsb.setUnitIncrement(50);
                this.getGamePanel().setPreferredSize(new Dimension(w, h));
            }
        }
    }

    void repositionStatePanel() {
        if (this.statePanel == null) {
            this.statePanel = this.getInitialStatePanel();
        }
        if (this.statePanel != null) {
            this.remove(this.statePanel);
            String posConfig = HGBaseConfig.get(MainMenu.STATEPANEL_MENU.getMenuType(), MainMenu.STATEPANEL_MENU.getDefaultOption());
            String newPosition = MainMenu.STATEPANEL_MENU.getValue(posConfig);
            if (newPosition != null) {
                this.setNewStatePanelPosition(newPosition);
            }
            this.validate();
        }
    }

    protected void setNewStatePanelPosition(String newPosition) {
        this.add(this.statePanel, newPosition);
    }

    protected Component getInitialStatePanel() {
        BorderLayout layout = (BorderLayout)this.getLayout();
        return layout.getLayoutComponent("South");
    }
}

