/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.gui.HGBaseGuiTools;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameConfigFileReader;
import tjger.gui.completed.ColorValuePart;
import tjger.gui.completed.PartSet;

abstract class PartSetContructor<T extends PartSet> {
    protected String key1;
    protected String key2;
    protected String key3;
    protected List<T> listSet;
    protected Map<String, List<T>> mapSet;

    private PartSetContructor(String key1, String key2, String key3, List<T> listSet, Map<String, List<T>> mapSet) {
        this.key1 = key1;
        this.key2 = key2;
        this.key3 = key3;
        this.listSet = listSet;
        this.mapSet = mapSet;
    }

    PartSetContructor(String key1, String key2, String key3, List<T> listSet) {
        this(key1, key2, key3, listSet, null);
    }

    PartSetContructor(String key1, String key2, String key3, Map<String, List<T>> mapSet) {
        this(key1, key2, key3, null, mapSet);
    }

    public void run(Node root, GameConfig config) {
        ChildNodeIterator.run(new ChildNodeIterator(root, this.key1, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                final GameConfig config = (GameConfig)obj;
                if (node.getNodeName().equals(PartSetContructor.this.key2)) {
                    String type = HGBaseXMLTools.getAttributeValue(node, "type");
                    if ("cardset".equals(node.getNodeName()) && !HGBaseTools.hasContent(type)) {
                        type = "game.cardset";
                    }
                    String name = HGBaseXMLTools.getAttributeValue(node, "name");
                    if (PartSetContructor.this.mapSet != null && !HGBaseTools.hasContent(type)) {
                        HGBaseLog.logWarn("No type defined for part set '" + name + "'!");
                    } else {
                        if (PartSetContructor.this.mapSet != null) {
                            GameConfigFileReader.setOrderBy(config, type, node);
                        }
                        boolean hidden = GameConfigFileReader.isHiddenPart(node, config);
                        Object setNew = PartSetContructor.this.createPartSet(type, name, node, hidden);
                        ChildNodeIterator.run(new ChildNodeIterator(node, PartSetContructor.this.key2, setNew){

                            @Override
                            public void performNode(Node node, int index, Object obj) {
                                PartSet set = (PartSet)obj;
                                if (node.getNodeName().equals((this).PartSetContructor.this.key3)) {
                                    String color = HGBaseXMLTools.getAttributeValue(node, "color");
                                    int sequence = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "sequence"));
                                    int value = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "value"));
                                    if (sequence != -2147483631) {
                                        String image = PartSetContructor.this.getPartImage(config, node, set, color, sequence);
                                        PartSetContructor.this.loadSinglePart(set, color, sequence, this.getPartValue(value, sequence), image, node);
                                    } else {
                                        int seqS = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "sequencestart"));
                                        int seqE = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "sequenceend"));
                                        if (seqS != -2147483631 && seqE != -2147483631 && seqS <= seqE) {
                                            int i = seqS;
                                            while (i <= seqE) {
                                                String image = PartSetContructor.this.getPartImage(config, node, set, color, i);
                                                PartSetContructor.this.loadSinglePart(set, color, i, this.getPartValue(value, i), image, node);
                                                ++i;
                                            }
                                        }
                                    }
                                }
                            }

                            private int getPartValue(int value, int sequence) {
                                if (value == -2147483631) {
                                    return sequence;
                                }
                                return value;
                            }
                        });
                        if (((PartSet)setNew).getParts().size() > 0) {
                            if (PartSetContructor.this.listSet != null) {
                                PartSetContructor.this.listSet.add(setNew);
                            }
                            if (PartSetContructor.this.mapSet != null) {
                                GameConfigFileReader.getListFromMap(PartSetContructor.this.mapSet, type).add(setNew);
                            }
                        }
                    }
                }
            }
        });
    }

    protected abstract T createPartSet(String var1, String var2, Node var3, boolean var4);

    protected String calculateImage(String partSet, String color, int sequence, GameConfig config) {
        return String.valueOf(config.getImagePath(this.key3)) + "/" + partSet + "/" + color + "-" + sequence + "." + config.getImageExtension(this.key3);
    }

    protected void loadSinglePart(PartSet set, String color, int sequence, int value, String imagePath, Node node) {
        ImageIcon image = HGBaseGuiTools.loadImage(imagePath);
        if (image != null) {
            set.addPart(this.createColorValuePart(set, color, sequence, value, image, node));
        } else {
            HGBaseLog.logWarn("The " + this.key3 + "'s image file " + imagePath + " was not found!");
        }
    }

    protected abstract ColorValuePart createColorValuePart(PartSet var1, String var2, int var3, int var4, ImageIcon var5, Node var6);

    private String getPartImage(GameConfig config, Node node, PartSet set, String color, int sequence) {
        String image = HGBaseXMLTools.getAttributeValue(node, "image");
        if (!HGBaseTools.hasContent(image)) {
            image = this.calculateImage(set.getName(), color, sequence, config);
        }
        return image;
    }
}

