/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed.imagereader;

import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseTools;
import tjger.game.completed.imagereader.AbstractImageEffectReader;
import tjger.gui.completed.ImageShadow;
import tjger.gui.completed.Part;

public class ImageShodawReader
extends AbstractImageEffectReader<ImageShadow> {
    public ImageShodawReader() {
        super("shadow");
    }

    @Override
    protected ImageShadow readEffectDefinition(String effectValue) {
        if (!effectValue.isEmpty()) {
            if (HGBaseTools.toBoolean(effectValue)) {
                return new ImageShadow();
            }
            String[] data = effectValue.split(";");
            if (data.length > 1) {
                float a;
                int x = HGBaseTools.toInt(data[0]);
                int y = HGBaseTools.toInt(data[1]);
                float f = a = data.length > 2 ? HGBaseTools.toFloat(data[2]) : -17.00017f;
                if (x != -2147483631 && y != -2147483631) {
                    return !HGBaseTools.isValid(a) ? new ImageShadow(x, y) : new ImageShadow(x, y, a);
                }
            }
            HGBaseLog.logWarn("Invalid shadow detected for node " + this.getCurrentNode().getNodeName() + "!");
        }
        return null;
    }

    @Override
    protected void setEffectForPart(Part part, ImageShadow effect) {
        part.setShadow(effect);
    }

    @Override
    public ImageShadow getEffectFromPart(Part part) {
        return part.getShadow();
    }
}

