/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed;

import hgb.gui.HGBaseItem;
import hgb.lib.HGBaseText;
import javax.swing.ImageIcon;
import tjger.game.completed.GameManager;
import tjger.gui.PartSorter;
import tjger.gui.completed.ImageReflection;
import tjger.gui.completed.ImageShadow;

public class Part
implements HGBaseItem,
Comparable<Part> {
    private final String partType;
    private final String name;
    private final ImageIcon image;
    private final boolean hidden;
    private ImageShadow shadow;
    private ImageReflection reflection;

    public Part(String partType, String name, ImageIcon image, boolean hidden) {
        this.partType = partType;
        this.name = name;
        this.image = image;
        this.hidden = hidden;
    }

    public ImageIcon getImage() {
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public ImageShadow getShadow() {
        return this.shadow;
    }

    public void setShadow(ImageShadow shadow) {
        this.shadow = shadow;
    }

    public ImageReflection getReflection() {
        return this.reflection;
    }

    public void setReflection(ImageReflection reflection) {
        this.reflection = reflection;
    }

    @Override
    public String getId() {
        return this.getName();
    }

    public String toString() {
        return HGBaseText.getText(this.getName(), new String[0]);
    }

    @Override
    public int compareTo(Part p2) {
        if (p2 == null) {
            return 1;
        }
        PartSorter sorter = GameManager.getInstance().getPartSorter(this.getType());
        if (sorter != null) {
            return sorter.compareParts(this, p2);
        }
        return this.getName().compareToIgnoreCase(p2.getName());
    }

    public boolean equals(Object o2) {
        return o2 instanceof Part && this.toString().equals(o2.toString());
    }

    public String getType() {
        return this.partType;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

