/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed;

import hgb.lib.HGBaseTools;
import java.util.ArrayList;
import java.util.List;
import tjger.gui.completed.ColorValuePart;
import tjger.gui.completed.PartSet;
import tjger.gui.completed.Piece;
import tjger.lib.ArrayUtil;

public class PieceSet
extends PartSet {
    public PieceSet(String name, boolean hidden) {
        super("game.pieceset", name, hidden);
    }

    public void addPiece(Piece newPiece) {
        super.addPart(newPiece);
    }

    public Piece[] getPieces() {
        return this.toOrderedPieceArray(this.transform(super.getParts()));
    }

    public Piece[] getPieces(String color) {
        return this.toOrderedPieceArray(this.transform(super.getParts(color)));
    }

    public Piece[] getPieces(String color, int sequenceStart, int sequenceEnd) {
        return this.toOrderedPieceArray(this.transform(super.getParts(color, sequenceStart, sequenceEnd)));
    }

    private List<Piece> transform(List<ColorValuePart> listCvp) {
        ArrayList<Piece> listPiece = new ArrayList<Piece>();
        for (ColorValuePart cvp : listCvp) {
            if (!(cvp instanceof Piece)) continue;
            listPiece.add((Piece)cvp);
        }
        return listPiece;
    }

    public Piece getPiece(String color, int sequence) {
        ColorValuePart p = super.getPart(color, sequence);
        if (p instanceof Piece) {
            return (Piece)p;
        }
        return null;
    }

    private Piece[] toOrderedPieceArray(List<Piece> list) {
        Piece[] pieces = ArrayUtil.toPiece(list);
        HGBaseTools.orderList(pieces);
        return pieces;
    }
}

