/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.internal;

import hgb.gui.HGBaseFrame;
import hgb.lib.internal.ClassFactory;
import tjger.gui.GameDialogs;
import tjger.gui.NewGameDialog;

public class GameDialogFactory {
    private static GameDialogFactory factory = new GameDialogFactory();
    private String dialogClassNewGame;
    private String askToSaveNewGame;
    private String dialogClassGameDialogs;

    private GameDialogFactory() {
    }

    public static GameDialogFactory getInstance() {
        return factory;
    }

    public boolean setNewGameDialogClass(String classPath, String askToSave) {
        NewGameDialog dlg = this.createNewDialog(null, classPath, askToSave);
        if (dlg != null) {
            this.dialogClassNewGame = classPath;
            this.askToSaveNewGame = askToSave;
            return true;
        }
        return false;
    }

    private NewGameDialog createNewDialog(HGBaseFrame frame, String classPath, String askToSave) {
        Class[] classes = new Class[]{HGBaseFrame.class, String.class};
        Object[] params = new Object[]{frame, askToSave};
        return ClassFactory.createClass(classPath, NewGameDialog.class, "new game dialog", classes, params);
    }

    public NewGameDialog createNewDialog(HGBaseFrame frame) {
        if (this.dialogClassNewGame == null) {
            this.dialogClassNewGame = "tjger.gui.NewGameDialog";
        }
        return this.createNewDialog(frame, this.dialogClassNewGame, this.askToSaveNewGame);
    }

    public boolean setGameDialogsClass(String classPath) {
        GameDialogs dlg = this.createGameDialogs(classPath);
        if (dlg != null) {
            this.dialogClassGameDialogs = classPath;
            return true;
        }
        return false;
    }

    private GameDialogs createGameDialogs(String classPath) {
        return ClassFactory.createClass(classPath, GameDialogs.class, "game dialogs");
    }

    public GameDialogs createGameDialogs() {
        if (this.dialogClassGameDialogs == null) {
            this.dialogClassGameDialogs = "tjger.gui.GameDialogs";
        }
        return this.createGameDialogs(this.dialogClassGameDialogs);
    }
}

