/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.internal;

import java.awt.Graphics;
import javax.swing.ImageIcon;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameManager;
import tjger.gui.GamePanel;
import tjger.gui.internal.PartsDlg;

public class PreviewPanel
extends GamePanel {
    private static final long serialVersionUID = 8788760516686439870L;
    protected int distance = 10;
    protected int width;
    protected int height;
    private final GameConfig config;
    protected String[] cardSetTypes;
    protected PartsDlg dlg;
    protected String[] userParts;
    protected String[] userPartSets;

    public PreviewPanel(PartsDlg partsDlg, int width, int height) {
        this.dlg = partsDlg;
        this.width = width;
        this.height = height;
        this.config = GameManager.getInstance().getGameConfig();
        this.cardSetTypes = this.config.getCardSetTypes();
        this.userParts = this.config.getPartTypes();
        this.userPartSets = this.config.getPartSetTypes();
    }

    @Override
    protected void paintBackground(Graphics g) {
        if (this.dlg.getBackgroundColor() != null) {
            g.setColor(this.dlg.getBackgroundColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.paintBackground(this.dlg.getSelectedBackground(), g);
        }
    }

    @Override
    protected void paintBoard(Graphics g) {
        this.paintBoard(this.dlg.getSelectedBoard(), g);
    }

    @Override
    protected void paintParts(Graphics g) {
        this.paintStandardParts(g);
        this.paintUserParts(g);
    }

    protected void paintStandardParts(Graphics g) {
        int x = this.distance;
        int y = 10;
        x = this.drawSelectedPart(x, y, this.dlg.indexOf("game.cover", true), g);
        int i = 0;
        while (i < this.cardSetTypes.length) {
            x = this.drawSelectedPart(x, y, this.dlg.indexOf(this.cardSetTypes[i], true), g);
            ++i;
        }
        x = this.drawSelectedPart(x, y, this.dlg.indexOf("game.pieceset", true), g);
    }

    protected void paintUserParts(Graphics g) {
        int x = this.distance;
        int y = this.getFieldHeight() / 2;
        this.userParts = this.config.getPartTypes();
        this.userPartSets = this.config.getPartSetTypes();
        int i = 0;
        while (i < this.userPartSets.length) {
            x = this.drawSelectedPart(x, y, this.dlg.indexOf(this.userPartSets[i], false), g);
            ++i;
        }
        i = 0;
        while (i < this.userParts.length) {
            x = this.drawSelectedPart(x, y, this.dlg.indexOf(this.userParts[i], false), g);
            ++i;
        }
    }

    private int drawSelectedPart(int x, int y, int index, Graphics g) {
        ImageIcon img;
        if (index >= 0 && (img = this.dlg.getSelectedPart(index).getImage()) != null) {
            this.drawPart(x, y, this.dlg.getSelectedPart(index), g);
            x = x + this.distance + img.getIconWidth();
        }
        return x;
    }

    @Override
    public double getZoomFactor() {
        double hz;
        double wz = (double)this.width / (double)this.getFieldWidth();
        if (wz < (hz = (double)this.height / (double)this.getFieldHeight())) {
            return wz;
        }
        return hz;
    }

    @Override
    protected int getFieldWidth() {
        return this.config.getFieldWidth(this.dlg.getSelectedBoard(), this.dlg.getSelectedBackground());
    }

    @Override
    protected int getFieldHeight() {
        return this.config.getFieldHeight(this.dlg.getSelectedBoard(), this.dlg.getSelectedBackground());
    }
}

