/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.internal;

import hgb.gui.HGBaseFrame;
import hgb.lib.HGBaseSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import tjger.game.completed.GameConfig;

public class TjgerWelcome
extends Window {
    private static final long serialVersionUID = 854371077L;
    private static final int HEIGHT_GAMEINFO = 14;
    private static final float FONTSIZE_GAMEINFO = 12.0f;
    private static TjgerWelcome welcomePanel = new TjgerWelcome();
    private JPanel contentPane;
    ImageIcon imgWelcome;
    ImageIcon imgTjger;

    private TjgerWelcome() {
        super(HGBaseFrame.getInstance());
        this.createPanel();
    }

    private void createPanel() {
        this.contentPane = new JPanel(){
            private static final long serialVersionUID = 179869718100602674L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                int y = TjgerWelcome.this.imgWelcome == null ? 0 : TjgerWelcome.this.imgWelcome.getIconHeight();
                y = y + 14 + 1;
                if (TjgerWelcome.this.imgWelcome != null) {
                    g.drawImage(TjgerWelcome.this.imgWelcome.getImage(), 1, 1, TjgerWelcome.this.imgWelcome.getImageObserver());
                    if (TjgerWelcome.this.imgTjger != null) {
                        double factor = TjgerWelcome.this.calculateFactor();
                        int w = (int)((double)TjgerWelcome.this.imgTjger.getIconWidth() / factor);
                        int h = (int)((double)TjgerWelcome.this.imgTjger.getIconHeight() / factor);
                        g.drawImage(TjgerWelcome.this.imgTjger.getImage(), 1, y, w, h, TjgerWelcome.this.imgTjger.getImageObserver());
                    }
                } else if (TjgerWelcome.this.imgTjger != null) {
                    g.drawImage(TjgerWelcome.this.imgTjger.getImage(), 1, y, TjgerWelcome.this.imgTjger.getImageObserver());
                }
                String appName = HGBaseSettings.get("appName", "");
                String appVersion = HGBaseSettings.get("appVersion", "");
                Font oldFont = g.getFont();
                g.setColor(Color.BLACK);
                g.setFont(oldFont.deriveFont(1, 12.0f));
                g.drawString(String.valueOf(appName) + " " + appVersion, 10, y - 2);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                g.setFont(oldFont);
            }
        };
        this.contentPane.setBackground(Color.WHITE);
        this.add(this.contentPane);
    }

    public static TjgerWelcome getInstance() {
        return welcomePanel;
    }

    private void setPosition() {
        if (this.contentPane != null) {
            int width = this.calculateWidth();
            int height = this.calculateHeight();
            this.setSize(width, height);
            this.contentPane.setSize(width, height);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dim.width - width) / 2, (dim.height - height) / 2);
            this.setVisible(true);
        }
    }

    public void setGameConfig(GameConfig config) {
        this.imgWelcome = config.getWelcomeImage();
        this.imgTjger = config.getTjgerImage();
        this.setPosition();
    }

    @Override
    public boolean isValid() {
        return this.imgWelcome != null || this.imgTjger != null;
    }

    private int calculateWidth() {
        int w = 0;
        if (this.imgWelcome != null) {
            w = this.imgWelcome.getIconWidth();
        } else if (this.imgTjger != null) {
            w = this.imgTjger.getIconWidth();
        }
        if (w > 0) {
            w += 2;
        }
        return w;
    }

    private int calculateHeight() {
        int h = 0;
        if (this.imgWelcome != null) {
            h = this.imgWelcome.getIconHeight();
            if (this.imgTjger != null) {
                double factor = this.calculateFactor();
                h += (int)((double)this.imgTjger.getIconHeight() / factor);
            }
        } else if (this.imgTjger != null) {
            h = this.imgTjger.getIconHeight();
        }
        if (h > 0) {
            h = h + 14 + 2;
        }
        return h;
    }

    private double calculateFactor() {
        return 1.0 * (double)this.imgTjger.getIconWidth() / (1.0 * (double)this.imgWelcome.getIconWidth());
    }
}

