/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.GamePlayer;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;

public abstract class AbstractPlayerMap {
    protected AbstractPlayerMap() {
    }

    public abstract void saveMap(Document var1, Element var2);

    public Element saveMap(Document doc, Element root, String newNode) {
        Element mapNode = doc.createElement(newNode);
        this.saveMap(doc, mapNode);
        root.appendChild(mapNode);
        return mapNode;
    }

    public abstract void resetPlayers();

    public void loadMap(Node root) {
        final GameEngine engine = GameManager.getInstance().getGameEngine();
        this.resetPlayers();
        ChildNodeIterator.run(new ChildNodeIterator(root, this){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (node.getNodeName().startsWith("player")) {
                    AbstractPlayerMap.this.loadNode(engine, node);
                }
            }
        });
    }

    protected abstract void loadNode(GameEngine var1, Node var2);

    public abstract GamePlayer[] getPlayers();

    public String toNetworkString() {
        StringBuilder data = new StringBuilder();
        GameEngine engine = GameManager.getInstance().getGameEngine();
        GamePlayer[] players = this.getPlayers();
        int i = 0;
        while (i < players.length) {
            if (i > 0) {
                data.append("%");
            }
            int index = engine.getIndexOfPlayer(players[i]);
            data.append(index);
            data.append("=");
            this.appendPlayerData(data, players[i]);
            ++i;
        }
        if (data.length() == 0) {
            data.append("^");
        }
        return data.toString();
    }

    protected abstract void appendPlayerData(StringBuilder var1, GamePlayer var2);

    public boolean fromNetworkString(String data) {
        this.resetPlayers();
        if (data.equals("^")) {
            return true;
        }
        GameEngine engine = GameManager.getInstance().getGameEngine();
        String[] datas = data.split("%");
        int i = 0;
        while (i < datas.length) {
            GamePlayer p;
            String[] value = datas[i].split("=");
            if (value.length > 2) {
                return false;
            }
            if (!(value.length != 2 || (p = engine.getPlayerWithIndex(HGBaseTools.toInt(value[0]))) != null && this.readPlayerData(p, value[1]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract boolean readPlayerData(GamePlayer var1, String var2);
}

