/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.xml.HGBaseXMLTools;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.lib.XmlMapConverter;

public abstract class AbstractXmlMapByAttributeConverter<K, V>
implements XmlMapConverter<K, V> {
    private static final String XML_KEY = "key";
    private static final String XML_VALUE = "value";
    private String keyAttributeName;
    private String valueAttributeName;

    protected AbstractXmlMapByAttributeConverter() {
        this(XML_KEY, XML_VALUE);
    }

    protected AbstractXmlMapByAttributeConverter(String keyAttributeName, String valueAttributeName) {
        this.keyAttributeName = keyAttributeName;
        this.valueAttributeName = valueAttributeName;
    }

    @Override
    public void writeNode(Element itemNode, K key, V value) {
        itemNode.setAttribute(this.keyAttributeName, this.keyToString(key));
        itemNode.setAttribute(this.valueAttributeName, this.valueToString(value));
    }

    @Override
    public K readKey(Node itemNode) {
        return this.stringToKey(HGBaseXMLTools.getAttributeValue(itemNode, this.keyAttributeName));
    }

    @Override
    public V readValue(Node itemNode) {
        return this.stringToValue(HGBaseXMLTools.getAttributeValue(itemNode, this.valueAttributeName));
    }

    protected String keyToString(K key) {
        return key == null ? "" : key.toString();
    }

    protected String valueToString(V value) {
        return value == null ? "" : value.toString();
    }

    protected abstract K stringToKey(String var1);

    protected abstract V stringToValue(String var1);
}

