/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.GamePlayer;
import tjger.game.GameRules;
import tjger.game.GameState;
import tjger.game.MoveInformation;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.lib.AiAnalyzer;
import tjger.lib.AiMoveEvaluator;
import tjger.lib.AiMoveInformation;
import tjger.lib.DiceUtil;
import tjger.lib.MoveUtil;

public final class AiAlgorithms {
    private static final GameRules rules = GameManager.getInstance().getGameRules();
    private static final GameEngine engine = GameManager.getInstance().getGameEngine();
    private static int currentDepth = 0;
    private static int currentStep = 0;
    private static int countEvaluations = 0;

    public static int getCurrentDepth() {
        return currentDepth;
    }

    public static int getCurrentStep() {
        return currentStep;
    }

    public static int getCountEvaluations() {
        return countEvaluations;
    }

    private static GamePlayer getNextPlayer(GamePlayer player, MoveInformation move, GameState state) {
        if (MoveUtil.isMoveComplete(move)) {
            return rules.getNextPlayer(player, state);
        }
        return player;
    }

    public static AiMoveInformation getMiniMaxMove(int depth, AiMoveEvaluator evaluator) {
        return AiAlgorithms.getMiniMaxMove(depth, evaluator, true);
    }

    public static AiMoveInformation getMiniMaxMove(int depth, AiMoveEvaluator evaluator, boolean usePruning) {
        if (HGBaseConfig.getBoolean("aianalyzer")) {
            String gameName = HGBaseSettings.get("appName", "GameState");
            String extension = HGBaseSettings.get("fileExtensions", "xml");
            GameManager.getInstance().getMainFrame().onFileSave(AiAnalyzer.getAnalyzerFile(gameName, extension));
            AiAnalyzer ai = new AiAnalyzer();
            AiMoveInformation move = AiAlgorithms.getMiniMaxMove(depth, evaluator, usePruning, ai);
            ai.writeXML(AiAnalyzer.getAnalyzerFile("AiAnalyzer", "xml"));
            return move;
        }
        return AiAlgorithms.getMiniMaxMove(depth, evaluator, usePruning, null);
    }

    public static AiMoveInformation getMiniMaxMove(int depth, AiMoveEvaluator evaluator, boolean usePruning, AiAnalyzer analyzer) {
        AiMoveInformation bestMove;
        currentDepth = depth;
        currentStep = 0;
        countEvaluations = 0;
        GameState state = (GameState)engine.getGameState().clone();
        GamePlayer player = engine.getCurrentPlayer();
        Element analysisRoot = AiAlgorithms.createAnalysisRoot(analyzer, player);
        Date startTimestamp = null;
        Date stopTimestamp = null;
        long duration = 0L;
        if (usePruning) {
            StartingAlphaMove alpha = new StartingAlphaMove();
            StartingBetaMove beta = new StartingBetaMove();
            if (analyzer != null) {
                startTimestamp = new Date();
                HGBaseTools.testPerformance();
            }
            bestMove = AiAlgorithms.getMiniMaxMoveAlphaBetaPruning(depth, currentStep, null, alpha, beta, player, null, state, evaluator, true, analyzer, analysisRoot);
            if (analyzer != null) {
                duration = HGBaseTools.testPerformance();
                stopTimestamp = new Date();
            }
            if (bestMove instanceof StartingAlphaMove || bestMove instanceof StartingBetaMove) {
                bestMove = null;
            }
        } else {
            if (analyzer != null) {
                startTimestamp = new Date();
                HGBaseTools.testPerformance();
            }
            bestMove = AiAlgorithms.getMiniMaxMove(depth, currentStep, null, player, state, evaluator, true, analyzer, analysisRoot);
            if (analyzer != null) {
                duration = HGBaseTools.testPerformance();
                stopTimestamp = new Date();
            }
        }
        AiAlgorithms.setAnalysisSummary(analyzer, analysisRoot, AiAlgorithms.getCountEvaluations(), duration, startTimestamp, stopTimestamp, bestMove);
        return bestMove;
    }

    private static AiMoveInformation getMiniMaxMove(int depth, int step, AiMoveInformation evaluateMove, GamePlayer player, GameState state, AiMoveEvaluator evaluator, boolean isMax, AiAnalyzer analyzer, Element analysisParentNode) {
        AiMoveInformation[] possibleMoves;
        if (!engine.isActiveGame() || !engine.isActiveRound()) {
            return null;
        }
        boolean gameFinished = rules.isGameFinished(state);
        if (depth == 0 || gameFinished) {
            if (evaluateMove == null) {
                return null;
            }
            long value = evaluator.evaluateState(step, player, evaluateMove, state, rules);
            if (!player.equals(engine.getCurrentPlayer())) {
                value *= -1L;
            }
            evaluateMove.setEvaluationValue(value);
            ++countEvaluations;
            AiAlgorithms.appendEvaluationAnalysis(analyzer, analysisParentNode, step, player, evaluateMove, state, value);
            return evaluateMove;
        }
        currentDepth = depth;
        currentStep = step + 1;
        Element stepNode = AiAlgorithms.appendStepAnalysis(analyzer, analysisParentNode, currentDepth, currentStep, isMax, player, state, null, null);
        int numPossible = 0;
        ArrayList<AiMoveInformation> bestMoves = new ArrayList<AiMoveInformation>();
        AiMoveInformation bestValue = null;
        AiMoveInformation[] aiMoveInformationArray = possibleMoves = evaluator.generateMoves(player, state, rules);
        int n = possibleMoves.length;
        int n2 = 0;
        while (n2 < n) {
            AiMoveInformation nextMove = aiMoveInformationArray[n2];
            if (rules.isValidMove(nextMove, state)) {
                boolean helpIsMax;
                Element moveNode = AiAlgorithms.appendValidMoveAnalysis(analyzer, stepNode, nextMove, player, state);
                ++numPossible;
                state.changeState(player, nextMove, engine);
                AiAlgorithms.setMoveAnalysisChangedState(analyzer, moveNode, state);
                GamePlayer nextPlayer = AiAlgorithms.getNextPlayer(player, nextMove, state);
                boolean bl = helpIsMax = nextPlayer == null || depth == 1 ? isMax : nextPlayer.equals(engine.getCurrentPlayer());
                if (nextPlayer == null || depth == 1) {
                    nextPlayer = player;
                }
                AiMoveInformation move = AiAlgorithms.getMiniMaxMove(depth - 1, step + 1, nextMove, nextPlayer, state, evaluator, helpIsMax, analyzer, moveNode);
                state.undoMove(player, nextMove);
                if (move != null) {
                    long evaluationValue = move.getEvaluationValue();
                    nextMove.setEvaluationValue(evaluationValue);
                    AiAlgorithms.setMoveAnalysisEvaluationValue(analyzer, moveNode, evaluationValue);
                    long bestEvaluationValue = AiAlgorithms.getEvaluationValue(bestValue);
                    if (bestValue == null) {
                        bestValue = nextMove;
                        bestMoves.add(nextMove);
                    } else if (evaluationValue == bestEvaluationValue) {
                        bestMoves.add(nextMove);
                    } else if (isMax && evaluationValue > bestEvaluationValue) {
                        bestValue = nextMove;
                        bestMoves.clear();
                        bestMoves.add(nextMove);
                    } else if (!isMax && evaluationValue < bestEvaluationValue) {
                        bestValue = nextMove;
                        bestMoves.clear();
                        bestMoves.add(nextMove);
                    }
                }
            } else {
                AiAlgorithms.appendInvalidMoveAnalysis(analyzer, stepNode, nextMove);
            }
            ++n2;
        }
        if (numPossible == 0) {
            return AiAlgorithms.getMiniMaxMove(0, step, evaluateMove, player, state, evaluator, false, analyzer, stepNode);
        }
        AiAlgorithms.setStepAnalysisEvaluationValue(analyzer, stepNode, AiAlgorithms.getEvaluationValue(bestValue));
        AiMoveInformation bestMove = bestMoves.isEmpty() ? null : bestMoves.get(DiceUtil.throwDice(0, bestMoves.size() - 1));
        AiAlgorithms.markStepAnalysisBestMoves(analyzer, stepNode, bestMoves, bestMove);
        return bestMove;
    }

    private static AiMoveInformation getMiniMaxMoveAlphaBetaPruning(int depth, int step, AiMoveInformation evaluateMove, AiMoveInformation alpha, AiMoveInformation beta, GamePlayer player, GamePlayer prevPlayer, GameState state, AiMoveEvaluator evaluator, boolean isMax, AiAnalyzer analyzer, Element analysisParentNode) {
        AiMoveInformation[] possibleMoves;
        if (!engine.isActiveGame() || !engine.isActiveRound()) {
            return null;
        }
        if (depth == 0 || rules.isGameFinished(state)) {
            if (evaluateMove == null || prevPlayer == null) {
                return null;
            }
            long value = evaluator.evaluateState(step, player, evaluateMove, state, rules);
            if (!player.equals(engine.getCurrentPlayer())) {
                value *= -1L;
            }
            evaluateMove.setEvaluationValue(value);
            ++countEvaluations;
            AiAlgorithms.appendEvaluationAnalysis(analyzer, analysisParentNode, step, player, evaluateMove, state, value);
            return evaluateMove;
        }
        currentDepth = depth;
        currentStep = step + 1;
        Element stepNode = AiAlgorithms.appendStepAnalysis(analyzer, analysisParentNode, currentDepth, currentStep, isMax, player, state, alpha.getEvaluationValue(), beta.getEvaluationValue());
        int numPossible = 0;
        ArrayList<AiMoveInformation> bestMoves = new ArrayList<AiMoveInformation>();
        AiMoveInformation bestValue = null;
        bestValue = isMax ? alpha : beta;
        AiMoveInformation[] aiMoveInformationArray = possibleMoves = evaluator.generateMoves(player, state, rules);
        int n = possibleMoves.length;
        int n2 = 0;
        while (n2 < n) {
            AiMoveInformation nextMove = aiMoveInformationArray[n2];
            if (rules.isValidMove(nextMove, state)) {
                boolean helpIsMax;
                Element moveNode = AiAlgorithms.appendValidMoveAnalysis(analyzer, stepNode, nextMove, player, state);
                ++numPossible;
                state.changeState(player, nextMove, engine);
                AiAlgorithms.setMoveAnalysisChangedState(analyzer, moveNode, state);
                AiMoveInformation helpAlpha = isMax ? bestValue : alpha;
                AiMoveInformation helpBeta = isMax ? beta : bestValue;
                GamePlayer nextPlayer = AiAlgorithms.getNextPlayer(player, nextMove, state);
                GamePlayer currentPlayer = player;
                boolean bl = helpIsMax = nextPlayer == null || depth == 1 ? isMax : nextPlayer.equals(engine.getCurrentPlayer());
                if (nextPlayer == null || depth == 1) {
                    nextPlayer = player;
                    currentPlayer = prevPlayer;
                }
                AiMoveInformation move = AiAlgorithms.getMiniMaxMoveAlphaBetaPruning(depth - 1, step + 1, nextMove, helpAlpha, helpBeta, nextPlayer, player, state, evaluator, helpIsMax, analyzer, moveNode);
                state.undoMove(player, nextMove);
                if (move != null) {
                    long evaluationValue = move.getEvaluationValue();
                    nextMove.setEvaluationValue(evaluationValue);
                    AiAlgorithms.setMoveAnalysisEvaluationValue(analyzer, moveNode, evaluationValue);
                    long bestEvaluationValue = AiAlgorithms.getEvaluationValue(bestValue);
                    if (isMax) {
                        if (evaluationValue > bestEvaluationValue) {
                            if (evaluationValue > beta.getEvaluationValue()) {
                                AiAlgorithms.setStepAnalysisEvaluationValue(analyzer, stepNode, evaluationValue);
                                AiAlgorithms.setMoveAnalysisPruningInformation(analyzer, moveNode, null, beta.getEvaluationValue());
                                return nextMove;
                            }
                            bestValue = nextMove;
                            bestMoves.clear();
                            bestMoves.add(nextMove);
                        } else if (evaluationValue == bestEvaluationValue) {
                            bestMoves.add(nextMove);
                        }
                    } else if (evaluationValue < bestEvaluationValue) {
                        if (evaluationValue < alpha.getEvaluationValue()) {
                            AiAlgorithms.setStepAnalysisEvaluationValue(analyzer, stepNode, evaluationValue);
                            AiAlgorithms.setMoveAnalysisPruningInformation(analyzer, moveNode, alpha.getEvaluationValue(), null);
                            return nextMove;
                        }
                        bestValue = nextMove;
                        bestMoves.clear();
                        bestMoves.add(nextMove);
                    } else if (evaluationValue == bestEvaluationValue) {
                        bestMoves.add(nextMove);
                    }
                }
            } else {
                AiAlgorithms.appendInvalidMoveAnalysis(analyzer, stepNode, nextMove);
            }
            ++n2;
        }
        if (numPossible == 0) {
            return AiAlgorithms.getMiniMaxMoveAlphaBetaPruning(0, step, evaluateMove, alpha, beta, player, prevPlayer, state, evaluator, false, analyzer, stepNode);
        }
        AiMoveInformation bestMove = bestMoves.isEmpty() ? (isMax ? new StartingAlphaMove() : new StartingBetaMove()) : (AiMoveInformation)bestMoves.get(DiceUtil.throwDice(0, bestMoves.size() - 1));
        AiAlgorithms.setStepAnalysisEvaluationValue(analyzer, stepNode, AiAlgorithms.getEvaluationValue(bestMove));
        AiAlgorithms.markStepAnalysisBestMoves(analyzer, stepNode, bestMoves, bestMove);
        return bestMove;
    }

    private static long getEvaluationValue(AiMoveInformation move) {
        return move == null ? Long.MIN_VALUE : move.getEvaluationValue();
    }

    private static Element createAnalysisRoot(AiAnalyzer analyzer, GamePlayer player) {
        if (analyzer != null) {
            return analyzer.createRootNode(player);
        }
        return null;
    }

    private static Element appendStepAnalysis(AiAnalyzer analyzer, Element parentNode, int depth, int step, boolean isMax, GamePlayer player, GameState state, Long alpha, Long beta) {
        if (analyzer != null) {
            return analyzer.appendStep(parentNode, depth, step, isMax, player, state, alpha, beta);
        }
        return null;
    }

    private static void markStepAnalysisBestMoves(AiAnalyzer analyzer, Node stepNode, ArrayList<AiMoveInformation> bestMoves, AiMoveInformation chosenMove) {
        if (analyzer != null) {
            analyzer.markStepBestMoves(stepNode, bestMoves, chosenMove);
        }
    }

    private static void setStepAnalysisEvaluationValue(AiAnalyzer analyzer, Element stepNode, long evaluationValue) {
        if (analyzer != null) {
            analyzer.setStepEvaluationValueAttribute(stepNode, evaluationValue);
        }
    }

    private static void appendEvaluationAnalysis(AiAnalyzer analyzer, Element parentNode, int step, GamePlayer player, AiMoveInformation move, GameState state, long evaluationValue) {
        if (analyzer != null) {
            analyzer.appendEvaluation(parentNode, step, player, move, state, evaluationValue);
        }
    }

    private static Element appendValidMoveAnalysis(AiAnalyzer analyzer, Element parentNode, AiMoveInformation move, GamePlayer player, GameState stateBefore) {
        if (analyzer != null) {
            return analyzer.appendValidMove(parentNode, move, player, stateBefore);
        }
        return null;
    }

    private static void setMoveAnalysisChangedState(AiAnalyzer analyzer, Element moveNode, GameState stateAfter) {
        if (analyzer != null) {
            analyzer.setMoveChangedStateAttribute(moveNode, stateAfter);
        }
    }

    private static void setMoveAnalysisEvaluationValue(AiAnalyzer analyzer, Element moveNode, long evaluationValue) {
        if (analyzer != null) {
            analyzer.setMoveEvaluationValueAttribute(moveNode, evaluationValue);
        }
    }

    private static void setMoveAnalysisPruningInformation(AiAnalyzer analyzer, Element moveNode, Long alpha, Long beta) {
        if (analyzer != null) {
            analyzer.setMovePruningInformation(moveNode, alpha, beta);
        }
    }

    private static void appendInvalidMoveAnalysis(AiAnalyzer analyzer, Element parentNode, AiMoveInformation move) {
        if (analyzer != null) {
            analyzer.appendInvalidMove(parentNode, move);
        }
    }

    private static void setAnalysisSummary(AiAnalyzer analyzer, Element rootNode, int countEvaluations, long duration, Date startTimestamp, Date stopTimestamp, AiMoveInformation bestMove) {
        if (analyzer != null) {
            analyzer.setAnalysisSummaryAttributes(rootNode, countEvaluations, duration, startTimestamp, stopTimestamp, bestMove);
        }
    }

    private static class StartingAlphaMove
    extends AiMoveInformation {
        public StartingAlphaMove() {
            this.setEvaluationValue(Long.MIN_VALUE);
        }

        @Override
        public Object clone() {
            return new StartingAlphaMove();
        }
    }

    private static class StartingBetaMove
    extends AiMoveInformation {
        public StartingBetaMove() {
            this.setEvaluationValue(Long.MAX_VALUE);
        }

        @Override
        public Object clone() {
            return new StartingBetaMove();
        }
    }
}

