/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.HGBaseStringBuilder;
import hgb.lib.HGBaseTools;
import java.util.List;
import tjger.game.completed.GameConfig;
import tjger.gui.completed.Card;
import tjger.gui.completed.CardSet;
import tjger.lib.ArrayUtil;

public class NetworkUtil {
    private NetworkUtil() {
    }

    public static String fromIntArray(int[] array) {
        if (array == null) {
            return "^";
        }
        HGBaseStringBuilder msg = new HGBaseStringBuilder("/");
        int i = 0;
        while (i < array.length) {
            msg.append(String.valueOf(array[i]));
            ++i;
        }
        return msg.toString();
    }

    public static int[] toIntArray(String msg) {
        if (msg.isEmpty() || msg.equals("^")) {
            return null;
        }
        String[] array = msg.split("/");
        int[] values = new int[array.length];
        int i = 0;
        while (i < values.length) {
            values[i] = HGBaseTools.toInt(array[i]);
            ++i;
        }
        return values;
    }

    public static String fromBooleanArray(boolean[] array) {
        if (array == null) {
            return "^";
        }
        HGBaseStringBuilder msg = new HGBaseStringBuilder("/");
        int i = 0;
        while (i < array.length) {
            msg.append(array[i] ? "1" : "0");
            ++i;
        }
        return msg.toString();
    }

    public static boolean[] toBooleanArray(String msg) {
        if (msg.equals("^")) {
            return null;
        }
        String[] array = msg.split("/");
        boolean[] values = new boolean[array.length];
        int i = 0;
        while (i < values.length) {
            values[i] = array[i].equals("1");
            ++i;
        }
        return values;
    }

    public static String fromStringArray(String[] array) {
        if (array == null) {
            return "^";
        }
        HGBaseStringBuilder msg = new HGBaseStringBuilder("/");
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                msg.append(array[i]);
            }
            ++i;
        }
        return msg.toString();
    }

    public static String[] toStringArray(String msg) {
        if (msg.equals("^")) {
            return null;
        }
        String[] values = msg.split("/");
        int i = 0;
        while (i < values.length) {
            if (values[i].equals("^")) {
                values[i] = "^";
            }
            ++i;
        }
        return values;
    }

    public static String fromCardArray(Card[] array) {
        if (array == null) {
            return "^";
        }
        HGBaseStringBuilder msg = new HGBaseStringBuilder("/");
        int i = 0;
        while (i < array.length) {
            msg.append(NetworkUtil.fromCard(array[i]));
            ++i;
        }
        return msg.toString();
    }

    public static String fromCardList(List<Card> cardList) {
        if (cardList == null) {
            return "^";
        }
        return NetworkUtil.fromCardArray(ArrayUtil.toCard(cardList));
    }

    public static String fromCard(Card card) {
        if (card == null) {
            return "^";
        }
        String type = card.getCardSet().getType();
        String data = String.valueOf(card.getColor()) + "-" + card.getSequence();
        if (!"game.cardset".equals(type)) {
            data = String.valueOf(data) + "-" + type;
        }
        return data;
    }

    public static Card[] toCardArray(String msg) {
        if (msg.equals("^")) {
            return null;
        }
        String[] array = msg.split("/");
        if (array.length == 1 && array[0].equals("")) {
            return new Card[0];
        }
        Card[] values = new Card[array.length];
        int i = 0;
        while (i < values.length) {
            values[i] = NetworkUtil.toCard(array[i]);
            ++i;
        }
        return values;
    }

    public static List<Card> toCardList(String msg) {
        Card[] cards = NetworkUtil.toCardArray(msg);
        return cards == null ? null : ArrayUtil.toList(cards);
    }

    public static Card toCard(String msg) {
        if (msg == null || msg.equals("^")) {
            return null;
        }
        String[] parts = msg.split("-");
        if (parts.length < 2) {
            return null;
        }
        String color = parts[0];
        int sequence = HGBaseTools.toInt(parts[1]);
        String type = parts.length >= 3 ? parts[2] : "game.cardset";
        CardSet set = GameConfig.getInstance().getActiveCardSet(type);
        if (set == null) {
            return null;
        }
        return set.getCard(color, sequence);
    }
}

