/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.HGBaseTools;
import hgb.lib.xml.HGBaseXMLTools;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.GamePlayer;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.lib.AbstractPlayerMap;

public class PlayerIntMap
extends AbstractPlayerMap
implements Cloneable {
    private Map<GamePlayer, Integer> mapInts;

    public PlayerIntMap() {
        this.resetPlayers();
    }

    public void newPlayer(GamePlayer player) {
        this.mapInts.put(player, 0);
    }

    @Override
    public void resetPlayers() {
        this.mapInts = new HashMap<GamePlayer, Integer>();
    }

    public void resetValues(int value) {
        GamePlayer[] p = this.getPlayers();
        int i = 0;
        while (i < p.length) {
            this.setValue(p[i], value);
            ++i;
        }
    }

    public void setValue(GamePlayer player, int value) {
        this.mapInts.put(player, value);
    }

    public int getValue(GamePlayer player) {
        return this.getValue(player, -2147483631);
    }

    public int getValue(GamePlayer player, int defaultValue) {
        Integer value = this.mapInts.get(player);
        return value == null ? defaultValue : value;
    }

    public void addValue(GamePlayer player, int valueToAdd) {
        int oldValue = this.getValue(player, 0);
        this.setValue(player, oldValue + valueToAdd);
    }

    @Override
    public GamePlayer[] getPlayers() {
        return this.mapInts.keySet().toArray(new GamePlayer[this.mapInts.size()]);
    }

    @Override
    public void saveMap(Document doc, Element root) {
        GamePlayer[] player = this.getPlayers();
        int i = 0;
        while (i < player.length) {
            int index = GameManager.getInstance().getGameEngine().getIndexOfPlayer(player[i]);
            Element eP = doc.createElement("player" + index);
            eP.setAttribute("value", String.valueOf(this.getValue(player[i])));
            root.appendChild(eP);
            ++i;
        }
    }

    @Override
    protected void loadNode(GameEngine engine, Node node) {
        GamePlayer p;
        int player = HGBaseTools.toInt(node.getNodeName().replaceFirst("player", ""));
        int value = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "value"));
        if (player >= 0 && value != -2147483631 && (p = engine.getPlayerWithIndex(player)) != null) {
            this.setValue(p, value);
        }
    }

    @Override
    protected void appendPlayerData(StringBuilder data, GamePlayer player) {
        data.append(this.getValue(player));
    }

    @Override
    protected boolean readPlayerData(GamePlayer player, String string) {
        int v = HGBaseTools.toInt(string);
        if (HGBaseTools.isValid(v)) {
            this.setValue(player, v);
            return true;
        }
        return false;
    }

    public Object clone() {
        PlayerIntMap newMap = new PlayerIntMap();
        GamePlayer[] players = this.getPlayers();
        int i = 0;
        while (i < players.length) {
            newMap.setValue(players[i], this.getValue(players[i]));
            ++i;
        }
        return newMap;
    }

    public String toString() {
        return this.mapInts == null ? "null" : this.mapInts.entrySet().toString();
    }

    public int getAllValues() {
        int sum = 0;
        GamePlayer[] players = this.getPlayers();
        int i = 0;
        while (i < players.length) {
            sum += this.getValue(players[i], 0);
            ++i;
        }
        return sum;
    }
}

