/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import tjger.lib.ShortestPath;
import tjger.lib.ShortestPathMethods;

public class ShortestPathFinder {
    private static final int NOVISIT = 0;
    private static final int VISITED = 1;

    private ShortestPathFinder() {
    }

    public static <T> ShortestPath<T> find(ShortestPathMethods<T> methods) {
        T[] fieldList = methods.getAllFields();
        int maxNrNodes = fieldList.length;
        int from = methods.getIndexOfField(methods.getStartField());
        int to = methods.getIndexOfField(methods.getTargetField());
        if (from >= 0 && to >= 0) {
            if (from == to) {
                ArrayList<T> path = new ArrayList<T>();
                path.add(methods.getStartField());
                return new ShortestPath(path, 0);
            }
            int[] parent = ShortestPathFinder.createIntList(maxNrNodes, -1);
            int[] weight = ShortestPathFinder.createIntList(maxNrNodes, 0);
            int[] allNodes = ShortestPathFinder.createIntList(maxNrNodes, 0);
            int minW = -1;
            int nearN = -1;
            int fromN = -1;
            boolean neighbourFound = false;
            int maximumWeight = methods.getMaxWeightToSearch();
            allNodes[from] = 1;
            do {
                neighbourFound = false;
                int i = 0;
                while (i < maxNrNodes) {
                    if (allNodes[i] == 1) {
                        T[] neighbours = methods.getNeighbours(fieldList[i]);
                        int j = 0;
                        while (j < neighbours.length) {
                            int neighbourIndex = methods.getIndexOfField(neighbours[j]);
                            if (allNodes[neighbourIndex] == 0) {
                                int newW = methods.getWeight(fieldList[i], fieldList[neighbourIndex]);
                                if (!neighbourFound || newW + weight[i] < minW) {
                                    fromN = i;
                                    nearN = neighbourIndex;
                                    minW = weight[i] + newW;
                                    neighbourFound = true;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                if (neighbourFound) {
                    allNodes[nearN] = 1;
                    weight[nearN] = minW;
                    parent[nearN] = fromN;
                    if (maximumWeight <= 0 || maximumWeight >= minW) continue;
                    break;
                }
                return null;
            } while (nearN != to);
            ArrayList<T> path = new ArrayList<T>();
            path.add(fieldList[to]);
            int i = to;
            do {
                path.add(fieldList[parent[i]]);
            } while ((i = parent[i]) != from);
            Collections.reverse(path);
            return new ShortestPath(path, minW);
        }
        return null;
    }

    private static int[] createIntList(int listLength, int defaultValue) {
        int[] list = new int[listLength];
        Arrays.fill(list, defaultValue);
        return list;
    }
}

