/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.HGBaseText;
import javax.swing.ImageIcon;
import tjger.MainFrame;
import tjger.MainStatusBar;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.GameStateListener;
import tjger.game.completed.GameEngine;
import tjger.gui.completed.Piece;
import tjger.gui.completed.PieceSet;
import tjger.lib.ImageUtil;

public class SimpleStatusBar
extends MainStatusBar
implements GameStateListener {
    private static final long serialVersionUID = 7344592918662057724L;
    protected GameEngine engine;

    public SimpleStatusBar(int[] panelWidth, MainFrame frame) {
        super(panelWidth, frame);
        this.engine = frame.getGameManager().getGameEngine();
        this.engine.addGameStateListener(this);
    }

    @Override
    public void actualizeText() {
        this.setText(this.getDefaultGameStateText());
    }

    protected String getDefaultGameStateText() {
        if (this.engine.isActiveGame()) {
            if (this.engine.isActiveRound()) {
                GamePlayer p = this.engine.getCurrentPlayer();
                if (p != null) {
                    return p.getName();
                }
                return "";
            }
            return HGBaseText.getText("status.roundfinished", new String[0]);
        }
        if (this.engine.isStoppedGame()) {
            return "";
        }
        return HGBaseText.getText("status.gamefinished", new String[0]);
    }

    protected void showActivePlayerIcon() {
        GamePlayer p;
        if (this.engine.isActiveGame() && this.engine.isActiveRound() && (p = this.engine.getCurrentPlayer()) != null) {
            ImageIcon img = p.getImage();
            if (img != null) {
                ImageUtil.setImageOnLabel(this.getLabel(0), img);
            } else {
                int startSequence;
                String color = p.getPieceColor();
                PieceSet pieceSet = this.engine.getGameManager().getGameConfig().getActivePieceSet();
                Piece piece = pieceSet.getPiece(color, startSequence = pieceSet.getStartSequence(color));
                if (piece != null) {
                    ImageUtil.setImageOnLabel(this.getLabel(0), piece.getImage());
                }
            }
            return;
        }
        this.getLabel(0).setIcon(null);
    }

    @Override
    public void newGameStarted(GameState state, GameEngine engine) {
    }

    @Override
    public void newRoundStarted(GameState state, GameEngine engine) {
    }

    @Override
    public void newTurnStarted(GameState state, GameEngine engine) {
    }

    @Override
    public void gameFinished(boolean normal) {
        this.actualizeText();
    }

    @Override
    public void gameStateBeforeMove(GameState state, GameEngine engine) {
        this.actualizeText();
    }

    @Override
    public void gameStateAfterMove(GameState state, GameEngine engine) {
        this.actualizeText();
    }
}

