/*
 * Decompiled with CFR 0.152.
 */
package tjger.net;

import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseStringBuilder;
import java.util.ArrayList;
import java.util.List;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.MoveInformation;
import tjger.game.completed.GameManager;

public class NetworkMessage {
    public static final String MSG_CTRL = "TJxCTRL";
    public static final String MSG_ERROR = "TJxERR";
    public static final String MSG_ENGINE = "TJxGE";
    public static final String MSG_STATE = "TJxGS";
    public static final String MSG_MOVE = "TJxMI";
    public static final String PARAM_CLIENTCONN = "CLCON";
    public static final String PARAM_SERVERACC = "SRACC";
    public static final String PARAM_CLIENTACC = "CLACK";
    public static final String PARAM_NEWGAME = "NEWGM";
    public static final String PARAM_NEXTGAME = "NEXTGM";
    public static final String PARAM_GAMEOK = "GMOK";
    public static final String PARAM_PLAYERNAME = "PLNAM";
    public static final String PARAM_TEST = "TEST";
    public static final String ERROR_ABORT = "err.netabort";
    public static final String ERROR_NAME = "err.netname";
    public static final String ERROR_NEXTGAME = "err.nextgame";
    public static final String ERROR_APPLICATION = "err.application";

    private NetworkMessage() {
    }

    private static String createString(List<String> msg) {
        StringBuffer message = new StringBuffer(128);
        if (msg != null) {
            int msgSize = msg.size();
            int i = 0;
            while (i < msgSize) {
                if (i > 0) {
                    message.append(";");
                }
                message.append(msg.get(i));
                ++i;
            }
        }
        return message.toString();
    }

    public static String msgError(String errMsg) {
        ArrayList<String> al = new ArrayList<String>();
        al.add(MSG_ERROR);
        al.add(errMsg);
        return NetworkMessage.createString(al);
    }

    public static String msgNameExistsS() {
        return NetworkMessage.msgError(ERROR_NAME);
    }

    public static String msgAbort() {
        return NetworkMessage.msgError(ERROR_ABORT);
    }

    public static String msgWrongApplicationS() {
        ArrayList<String> al = new ArrayList<String>();
        al.add(MSG_ERROR);
        al.add(ERROR_APPLICATION);
        al.add(HGBaseSettings.get("appName"));
        return NetworkMessage.createString(al);
    }

    public static String msgTestS() {
        ArrayList<String> al = new ArrayList<String>();
        al.add(MSG_CTRL);
        al.add(PARAM_TEST);
        return NetworkMessage.createString(al);
    }

    public static String msgShakehandS(int id) {
        ArrayList<String> al = new ArrayList<String>();
        al.add(MSG_CTRL);
        al.add(PARAM_SERVERACC);
        al.add(String.valueOf(id));
        return NetworkMessage.createString(al);
    }

    public static String msgShakehandC(String name, String ip) {
        ArrayList<String> al = new ArrayList<String>();
        al.add(MSG_CTRL);
        al.add(PARAM_CLIENTCONN);
        al.add(HGBaseSettings.get("appName"));
        al.add(name);
        al.add(ip);
        return NetworkMessage.createString(al);
    }

    public static String msgAcknowledgeC() {
        ArrayList<String> al = new ArrayList<String>();
        al.add(MSG_CTRL);
        al.add(PARAM_CLIENTACC);
        return NetworkMessage.createString(al);
    }

    public static String msgNewGameInfoS(int clientNr, GameManager manager) {
        String[] keys = manager.getNewGameInformationKeys();
        StringBuffer ngi = new StringBuffer(128);
        int i = 0;
        while (i < keys.length) {
            if (i > 0) {
                ngi.append("/");
            }
            ngi.append(keys[i]);
            ngi.append("=");
            ngi.append(manager.getNewGameInformationInt(keys[i]));
            ++i;
        }
        ArrayList<String> al = new ArrayList<String>();
        al.add(MSG_ENGINE);
        al.add(PARAM_NEWGAME);
        al.add(String.valueOf(clientNr));
        al.add(String.valueOf(manager.getGameEngine().getCyclingFirstGamePlayerIndex()));
        al.add(ngi.toString());
        return NetworkMessage.createString(al);
    }

    public static String msgPlayerNamesS(GamePlayer[] players) {
        HGBaseStringBuilder names = new HGBaseStringBuilder("/");
        GamePlayer[] gamePlayerArray = players;
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            GamePlayer player = gamePlayerArray[n2];
            names.append(String.valueOf(player.getName()) + "=" + player.getPieceColor());
            ++n2;
        }
        ArrayList<String> al = new ArrayList<String>();
        al.add(MSG_ENGINE);
        al.add(PARAM_PLAYERNAME);
        al.add(names.toString());
        return NetworkMessage.createString(al);
    }

    public static String msgClientGameOkC(String msgType) {
        ArrayList<String> al = new ArrayList<String>();
        al.add(msgType);
        al.add(PARAM_GAMEOK);
        return NetworkMessage.createString(al);
    }

    public static String msgGameStateS(GameState state) {
        ArrayList<String> al = new ArrayList<String>();
        al.add(MSG_STATE);
        al.add(state.toNetworkString());
        return NetworkMessage.createString(al);
    }

    public static String msgMoveInformationS(GameState state, MoveInformation move) {
        ArrayList<String> al = new ArrayList<String>();
        al.add(MSG_MOVE);
        al.add(state.toNetworkStringMove(move));
        return NetworkMessage.createString(al);
    }

    public static String msgNextGameS() {
        ArrayList<String> al = new ArrayList<String>();
        al.add(MSG_ENGINE);
        al.add(PARAM_NEXTGAME);
        return NetworkMessage.createString(al);
    }
}

