/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.game;

import com.tjger.goldensheep.desktop.game.SheepPlayerUtil;
import com.tjger.goldensheep.desktop.game.SheepRules;
import com.tjger.goldensheep.desktop.game.SheepState;
import hgb.lib.HGBaseTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.PlayingFieldManager;
import tjger.game.completed.playingfield.SingleField;

public class SheepPlayingField {
    private static final String PLAYING_FIELD_NAME = "goldensheep";
    public static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_ORDER = "order";
    public static final String FIELD_TYPE_HOME = "home";
    private static final String FIELD_TYPE_BATTLEGROUND = "battleground";
    private static final String FIELD_TYPE_BATTLEGROUND_GATE = "battleground_gate";
    private static final String FIELD_TYPE_SHELTER = "shelter";
    private static final String FIELD_TYPE_PREDATOR_WAY = "predator_way";
    private static final String FIELD_TYPE_PREDATOR_START = "predator_start";
    private static final String FIELD_TYPE_PREDATOR_GATE = "predator_gate";
    public static final String FIELD_TYPE_PREDATOR_RESERVE = "predator_reserve";
    public static final String FIELD_TYPE_DICE = "dice";
    public static final String FIELD_TYPE_CARD = "card";
    private static final String FIELD_TYPE_GATE = "gate";
    public static final String FIELD_TYPE_GATE_ACTION = "gate_action";
    public static final String FIELD_TYPE_BACK_BUTTON = "back";
    private static final String CONNECTION_TYPE_HOME = "home";
    private static final String CONNECTION_TYPE_VERTICAL = "vertical";
    private static final String CONNECTION_TYPE_HORIZONTAL = "horizontal";

    private SheepPlayingField() {
    }

    public static PlayingField getPlayingField() {
        return PlayingFieldManager.getInstance().getField(PLAYING_FIELD_NAME);
    }

    public static SingleField getField(String id) {
        return SheepPlayingField.getPlayingField().getField(id);
    }

    private static void sortFieldsById(ArrayList<SingleField> fields) {
        fields.sort(Comparator.comparingInt(field -> Integer.parseInt(field.getId())));
    }

    public static SingleField getGuardianHomeField() {
        return SheepPlayingField.getGuardianHomeField(SheepPlayingField.getPlayingField());
    }

    public static SingleField getGuardianHomeField(PlayingField playingField) {
        return playingField.getFirstFieldWithProperty(PROPERTY_TYPE, "home");
    }

    private static boolean isGuardianHomeField(PlayingField playingField, SingleField field) {
        return Objects.equals(field, SheepPlayingField.getGuardianHomeField(playingField));
    }

    private static Collection<SingleField> getBattlegroundGateFields(PlayingField playingField) {
        return playingField.getFieldsWithProperty(PROPERTY_TYPE, FIELD_TYPE_BATTLEGROUND_GATE);
    }

    public static boolean isBattlegroundGateField(String fieldId) {
        PlayingField playingField = SheepPlayingField.getPlayingField();
        return SheepPlayingField.getBattlegroundGateFields(playingField).contains(playingField.getField(fieldId));
    }

    private static Collection<SingleField> getBattlegroundFields() {
        PlayingField playingField = SheepPlayingField.getPlayingField();
        ArrayList<SingleField> fields = new ArrayList<SingleField>(playingField.getFieldsWithProperty(PROPERTY_TYPE, FIELD_TYPE_BATTLEGROUND));
        fields.addAll(SheepPlayingField.getBattlegroundGateFields(playingField));
        return Collections.unmodifiableCollection(fields);
    }

    private static boolean isBattlegroundField(SingleField field) {
        return SheepPlayingField.getBattlegroundFields().stream().anyMatch(f -> f.equals(field));
    }

    public static boolean isBattlegroundField(String fieldId) {
        return SheepPlayingField.isBattlegroundField(SheepPlayingField.getField(fieldId));
    }

    public static Collection<SingleField> getEmptyBattlegroundFields(SheepState gameState) {
        return SheepPlayingField.getBattlegroundFields().stream().filter(field -> gameState.isBattlegroundFieldEmpty(field.getId())).collect(Collectors.toList());
    }

    public static SingleField getRandomEmptyBattlegroundField(SheepState gameState) {
        return HGBaseTools.pickRandomElement(SheepPlayingField.getEmptyBattlegroundFields(gameState).toArray(new SingleField[0]));
    }

    public static Collection<SingleField> getShelterFields(PlayingField playingField) {
        ArrayList<SingleField> shelterFields = new ArrayList<SingleField>(playingField.getFieldsWithProperty(PROPERTY_TYPE, FIELD_TYPE_SHELTER));
        SheepPlayingField.sortFieldsById(shelterFields);
        return shelterFields;
    }

    public static int getCountShelterFields() {
        return SheepPlayingField.getShelterFields(SheepPlayingField.getPlayingField()).size();
    }

    private static Collection<SingleField> getPredatorGateFields(PlayingField playingField) {
        return playingField.getFieldsWithProperty(PROPERTY_TYPE, FIELD_TYPE_PREDATOR_GATE);
    }

    public static Collection<SingleField> getPredatorGateFields() {
        return SheepPlayingField.getPredatorGateFields(SheepPlayingField.getPlayingField());
    }

    public static boolean isPredatorGateField(String fieldId) {
        PlayingField playingField = SheepPlayingField.getPlayingField();
        return SheepPlayingField.getPredatorGateFields(playingField).contains(playingField.getField(fieldId));
    }

    public static SingleField getPredatorStartField() {
        return SheepPlayingField.getPlayingField().getFirstFieldWithProperty(PROPERTY_TYPE, FIELD_TYPE_PREDATOR_START);
    }

    private static Collection<SingleField> getPredatorWayFields(PlayingField playingField) {
        ArrayList<SingleField> fields = new ArrayList<SingleField>(playingField.getFieldsWithProperty(PROPERTY_TYPE, FIELD_TYPE_PREDATOR_WAY));
        fields.addAll(SheepPlayingField.getPredatorGateFields(playingField));
        fields.add(SheepPlayingField.getPredatorStartField());
        return Collections.unmodifiableCollection(fields);
    }

    public static boolean isPredatorWayField(String fieldId) {
        PlayingField playingField = SheepPlayingField.getPlayingField();
        return SheepPlayingField.getPredatorWayFields(playingField).contains(playingField.getField(fieldId));
    }

    public static SingleField getPredatorReserveField(PlayingField playingField) {
        return playingField.getFirstFieldWithProperty(PROPERTY_TYPE, FIELD_TYPE_PREDATOR_RESERVE);
    }

    public static Collection<SingleField> getDiceFields(PlayingField playingField) {
        ArrayList<SingleField> diceFields = new ArrayList<SingleField>(playingField.getFieldsWithProperty(PROPERTY_TYPE, FIELD_TYPE_DICE));
        SheepPlayingField.sortFieldsById(diceFields);
        return diceFields;
    }

    public static boolean isDiceField(PlayingField playingField, String fieldId) {
        return SheepPlayingField.getDiceFields(playingField).contains(playingField.getField(fieldId));
    }

    public static SingleField getDiceField(int index) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(PROPERTY_TYPE, FIELD_TYPE_DICE);
        properties.put(PROPERTY_ORDER, String.valueOf(index + 1));
        SingleField[] fields = SheepPlayingField.getPlayingField().getFieldsWithProperties(properties).toArray(new SingleField[0]);
        return fields.length > 0 ? fields[0] : null;
    }

    public static SingleField getFirstDiceField() {
        return SheepPlayingField.getDiceField(0);
    }

    public static int getDiceFieldOrder(String fieldId) {
        if (!HGBaseTools.hasContent(fieldId)) {
            return 0;
        }
        PlayingField playingField = SheepPlayingField.getPlayingField();
        SingleField diceField = playingField.getField(fieldId);
        return diceField != null ? Integer.parseInt(diceField.getProperty(PROPERTY_ORDER)) : 0;
    }

    public static SingleField getActionCardField(PlayingField playingField) {
        return playingField.getFirstFieldWithProperty(PROPERTY_TYPE, FIELD_TYPE_CARD);
    }

    public static boolean isActionCardField(PlayingField playingField, String fieldId) {
        SingleField actionCardField = SheepPlayingField.getActionCardField(playingField);
        return actionCardField != null && actionCardField.getId().equals(fieldId);
    }

    public static boolean isActionCardField(String fieldId) {
        return SheepPlayingField.isActionCardField(SheepPlayingField.getPlayingField(), fieldId);
    }

    public static SingleField getGateField(PlayingField playingField) {
        return playingField.getFirstFieldWithProperty(PROPERTY_TYPE, FIELD_TYPE_GATE);
    }

    public static SingleField getGateActionField(PlayingField playingField) {
        return playingField.getFirstFieldWithProperty(PROPERTY_TYPE, FIELD_TYPE_GATE_ACTION);
    }

    public static boolean isGateActionField(SingleField field) {
        return SheepPlayingField.getGateActionField(SheepPlayingField.getPlayingField()).equals(field);
    }

    public static Collection<SingleField> getReachableFields(SheepState gameState) {
        Collection<SingleField> reachableFields = SheepPlayerUtil.isCurrentPlayerPredator() ? SheepPlayingField.getPredatorReachableFields(gameState, gameState.getSelectedDiceValue()) : (gameState.isGuardianSelected() ? SheepPlayingField.getGuardianReachableFields(gameState, gameState.getSelectedDiceValue()) : SheepPlayingField.getPreyReachableFields(gameState, gameState.getSelectedFigureField(), gameState.getSelectedDiceValue()));
        return Collections.unmodifiableCollection(reachableFields);
    }

    private static Collection<SingleField> getReachableFields(PlayingField playingField, SingleField startPos, int steps, BiPredicate<SingleField, SingleField> condition) {
        return new ArrayList<SingleField>(playingField.getReachableFields(startPos, steps, SheepRules.isDiscardingExcessDicePointsAllowed(), condition));
    }

    public static Collection<SingleField> getGuardianReachableFields(SheepState gameState, int steps) {
        PlayingField playingField = SheepPlayingField.getPlayingField();
        return SheepPlayingField.getReachableFields(playingField, playingField.getField(gameState.getGuardianPosition()), steps, (origin, target) -> SheepPlayingField.mayGuardianUseConnection(playingField, gameState, origin, target));
    }

    public static Collection<SingleField> getPreyReachableFields(SheepState gameState, String sheepPosition, int steps) {
        PlayingField playingField = SheepPlayingField.getPlayingField();
        return SheepPlayingField.getReachableFields(playingField, playingField.getField(sheepPosition), steps, (origin, target) -> SheepPlayingField.mayPreyUseConnection(playingField, gameState, origin, target));
    }

    public static Collection<SingleField> getPredatorReachableFields(SheepState gameState, int steps) {
        PlayingField playingField = SheepPlayingField.getPlayingField();
        Collection<SingleField> reachableFields = SheepPlayingField.getReachableFields(playingField, playingField.getField(gameState.getPredatorPosition()), steps, (origin, target) -> SheepPlayingField.mayPredatorUseConnection(playingField, gameState, origin, target, true));
        reachableFields.add(playingField.getField(gameState.getPredatorPosition()));
        return reachableFields;
    }

    private static boolean mayGuardianUseConnection(PlayingField playingField, SheepState gameState, SingleField origin, SingleField target) {
        String type = playingField.getConnectionProperty(origin, target, PROPERTY_TYPE);
        if ("home".equals(type) && SheepPlayingField.isGuardianHomeField(playingField, target)) {
            return true;
        }
        if (!HGBaseTools.isOneOf(type, CONNECTION_TYPE_HORIZONTAL, CONNECTION_TYPE_VERTICAL, "home")) {
            return false;
        }
        if (gameState.isPredatorPosition(target.getId())) {
            return true;
        }
        return !gameState.isFieldOccupiedByFigure(target.getId());
    }

    private static boolean mayPreyUseConnection(PlayingField playingField, SheepState gameState, SingleField origin, SingleField target) {
        if (!HGBaseTools.isOneOf(playingField.getConnectionProperty(origin, target, PROPERTY_TYPE), CONNECTION_TYPE_HORIZONTAL, CONNECTION_TYPE_VERTICAL)) {
            return false;
        }
        return !gameState.isFieldOccupiedByFigure(target.getId());
    }

    public static boolean mayPredatorUseConnection(PlayingField playingField, SheepState gameState, SingleField origin, SingleField target, boolean checkGateState) {
        if ("home".equals(playingField.getConnectionProperty(origin, target, PROPERTY_TYPE))) {
            return false;
        }
        if (gameState.isBattlegroundPrey(origin.getId()) || gameState.isGuardianPosition(origin.getId())) {
            return false;
        }
        return !checkGateState || !gameState.isGateClosed() || !gameState.isPredatorOnPredatorWay() || !SheepPlayingField.isBattlegroundField(target);
    }
}

