/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.game;

import com.tjger.goldensheep.desktop.game.HiddenAction;
import com.tjger.goldensheep.desktop.game.SheepPlayerUtil;
import com.tjger.goldensheep.desktop.game.SheepPlayingField;
import com.tjger.goldensheep.desktop.game.SheepState;
import com.tjger.goldensheep.desktop.game.move.ActivateGuardian;
import com.tjger.goldensheep.desktop.game.move.CloseGate;
import com.tjger.goldensheep.desktop.game.move.MoveGuardian;
import com.tjger.goldensheep.desktop.game.move.MovePredator;
import com.tjger.goldensheep.desktop.game.move.MovePrey;
import com.tjger.goldensheep.desktop.game.move.OpenGate;
import com.tjger.goldensheep.desktop.game.move.PreyEnterShelter;
import com.tjger.goldensheep.desktop.game.move.PreyLeaveShelter;
import com.tjger.goldensheep.desktop.game.move.RelocatePrey;
import com.tjger.goldensheep.desktop.game.move.RevealActionCard;
import hgb.lib.HGBaseTools;
import hgb.lib.TriFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.MoveInformation;
import tjger.game.SimpleGameRules;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.SingleField;
import tjger.lib.DiceUtil;

public class SheepRules
extends SimpleGameRules {
    public boolean hasGuardianWon(SheepState gameState) {
        return gameState.areAllPredatorCaught();
    }

    public boolean hasPredatorWon(SheepState gameState) {
        return gameState.isSpecialPreyCaught();
    }

    @Override
    public boolean isRoundFinished(GameState gameState) {
        return this.hasGuardianWon((SheepState)gameState) || this.hasPredatorWon((SheepState)gameState);
    }

    @Override
    public boolean isGameFinished(GameState gameState) {
        return this.isRoundFinished(gameState);
    }

    @Override
    public void doScoring(GamePlayer[] playerToScore, GameState gameState) {
        Predicate<GamePlayer> playerFilter = null;
        if (this.hasGuardianWon((SheepState)gameState)) {
            playerFilter = SheepPlayerUtil::isPlayerGuardian;
        } else if (this.hasPredatorWon((SheepState)gameState)) {
            playerFilter = SheepPlayerUtil::isPlayerPredator;
        } else {
            return;
        }
        Stream.of(playerToScore).filter(playerFilter).forEach(player -> player.setScore(1, 4));
    }

    @Override
    public boolean isValidMove(MoveInformation move, GameState gameState) {
        if (move instanceof MovePredator) {
            return this.isValidMovePredatorMove((MovePredator)move);
        }
        if (move instanceof MoveGuardian) {
            return this.isValidMoveGuardianMove((MoveGuardian)move, (SheepState)gameState);
        }
        if (move instanceof MovePrey) {
            return this.isValidMovePreyMove((MovePrey)move, (SheepState)gameState);
        }
        if (move instanceof RevealActionCard) {
            return this.isValidRevealActionCardMove((RevealActionCard)move, (SheepState)gameState);
        }
        if (move instanceof PreyEnterShelter) {
            return this.isValidPreyEnterShelterMove((PreyEnterShelter)move, (SheepState)gameState);
        }
        if (move instanceof PreyLeaveShelter) {
            return this.isValidPreyLeaveShelterMove((PreyLeaveShelter)move, (SheepState)gameState);
        }
        if (move instanceof RelocatePrey) {
            return this.isValidRelocatePreyMove((RelocatePrey)move, (SheepState)gameState);
        }
        if (move instanceof ActivateGuardian) {
            return this.isValidActivateGuardianMove((ActivateGuardian)move, (SheepState)gameState);
        }
        if (move instanceof OpenGate) {
            return this.isValidOpenGateMove((OpenGate)move, (SheepState)gameState);
        }
        if (move instanceof CloseGate) {
            return this.isValidCloseGateMove((CloseGate)move, (SheepState)gameState);
        }
        return false;
    }

    private boolean isValidMovePredatorMove(MovePredator move) {
        return move.getTo() != null;
    }

    private boolean isValidMoveGuardianMove(MoveGuardian move, SheepState gameState) {
        return move.getTo() != null && gameState.isGuardianActive();
    }

    private boolean isValidMovePreyMove(MovePrey move, SheepState gameState) {
        SingleField from = move.getFrom();
        return from != null && gameState.isBattlegroundPrey(from.getId()) && move.getTo() != null;
    }

    private boolean isValidRevealActionCardMove(RevealActionCard move, SheepState gameState) {
        String fieldId = move.getFieldId();
        return fieldId != null && gameState.isBattlegroundPrey(fieldId) && gameState.isHiddenActionLocated(fieldId) && gameState.isDiceIndexValid(move.getDiceIndex());
    }

    private boolean isValidPreyEnterShelterMove(PreyEnterShelter move, SheepState gameState) {
        SingleField from = move.getFrom();
        return from != null && gameState.isBattlegroundNormalPrey(from.getId()) && gameState.isShelterEmptySpaceAvailable();
    }

    private boolean isValidPreyLeaveShelterMove(PreyLeaveShelter move, SheepState gameState) {
        SingleField to = move.getTo();
        return gameState.isShelterPreyAvailable() && to != null && gameState.isBattlegroundFieldEmpty(to.getId());
    }

    private boolean isValidRelocatePreyMove(RelocatePrey move, SheepState gameState) {
        SingleField from = move.getFrom();
        SingleField to = move.getTo();
        return from != null && gameState.isBattlegroundPrey(from.getId()) && to != null && gameState.isBattlegroundFieldEmpty(to.getId());
    }

    private boolean isValidActivateGuardianMove(ActivateGuardian move, SheepState gameState) {
        return !gameState.isGuardianActive();
    }

    private boolean isValidOpenGateMove(OpenGate move, SheepState gameState) {
        return gameState.isDiceIndexValid(move.getDiceIndex()) && gameState.isOpenGateAllowed(move.getOpenDiceValue());
    }

    private boolean isValidCloseGateMove(CloseGate move, SheepState gameState) {
        return gameState.isDiceIndexValid(move.getDiceIndex()) && gameState.isCloseGateAllowed();
    }

    public List<MoveInformation> getPossibleMoves(GamePlayer player, SheepState gameState) {
        ArrayList<MoveInformation> moves = new ArrayList<MoveInformation>();
        PlayingField playingField = SheepPlayingField.getPlayingField();
        if (SheepPlayerUtil.isPlayerPredator(player)) {
            moves.addAll(this.generateMovePredatorMoves(playingField, gameState));
            moves.addAll(this.generateOpenGateMoves(gameState));
        } else {
            moves.addAll(this.generateMoveGuardianMoves(playingField, gameState));
            moves.addAll(this.generateMovePreyMoves(playingField, gameState));
            moves.addAll(this.generateRevealActionCardMoves(gameState));
            moves.addAll(this.generateUseActionCardMoves(gameState));
            moves.addAll(this.generateCloseGateMoves(gameState));
        }
        return moves.stream().distinct().collect(Collectors.toList());
    }

    private List<MoveInformation> generateFigureMoves(PlayingField playingField, SheepState gameState, String figureFieldId, Function<Integer, Collection<SingleField>> reachableFields, TriFunction<SingleField, SingleField, Integer, MoveInformation> moveCreator) {
        ArrayList<MoveInformation> moves = new ArrayList<MoveInformation>();
        if (figureFieldId == null) {
            return moves;
        }
        int diceIndex = 0;
        while (diceIndex < gameState.getCountRolledDice()) {
            int finalDiceIndex = diceIndex++;
            moves.addAll(reachableFields.apply(gameState.getDiceValue(finalDiceIndex)).stream().map(to -> (MoveInformation)moveCreator.apply(playingField.getField(figureFieldId), (SingleField)to, finalDiceIndex)).filter(move -> this.isValidMove((MoveInformation)move, gameState)).collect(Collectors.toList()));
        }
        return moves;
    }

    private List<MoveInformation> generateMovePredatorMoves(PlayingField playingField, SheepState gameState) {
        return this.generateFigureMoves(playingField, gameState, gameState.getPredatorPosition(), steps -> SheepPlayingField.getPredatorReachableFields(gameState, steps), (from, to, diceIndex) -> new MovePredator((SingleField)to));
    }

    private List<MoveInformation> generateMoveGuardianMoves(PlayingField playingField, SheepState gameState) {
        return this.generateFigureMoves(playingField, gameState, gameState.getGuardianPosition(), steps -> SheepPlayingField.getGuardianReachableFields(gameState, steps), (from, to, diceIndex) -> new MoveGuardian((SingleField)to, (int)diceIndex));
    }

    private List<MoveInformation> generateMovePreyMoves(PlayingField playingField, SheepState gameState) {
        ArrayList<MoveInformation> moves = new ArrayList<MoveInformation>();
        moves.addAll(this.generateMoveSpecialPreyMoves(playingField, gameState));
        moves.addAll(this.generateMoveNormalPreyMoves(playingField, gameState));
        return moves;
    }

    private List<MoveInformation> generateMoveSpecialPreyMoves(PlayingField playingField, SheepState gameState) {
        String preyPosition = gameState.getBattlegroundSpecialPreyPosition();
        return this.generateFigureMoves(playingField, gameState, preyPosition, steps -> SheepPlayingField.getPreyReachableFields(gameState, preyPosition, steps), MovePrey::new);
    }

    private List<MoveInformation> generateMoveNormalPreyMoves(PlayingField playingField, SheepState gameState) {
        ArrayList<MoveInformation> moves = new ArrayList<MoveInformation>();
        gameState.getBattlegroundNormalPrey().forEach(position -> {
            boolean bl = moves.addAll(this.generateFigureMoves(playingField, gameState, (String)position, steps -> SheepPlayingField.getPreyReachableFields(gameState, position, steps), MovePrey::new));
        });
        return moves;
    }

    private List<MoveInformation> generateRevealActionCardMoves(SheepState gameState) {
        ArrayList<MoveInformation> moves = new ArrayList<MoveInformation>();
        moves.addAll(this.generateSpecialPreyRevealActionCardMoves(gameState));
        moves.addAll(this.generateNormalPreyRevealActionCardMoves(gameState));
        return moves;
    }

    private List<MoveInformation> generateSpecialPreyRevealActionCardMoves(SheepState gameState) {
        ArrayList<MoveInformation> moves = new ArrayList<MoveInformation>();
        String specialPreyPosition = gameState.getBattlegroundSpecialPreyPosition();
        if (specialPreyPosition == null) {
            return moves;
        }
        int diceIndex = 0;
        while (diceIndex < gameState.getCountRolledDice()) {
            RevealActionCard move = new RevealActionCard(specialPreyPosition, diceIndex);
            if (this.isValidRevealActionCardMove(move, gameState)) {
                moves.add(move);
            }
            ++diceIndex;
        }
        return moves;
    }

    private List<MoveInformation> generateNormalPreyRevealActionCardMoves(SheepState gameState) {
        ArrayList<MoveInformation> moves = new ArrayList<MoveInformation>();
        int diceIndex = 0;
        while (diceIndex < gameState.getCountRolledDice()) {
            int finalDiceIndex = diceIndex++;
            moves.addAll(gameState.getBattlegroundNormalPrey().stream().map(position -> new RevealActionCard((String)position, finalDiceIndex)).filter(move -> this.isValidRevealActionCardMove((RevealActionCard)move, gameState)).collect(Collectors.toList()));
        }
        return moves;
    }

    private List<MoveInformation> generateUseActionCardMoves(SheepState gameState) {
        ArrayList<MoveInformation> moves = new ArrayList<MoveInformation>();
        if (!gameState.isActionCardRevealed()) {
            return moves;
        }
        PlayingField playingField = SheepPlayingField.getPlayingField();
        switch (gameState.getRevealedAction()) {
            case ACTIVATE_GUARDIAN: {
                ActivateGuardian activateGuardianMove = new ActivateGuardian();
                if (!this.isValidMove(activateGuardianMove, gameState)) break;
                moves.add(activateGuardianMove);
                break;
            }
            case ONE_PREY_ENTER_SHELTER: 
            case TWO_PREY_ENTER_SHELTER: {
                moves.addAll(gameState.getBattlegroundNormalPrey().stream().map(playingField::getField).map(PreyEnterShelter::new).filter(move -> this.isValidPreyEnterShelterMove((PreyEnterShelter)move, gameState)).collect(Collectors.toList()));
                break;
            }
            case ONE_PREY_LEAVE_SHELTER: 
            case TWO_PREY_LEAVE_SHELTER: {
                moves.addAll(SheepPlayingField.getEmptyBattlegroundFields(gameState).stream().map(PreyLeaveShelter::new).filter(move -> this.isValidPreyLeaveShelterMove((PreyLeaveShelter)move, gameState)).collect(Collectors.toList()));
                break;
            }
            case RELOCATE_PREY: {
                Collection<SingleField> emptyBattlegroundFields = SheepPlayingField.getEmptyBattlegroundFields(gameState);
                moves.addAll(this.generateRelocateSpecialPreyMoves(gameState, playingField, emptyBattlegroundFields));
                moves.addAll(this.generateRelocateNormalPreyMoves(gameState, playingField, emptyBattlegroundFields));
                break;
            }
        }
        return moves;
    }

    private List<MoveInformation> generateRelocateSpecialPreyMoves(SheepState gameState, PlayingField playingField, Collection<SingleField> emptyBattlegroundFields) {
        SingleField positionSpecialPrey = playingField.getField(gameState.getBattlegroundSpecialPreyPosition());
        return emptyBattlegroundFields.stream().map(to -> new RelocatePrey(positionSpecialPrey, (SingleField)to)).filter(move -> this.isValidRelocatePreyMove((RelocatePrey)move, gameState)).collect(Collectors.toList());
    }

    private List<MoveInformation> generateRelocateNormalPreyMoves(SheepState gameState, PlayingField playingField, Collection<SingleField> emptyBattlegroundFields) {
        return gameState.getBattlegroundNormalPrey().stream().map(playingField::getField).flatMap(from -> emptyBattlegroundFields.stream().map(to -> new RelocatePrey((SingleField)from, (SingleField)to))).filter(move -> this.isValidRelocatePreyMove((RelocatePrey)move, gameState)).collect(Collectors.toList());
    }

    private List<MoveInformation> generateOpenGateMoves(SheepState gameState) {
        ArrayList<MoveInformation> moves = new ArrayList<MoveInformation>();
        int diceIndex = 0;
        while (diceIndex < gameState.getCountRolledDice()) {
            OpenGate move = new OpenGate(diceIndex, gameState.getSelectedDiceValue(), DiceUtil.throwDice());
            if (this.isValidOpenGateMove(move, gameState)) {
                moves.add(move);
            }
            ++diceIndex;
        }
        return moves;
    }

    private List<MoveInformation> generateCloseGateMoves(SheepState gameState) {
        ArrayList<MoveInformation> moves = new ArrayList<MoveInformation>();
        int diceIndex = 0;
        while (diceIndex < gameState.getCountRolledDice()) {
            CloseGate move = new CloseGate(diceIndex);
            if (this.isValidCloseGateMove(move, gameState)) {
                moves.add(move);
            }
            ++diceIndex;
        }
        return moves;
    }

    public static int getCountInitialBattlegroundNormalPrey() {
        return 9;
    }

    public static int getCountInitialShelterPrey() {
        return 10;
    }

    public static int getCountInitialPredatorReserve() {
        return 2;
    }

    public static int getCountInitialHiddenAction(HiddenAction action) {
        return 5;
    }

    public static int getTotalCountInitialHiddenAction() {
        return 25;
    }

    public static int getCountDiceToRoll(SheepState gameState, GamePlayer player) {
        if (SheepPlayerUtil.isPlayerPredator(player)) {
            return 1;
        }
        return gameState.isGuardianActive() ? 2 : 1;
    }

    public static boolean isDiscardingExcessDicePointsAllowed() {
        return true;
    }

    public static boolean isOpenGateDiceValue(int diceValue) {
        return HGBaseTools.isEven(diceValue);
    }
}

