/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.game;

import com.tjger.goldensheep.desktop.game.HiddenAction;
import com.tjger.goldensheep.desktop.game.SheepPlayingField;
import com.tjger.goldensheep.desktop.game.SheepRules;
import com.tjger.goldensheep.desktop.game.move.ActivateGuardian;
import com.tjger.goldensheep.desktop.game.move.CloseGate;
import com.tjger.goldensheep.desktop.game.move.MoveGuardian;
import com.tjger.goldensheep.desktop.game.move.MovePredator;
import com.tjger.goldensheep.desktop.game.move.MovePrey;
import com.tjger.goldensheep.desktop.game.move.OpenGate;
import com.tjger.goldensheep.desktop.game.move.PreyEnterShelter;
import com.tjger.goldensheep.desktop.game.move.PreyLeaveShelter;
import com.tjger.goldensheep.desktop.game.move.RelocatePrey;
import com.tjger.goldensheep.desktop.game.move.RevealActionCard;
import hgb.lib.HGBaseTools;
import hgb.lib.xml.HGBaseXMLTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.MoveInformation;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.game.completed.SoundUtil;
import tjger.game.completed.playingfield.SingleField;
import tjger.lib.DiceUtil;
import tjger.lib.NetworkUtil;
import tjger.lib.PlayerUtil;

public class SheepState
implements GameState {
    private static final String SOUNDSET_MOVE_PREY = "moveprey";
    private static final String SOUND_MOVE_GUARDIAN = "moveguardian";
    private static final String SOUNDSET_MOVE_PREDATOR = "movepredator";
    private static final String SOUND_REVEAL_ACTION_CARD = "revealactioncard";
    private static final String SOUND_ACTIVATE_GUARDIAN = "activateguardian";
    private static final String SOUND_OPEN_GATE = "opengate";
    private static final String SOUND_CLOSE_GATE = "closegate";
    private static final String SOUNDSET_ROLL_DICE = "rolldice";
    private Collection<String> battlegroundNormalPrey;
    private String positionSpecialPrey;
    private int countShelterPrey;
    private String positionGuardian;
    private boolean guardianActive;
    private String positionPredator;
    private int countPredatorReserve;
    private Map<String, HiddenAction> positionHiddenAction;
    private List<Integer> rolledDice;
    private String selectedDiceField;
    private Collection<SingleField> reachableFields;
    private String selectedFigureField;
    private HiddenAction revealedAction;
    private int availableActivitiesCounter;
    private boolean gateClosed;

    public SheepState() {
        this.initMembers();
    }

    private void initMembers() {
        this.battlegroundNormalPrey = new ArrayList<String>();
        this.positionSpecialPrey = null;
        this.countShelterPrey = 0;
        this.positionGuardian = null;
        this.guardianActive = true;
        this.positionPredator = null;
        this.countPredatorReserve = 0;
        this.positionHiddenAction = new HashMap<String, HiddenAction>();
        this.rolledDice = new ArrayList<Integer>();
        this.selectedDiceField = null;
        this.reachableFields = new ArrayList<SingleField>();
        this.selectedFigureField = null;
        this.revealedAction = null;
        this.availableActivitiesCounter = 0;
        this.gateClosed = true;
    }

    public Collection<String> getBattlegroundNormalPrey() {
        return Collections.unmodifiableCollection(this.battlegroundNormalPrey);
    }

    private int getCountBattlegroundNormalPrey() {
        return this.battlegroundNormalPrey != null ? this.battlegroundNormalPrey.size() : 0;
    }

    private void placeBattlegroundNormalPrey(String id) {
        this.battlegroundNormalPrey.add(id);
    }

    private void removeBattlegroundNormalPrey(String id) {
        this.battlegroundNormalPrey.remove(id);
    }

    private void moveBattlegroundNormalPrey(String from, String to) {
        this.removeBattlegroundNormalPrey(from);
        this.placeBattlegroundNormalPrey(to);
    }

    public String getBattlegroundSpecialPreyPosition() {
        return this.positionSpecialPrey;
    }

    private void placeBattlegroundSpecialPrey(String id) {
        this.positionSpecialPrey = "^".equals(id) ? null : id;
    }

    private void removeBattlegroundSpecialPrey() {
        this.positionSpecialPrey = null;
    }

    public boolean isSpecialPreyCaught() {
        return !HGBaseTools.hasContent(this.positionSpecialPrey);
    }

    private boolean isSpecialPreyAtField(String id) {
        return id != null && id.equals(this.getBattlegroundSpecialPreyPosition());
    }

    private void removeBattlegroundPrey(String fieldId) {
        if (this.isSpecialPreyAtField(fieldId)) {
            this.removeBattlegroundSpecialPrey();
        } else {
            this.removeBattlegroundNormalPrey(fieldId);
        }
    }

    public Collection<String> getBattlegroundPrey() {
        ArrayList<String> preyFields = new ArrayList<String>(this.getBattlegroundNormalPrey());
        preyFields.add(this.getBattlegroundSpecialPreyPosition());
        return Collections.unmodifiableCollection(preyFields);
    }

    public List<String> getBattlegroundPreyOnHiddenAction() {
        if (this.positionHiddenAction == null || this.positionHiddenAction.isEmpty()) {
            return List.of();
        }
        return this.getBattlegroundPrey().stream().filter(this.positionHiddenAction::containsKey).collect(Collectors.toList());
    }

    private void addPreyToShelter() {
        ++this.countShelterPrey;
    }

    private void removePreyFromShelter() {
        --this.countShelterPrey;
    }

    public int getCountShelterPrey() {
        return this.countShelterPrey;
    }

    public boolean isShelterPreyAvailable() {
        return this.getCountShelterPrey() > 0;
    }

    private int getCountShelterEmptySpace() {
        return SheepPlayingField.getCountShelterFields() - this.getCountShelterPrey();
    }

    public boolean isShelterEmptySpaceAvailable() {
        return this.getCountShelterEmptySpace() > 0;
    }

    public String getGuardianPosition() {
        return this.positionGuardian;
    }

    private void placeGuardian(String id) {
        this.positionGuardian = "^".equals(id) ? null : id;
    }

    private void setGuardianActive(boolean active) {
        this.guardianActive = active;
    }

    private void activateGuardian() {
        this.setGuardianActive(true);
    }

    private void deactivateGuardian() {
        this.setGuardianActive(false);
        this.positionGuardian = SheepPlayingField.getGuardianHomeField().getId();
    }

    public boolean isGuardianActive() {
        return this.guardianActive;
    }

    public boolean isGuardianPosition(String fieldId) {
        return HGBaseTools.hasContent(fieldId) && fieldId.equals(this.positionGuardian);
    }

    private boolean isGuardianInGatePosition() {
        return SheepPlayingField.isBattlegroundGateField(this.getGuardianPosition());
    }

    public String getPredatorPosition() {
        return this.positionPredator;
    }

    private void placePredator(String id) {
        this.positionPredator = "^".equals(id) ? null : id;
    }

    private void removePredator() {
        this.placePredator(null);
    }

    public boolean isPredatorPosition(String fieldId) {
        return HGBaseTools.hasContent(fieldId) && fieldId.equals(this.positionPredator);
    }

    private boolean isPredatorOnPlayingField() {
        return HGBaseTools.hasContent(this.positionPredator);
    }

    private boolean isPredatorInGatePosition() {
        return SheepPlayingField.isPredatorGateField(this.getPredatorPosition());
    }

    public boolean isPredatorOnPredatorWay() {
        return SheepPlayingField.isPredatorWayField(this.getPredatorPosition());
    }

    private void setCountPredatorReserve(int countPredatorReserve) {
        this.countPredatorReserve = countPredatorReserve;
    }

    private void decreaseCountPredatorReserve() {
        if (this.countPredatorReserve > 0) {
            --this.countPredatorReserve;
        }
    }

    private boolean isReservePredatorAvailable() {
        return this.countPredatorReserve > 0;
    }

    public int getCountPredatorReserve() {
        return this.countPredatorReserve;
    }

    public boolean areAllPredatorCaught() {
        return !this.isReservePredatorAvailable() && !this.isPredatorOnPlayingField();
    }

    public Set<String> getHiddenActionPositions() {
        return this.positionHiddenAction != null ? this.positionHiddenAction.keySet() : Collections.emptySet();
    }

    public HiddenAction getHiddenAction(String fieldId) {
        return this.positionHiddenAction != null ? this.positionHiddenAction.get(fieldId) : null;
    }

    public boolean isHiddenActionLocated(String fieldId) {
        return this.positionHiddenAction != null && this.positionHiddenAction.containsKey(fieldId);
    }

    private void placeHiddenAction(String fieldId, HiddenAction action) {
        this.positionHiddenAction.put(fieldId, action);
    }

    private void removeHiddenAction(String fieldId) {
        this.positionHiddenAction.remove(fieldId);
    }

    private boolean isPreyOnHiddenAction(String fieldId) {
        return this.getHiddenActionPositions().contains(fieldId) && this.getBattlegroundPrey().contains(fieldId);
    }

    private boolean isSelectedPreyOnHiddenAction() {
        return this.isPreyOnHiddenAction(this.getSelectedFigureField());
    }

    public boolean isActionCardRevealable() {
        return this.isDiceSelected() && this.isSelectedPreyOnHiddenAction();
    }

    public Collection<Integer> getRolledDice() {
        return this.rolledDice;
    }

    public void setRolledDice(List<Integer> rolledDice) {
        this.rolledDice = rolledDice;
    }

    private boolean isRolledDiceAvailable() {
        return this.rolledDice != null && !this.rolledDice.isEmpty();
    }

    public int getCountRolledDice() {
        return this.rolledDice != null ? this.rolledDice.size() : 0;
    }

    private void addRolledDice(int value) {
        this.rolledDice.add(value);
    }

    private void removeRolledDice(int index) {
        this.rolledDice.remove(index);
    }

    public boolean isDiceSelected() {
        return HGBaseTools.hasContent(this.selectedDiceField);
    }

    public boolean isSelectedDiceField(String fieldId) {
        return fieldId != null && fieldId.equals(this.selectedDiceField);
    }

    public boolean isDiceIndexValid(int index) {
        return this.rolledDice != null && index >= 0 && index < this.rolledDice.size();
    }

    public int getDiceValue(int index) {
        return this.isDiceIndexValid(index) ? this.rolledDice.get(index) : 0;
    }

    public int getSelectedDiceIndex() {
        return SheepPlayingField.getDiceFieldOrder(this.selectedDiceField) - 1;
    }

    public int getSelectedDiceValue() {
        return this.getDiceValue(this.getSelectedDiceIndex());
    }

    public void setSelectedDiceField(String fieldId) {
        this.selectedDiceField = fieldId != null && fieldId.equals(this.selectedDiceField) ? null : fieldId;
        this.setReachableFields(SheepPlayingField.getReachableFields(this));
    }

    private void setSelectedDiceField(SingleField field) {
        this.setSelectedDiceField(field != null ? field.getId() : null);
    }

    public void setSelectedDiceField(int diceIndex) {
        this.setSelectedDiceField(SheepPlayingField.getDiceField(diceIndex));
    }

    private void preSelectDice() {
        if (this.rolledDice != null && this.rolledDice.size() == 1) {
            SingleField field = SheepPlayingField.getFirstDiceField();
            this.setSelectedDiceField(field != null ? field.getId() : null);
        }
    }

    private void setReachableFields(Collection<SingleField> reachableFields) {
        this.reachableFields = reachableFields;
    }

    public Collection<SingleField> getReachableFields() {
        return this.reachableFields;
    }

    public boolean isFieldReachable(SingleField field) {
        return this.reachableFields != null && this.reachableFields.contains(field);
    }

    public String getSelectedFigureField() {
        return this.selectedFigureField;
    }

    public void setSelectedFigureField(String fieldId) {
        this.selectedFigureField = this.isSelectedFigureField(fieldId) ? null : fieldId;
        this.setReachableFields(SheepPlayingField.getReachableFields(this));
    }

    public void setGuardianSelected() {
        this.setSelectedFigureField(this.getGuardianPosition());
    }

    public boolean isSelectedFigureField(String fieldId) {
        return fieldId != null && fieldId.equals(this.selectedFigureField);
    }

    public boolean isFigureSelected() {
        return HGBaseTools.hasContent(this.selectedFigureField);
    }

    public boolean isGuardianSelected() {
        return this.selectedFigureField != null && this.selectedFigureField.equals(this.positionGuardian);
    }

    public boolean isBattlegroundFieldEmpty(String fieldId) {
        if (!SheepPlayingField.isBattlegroundField(fieldId)) {
            return false;
        }
        if (this.isFieldOccupiedByFigure(fieldId)) {
            return false;
        }
        return this.positionHiddenAction == null || !this.positionHiddenAction.containsKey(fieldId);
    }

    public boolean isFieldOccupiedByFigure(String fieldId) {
        return this.isBattlegroundPrey(fieldId) || HGBaseTools.isOneOf(fieldId, this.positionGuardian, this.positionPredator);
    }

    public boolean isBattlegroundNormalPrey(String fieldId) {
        return this.battlegroundNormalPrey != null && this.battlegroundNormalPrey.contains(fieldId);
    }

    public boolean isBattlegroundPrey(String fieldId) {
        return this.isBattlegroundNormalPrey(fieldId) || this.isSpecialPreyAtField(fieldId);
    }

    public boolean isSelectableFigureGuardian(String fieldId) {
        return this.isBattlegroundPrey(fieldId) || this.isGuardianPosition(fieldId) && this.isGuardianActive();
    }

    private int getActionActivitiesCounter(HiddenAction action) {
        if (action == null) {
            return 0;
        }
        int activitiesCounter = action.getActivitiesCounter();
        switch (action) {
            case ONE_PREY_ENTER_SHELTER: 
            case TWO_PREY_ENTER_SHELTER: {
                return Math.min(activitiesCounter, Math.min(this.getCountBattlegroundNormalPrey(), this.getCountShelterEmptySpace()));
            }
            case ONE_PREY_LEAVE_SHELTER: 
            case TWO_PREY_LEAVE_SHELTER: {
                return Math.min(activitiesCounter, this.getCountShelterPrey());
            }
            case RELOCATE_PREY: {
                return activitiesCounter;
            }
            case ACTIVATE_GUARDIAN: {
                return this.isGuardianActive() ? 0 : activitiesCounter;
            }
        }
        return 0;
    }

    private void setRevealedAction(HiddenAction revealedAction) {
        int counter = this.getActionActivitiesCounter(revealedAction);
        this.setAvailableActivitiesCounter(counter);
        this.revealedAction = counter > 0 ? revealedAction : null;
    }

    public boolean isActionCardRevealed() {
        return this.revealedAction != null;
    }

    public HiddenAction getRevealedAction() {
        return this.revealedAction;
    }

    public boolean isActionCardActivityField(String fieldId) {
        if (this.revealedAction == null) {
            return false;
        }
        switch (this.revealedAction) {
            case ONE_PREY_ENTER_SHELTER: 
            case TWO_PREY_ENTER_SHELTER: {
                return this.isBattlegroundNormalPrey(fieldId);
            }
            case ONE_PREY_LEAVE_SHELTER: 
            case TWO_PREY_LEAVE_SHELTER: {
                return this.isBattlegroundFieldEmpty(fieldId);
            }
            case RELOCATE_PREY: {
                return this.isFigureSelected() ? this.isBattlegroundFieldEmpty(fieldId) : this.isBattlegroundPrey(fieldId);
            }
            case ACTIVATE_GUARDIAN: {
                return SheepPlayingField.isActionCardField(fieldId);
            }
        }
        return false;
    }

    private void setAvailableActivitiesCounter(int availableActivitiesCounter) {
        this.availableActivitiesCounter = availableActivitiesCounter;
    }

    private void decreaseAvailableActivitiesCounter() {
        if (this.availableActivitiesCounter > 0) {
            --this.availableActivitiesCounter;
        }
        if (this.availableActivitiesCounter == 0) {
            this.setRevealedAction(null);
        }
    }

    private boolean areActivitiesLeft() {
        return this.availableActivitiesCounter > 0;
    }

    private void setGateState(boolean closed) {
        this.gateClosed = closed;
    }

    private void openGate() {
        this.setGateState(false);
    }

    private void closeGate() {
        this.setGateState(true);
    }

    public boolean isGateClosed() {
        return this.gateClosed;
    }

    public boolean isCloseGateAllowed() {
        return !this.isGateClosed() && this.isDiceSelected() && this.isGuardianInGatePosition() && this.isGuardianSelected() && this.isPredatorOnPredatorWay();
    }

    public boolean isOpenGateAllowed(int diceValue) {
        return this.isGateClosed() && SheepRules.isOpenGateDiceValue(diceValue) && this.isPredatorInGatePosition();
    }

    public boolean isOpenGateAllowed() {
        return this.isOpenGateAllowed(this.getSelectedDiceValue());
    }

    private boolean isPlayerMoveCompletedIntern(MoveInformation move) {
        SheepRules rules = (SheepRules)GameManager.getInstance().getGameRules();
        if (rules.hasGuardianWon(this) || rules.hasPredatorWon(this)) {
            return true;
        }
        if (this.isRolledDiceAvailable()) {
            return false;
        }
        return !this.areActivitiesLeft();
    }

    public static boolean isPlayerMoveCompleted(MoveInformation move) {
        return ((SheepState)GameManager.getInstance().getGameState()).isPlayerMoveCompletedIntern(move);
    }

    @Override
    public void resetGame(GameEngine engine) {
        this.initHiddenActions();
        this.initPrey();
        this.initGuardian();
        this.initPredator();
        this.rolledDice = null;
        this.setSelectedDiceField((String)null);
        this.setSelectedFigureField(null);
        this.setReachableFields(null);
        this.setRevealedAction(null);
        this.closeGate();
    }

    private List<HiddenAction> createHiddenActionStack() {
        ArrayList<HiddenAction> stack = new ArrayList<HiddenAction>();
        Stream.of(HiddenAction.values()).forEach(action -> {
            boolean bl = stack.addAll(Collections.nCopies(SheepRules.getCountInitialHiddenAction(action), action));
        });
        return stack;
    }

    private void initHiddenActions() {
        this.positionHiddenAction = new HashMap<String, HiddenAction>();
        List<HiddenAction> actionStack = this.createHiddenActionStack();
        Collection<SingleField> battlegroundFields = SheepPlayingField.getEmptyBattlegroundFields(this);
        int count = SheepRules.getTotalCountInitialHiddenAction();
        int i = 0;
        while (i < count && !battlegroundFields.isEmpty()) {
            SingleField field = HGBaseTools.pickRandomElement(battlegroundFields.toArray(new SingleField[0]));
            battlegroundFields.remove(field);
            HiddenAction action = HGBaseTools.pickRandomElement(actionStack, true);
            this.placeHiddenAction(field.getId(), action);
            ++i;
        }
    }

    private void initPrey() {
        this.placeInitialBattlegroundPrey();
        this.initShelterPrey();
    }

    private void placeInitialBattlegroundPrey() {
        this.placeInitialBattlegroundSpecialPrey();
        this.placeInitialBattlegroundNormalPrey();
    }

    private void placeInitialBattlegroundNormalPrey() {
        this.battlegroundNormalPrey = new ArrayList<String>();
        Collection<SingleField> battlegroundFields = SheepPlayingField.getEmptyBattlegroundFields(this);
        int countBattlegroundPrey = SheepRules.getCountInitialBattlegroundNormalPrey();
        int preyIndex = 0;
        while (preyIndex < countBattlegroundPrey && !battlegroundFields.isEmpty()) {
            SingleField field = HGBaseTools.pickRandomElement(battlegroundFields.toArray(new SingleField[0]));
            battlegroundFields.remove(field);
            this.placeBattlegroundNormalPrey(field.getId());
            ++preyIndex;
        }
    }

    private void placeInitialBattlegroundSpecialPrey() {
        SingleField field = SheepPlayingField.getRandomEmptyBattlegroundField(this);
        if (field != null) {
            this.placeBattlegroundSpecialPrey(field.getId());
        }
    }

    private void initShelterPrey() {
        this.countShelterPrey = SheepRules.getCountInitialShelterPrey();
    }

    private void initGuardian() {
        SingleField field = SheepPlayingField.getRandomEmptyBattlegroundField(this);
        if (field != null) {
            this.placeGuardian(field.getId());
            this.activateGuardian();
        }
    }

    private void initPredator() {
        this.placePredatorOnStartField();
        this.setCountPredatorReserve(SheepRules.getCountInitialPredatorReserve());
    }

    private void placePredatorOnStartField() {
        this.placePredator(SheepPlayingField.getPredatorStartField().getId());
    }

    @Override
    public void resetRound(GameEngine engine) {
    }

    @Override
    public void resetTurn(GameEngine engine) {
    }

    @Override
    public void resetMove(GameEngine engine, boolean continued) {
        if (!continued) {
            this.setSelectedDiceField((String)null);
            this.setSelectedFigureField(null);
            this.setRevealedAction(null);
            this.rollDice(engine);
        }
        if (PlayerUtil.isHumanPlaying(engine)) {
            this.preSelectDice();
        }
    }

    private void rollDice(GameEngine engine) {
        this.rolledDice = new ArrayList<Integer>();
        int countDice = SheepRules.getCountDiceToRoll(this, engine.getCurrentPlayer());
        int i = 0;
        while (i < countDice) {
            this.addRolledDice(DiceUtil.throwDice());
            ++i;
        }
        SoundUtil.playSoundSetRandomSound(GameConfig.getInstance().getSoundSet(SOUNDSET_ROLL_DICE, SOUNDSET_ROLL_DICE));
    }

    @Override
    public void stopGame() {
        this.initMembers();
    }

    @Override
    public void changeState(GamePlayer player, MoveInformation move, GameEngine engine) {
        if (move instanceof MovePrey) {
            this.performMovePrey((MovePrey)move);
        } else if (move instanceof MoveGuardian) {
            this.performMoveGuardian((MoveGuardian)move);
        } else if (move instanceof MovePredator) {
            this.performMovePredator((MovePredator)move);
        } else if (move instanceof RevealActionCard) {
            this.performRevealActionCard((RevealActionCard)move);
        } else if (move instanceof PreyEnterShelter) {
            this.performPreyEnterShelter((PreyEnterShelter)move);
        } else if (move instanceof PreyLeaveShelter) {
            this.performPreyLeaveShelter((PreyLeaveShelter)move);
        } else if (move instanceof RelocatePrey) {
            this.performRelocatePrey((RelocatePrey)move);
        } else if (move instanceof ActivateGuardian) {
            this.performActivateGuardian((ActivateGuardian)move);
        } else if (move instanceof OpenGate) {
            this.performOpenGate((OpenGate)move);
        } else if (move instanceof CloseGate) {
            this.performCloseGate((CloseGate)move);
        }
        this.setSelectedDiceField((String)null);
        this.setSelectedFigureField(null);
    }

    private void performMovePrey(MovePrey move) {
        if (this.isSpecialPreyAtField(move.getFrom().getId())) {
            this.placeBattlegroundSpecialPrey(move.getTo().getId());
        } else {
            this.moveBattlegroundNormalPrey(move.getFrom().getId(), move.getTo().getId());
        }
        this.removeRolledDice(move.getDiceIndex());
        SoundUtil.playActiveSoundSetRandomSound(SOUNDSET_MOVE_PREY);
    }

    private void performMoveGuardian(MoveGuardian move) {
        String targetFieldId = move.getTo().getId();
        this.placeGuardian(targetFieldId);
        this.removeRolledDice(move.getDiceIndex());
        if (this.isPredatorPosition(targetFieldId)) {
            if (this.isReservePredatorAvailable()) {
                this.decreaseCountPredatorReserve();
                this.placePredatorOnStartField();
            } else {
                this.removePredator();
            }
        }
        SoundUtil.playActiveSound(SOUND_MOVE_GUARDIAN);
    }

    private void performMovePredator(MovePredator move) {
        String targetFieldId = move.getTo().getId();
        this.placePredator(targetFieldId);
        if (this.isGuardianPosition(targetFieldId)) {
            this.deactivateGuardian();
        } else if (this.isBattlegroundPrey(targetFieldId)) {
            this.removeBattlegroundPrey(targetFieldId);
        }
        SoundUtil.playActiveSoundSetRandomSound(SOUNDSET_MOVE_PREDATOR);
    }

    private void performRevealActionCard(RevealActionCard move) {
        String fieldId = move.getFieldId();
        this.setRevealedAction(this.getHiddenAction(fieldId));
        this.removeRolledDice(move.getDiceIndex());
        this.removeHiddenAction(fieldId);
        this.setSelectedFigureField(null);
        SoundUtil.playSound(SOUND_REVEAL_ACTION_CARD, SOUND_REVEAL_ACTION_CARD);
    }

    private void performPreyEnterShelter(PreyEnterShelter move) {
        this.removeBattlegroundNormalPrey(move.getFrom().getId());
        this.addPreyToShelter();
        this.decreaseAvailableActivitiesCounter();
        SoundUtil.playActiveSoundSetRandomSound(SOUNDSET_MOVE_PREY);
    }

    private void performPreyLeaveShelter(PreyLeaveShelter move) {
        this.removePreyFromShelter();
        this.placeBattlegroundNormalPrey(move.getTo().getId());
        this.decreaseAvailableActivitiesCounter();
        SoundUtil.playActiveSoundSetRandomSound(SOUNDSET_MOVE_PREY);
    }

    private void performRelocatePrey(RelocatePrey move) {
        if (this.isSpecialPreyAtField(move.getFrom().getId())) {
            this.placeBattlegroundSpecialPrey(move.getTo().getId());
        } else {
            this.moveBattlegroundNormalPrey(move.getFrom().getId(), move.getTo().getId());
        }
        this.decreaseAvailableActivitiesCounter();
        SoundUtil.playActiveSoundSetRandomSound(SOUNDSET_MOVE_PREY);
    }

    private void performActivateGuardian(ActivateGuardian move) {
        this.activateGuardian();
        this.decreaseAvailableActivitiesCounter();
        SoundUtil.playSound(SOUND_ACTIVATE_GUARDIAN, SOUND_ACTIVATE_GUARDIAN);
    }

    private void performOpenGate(OpenGate move) {
        this.removeRolledDice(move.getDiceIndex());
        this.openGate();
        this.setRolledDice(List.of(Integer.valueOf(move.getRerolledDiceValue())));
        SoundUtil.playActiveSound(SOUND_OPEN_GATE);
    }

    private void performCloseGate(CloseGate move) {
        this.removeRolledDice(move.getDiceIndex());
        this.closeGate();
        SoundUtil.playActiveSound(SOUND_CLOSE_GATE);
    }

    @Override
    public void undoMove(GamePlayer player, MoveInformation move) {
    }

    @Override
    public int save(Document doc, Element root) {
        root.setAttribute("positionSpecialPrey", this.positionSpecialPrey);
        root.setAttribute("countShelterPrey", String.valueOf(this.countShelterPrey));
        root.setAttribute("positionGuardian", this.positionGuardian);
        root.setAttribute("guardianActive", String.valueOf(this.guardianActive));
        root.setAttribute("positionPredator", this.positionPredator);
        root.setAttribute("countPredatorReserve", String.valueOf(this.countPredatorReserve));
        root.setAttribute("selectedDiceField", Objects.toString(this.selectedDiceField));
        root.setAttribute("selectedFigureField", Objects.toString(this.selectedFigureField));
        root.setAttribute("availableActivitiesCounter", String.valueOf(this.availableActivitiesCounter));
        root.setAttribute("gateClosed", String.valueOf(this.gateClosed));
        root.setAttribute("revealedAction", this.revealedAction != null ? this.revealedAction.name() : "");
        HGBaseXMLTools.writeCollection(doc, root, "battlegroundNormalPrey", "position", this.battlegroundNormalPrey, HGBaseXMLTools::setNodeValue);
        HGBaseXMLTools.writeCollection(doc, root, "rolledDice", "value", this.rolledDice, (node, value) -> HGBaseXMLTools.setNodeValue(node, String.valueOf(value)));
        HGBaseXMLTools.writeMap(doc, root, "positionHiddenAction", this.positionHiddenAction, HGBaseXMLTools::setNodeValue, (valueNode, action) -> HGBaseXMLTools.setNodeValue(valueNode, action.name()));
        return 0;
    }

    @Override
    public int load(Node node) {
        this.placeBattlegroundSpecialPrey(HGBaseXMLTools.getAttributeValue(node, "positionSpecialPrey"));
        this.countShelterPrey = HGBaseXMLTools.getAttributeIntValue(node, "countShelterPrey", 0);
        this.placeGuardian(HGBaseXMLTools.getAttributeValue(node, "positionGuardian"));
        this.setGuardianActive(HGBaseXMLTools.getAttributeBooleanValue(node, "guardianActive", true));
        this.placePredator(HGBaseXMLTools.getAttributeValue(node, "positionPredator"));
        this.setCountPredatorReserve(HGBaseXMLTools.getAttributeIntValue(node, "countPredatorReserve", 0));
        this.setSelectedFigureField(HGBaseXMLTools.getAttributeValue(node, "selectedFigureField"));
        this.setAvailableActivitiesCounter(HGBaseXMLTools.getAttributeIntValue(node, "availableActivitiesCounter"));
        this.setGateState(HGBaseXMLTools.getAttributeBooleanValue(node, "gateClosed", true));
        this.setRevealedAction(HiddenAction.valueOfSecure(HGBaseXMLTools.getAttributeValue(node, "revealedAction")));
        this.battlegroundNormalPrey = HGBaseXMLTools.readCollection(node, "battlegroundNormalPrey", "position", ArrayList::new, HGBaseXMLTools::getNodeValue);
        this.rolledDice = (List)HGBaseXMLTools.readCollection(node, "rolledDice", "value", ArrayList::new, elementNode -> Integer.valueOf(HGBaseXMLTools.getNodeValue(elementNode)));
        this.setSelectedDiceField(HGBaseXMLTools.getAttributeValue(node, "selectedDiceField"));
        this.positionHiddenAction = HGBaseXMLTools.readMap(node, "positionHiddenAction", HashMap::new, HGBaseXMLTools::getNodeValue, valueNode -> HiddenAction.valueOfSecure(HGBaseXMLTools.getNodeValue(valueNode)));
        return 0;
    }

    @Override
    public String toNetworkString() {
        StringBuilder data = new StringBuilder();
        data.append(this.positionSpecialPrey != null ? this.positionSpecialPrey : "^");
        data.append(";");
        data.append(this.countShelterPrey);
        data.append(";");
        data.append(this.positionGuardian != null ? this.positionGuardian : "^");
        data.append(";");
        data.append(this.guardianActive);
        data.append(";");
        data.append(this.positionPredator != null ? this.positionPredator : "^");
        data.append(";");
        data.append(this.countPredatorReserve);
        data.append(";");
        data.append(this.availableActivitiesCounter);
        data.append(";");
        data.append(this.gateClosed);
        data.append(";");
        data.append(this.revealedAction != null ? this.revealedAction.name() : "^");
        data.append(";");
        data.append(NetworkUtil.fromCollection(this.battlegroundNormalPrey, Function.identity()));
        data.append(";");
        data.append(NetworkUtil.fromCollection(this.rolledDice, String::valueOf));
        data.append(";");
        data.append(NetworkUtil.fromMap(this.positionHiddenAction, Function.identity(), Enum::name));
        return data.toString();
    }

    @Override
    public boolean fromNetworkString(String data) {
        String[] parts = data.split(";");
        int countParts = parts.length;
        this.placeBattlegroundSpecialPrey(countParts > 0 ? parts[0] : null);
        this.countShelterPrey = countParts > 1 ? Integer.parseInt(parts[1]) : 0;
        this.placeGuardian(countParts > 2 ? parts[2] : null);
        this.setGuardianActive(countParts <= 3 || Boolean.parseBoolean(parts[3]));
        this.placePredator(countParts > 4 ? parts[4] : null);
        this.setCountPredatorReserve(countParts > 5 ? Integer.parseInt(parts[5]) : 0);
        this.setAvailableActivitiesCounter(countParts > 6 ? Integer.parseInt(parts[6]) : 0);
        this.setGateState(countParts <= 7 || Boolean.parseBoolean(parts[7]));
        this.setRevealedAction(countParts > 8 ? HiddenAction.valueOfSecure(parts[8]) : null);
        this.battlegroundNormalPrey = countParts > 9 ? NetworkUtil.toCollection(parts[9], Function.identity()) : null;
        this.rolledDice = countParts > 10 ? (List)NetworkUtil.toCollection(parts[10], Integer::valueOf) : null;
        this.positionHiddenAction = countParts > 11 ? NetworkUtil.toMap(parts[11], HashMap::new, Function.identity(), HiddenAction::valueOfSecure) : null;
        this.preSelectDice();
        return true;
    }

    @Override
    public String toNetworkStringMove(MoveInformation move) {
        if (move instanceof OpenGate) {
            return ((OpenGate)move).toNetworkString();
        }
        if (move instanceof CloseGate) {
            return ((CloseGate)move).toNetworkString();
        }
        if (move instanceof MoveGuardian) {
            return ((MoveGuardian)move).toNetworkString();
        }
        if (move instanceof MovePredator) {
            return ((MovePredator)move).toNetworkString();
        }
        if (move instanceof MovePrey) {
            return ((MovePrey)move).toNetworkString();
        }
        if (move instanceof PreyEnterShelter) {
            return ((PreyEnterShelter)move).toNetworkString();
        }
        if (move instanceof PreyLeaveShelter) {
            return ((PreyLeaveShelter)move).toNetworkString();
        }
        if (move instanceof RelocatePrey) {
            return ((RelocatePrey)move).toNetworkString();
        }
        if (move instanceof ActivateGuardian) {
            return ((ActivateGuardian)move).toNetworkString();
        }
        if (move instanceof RevealActionCard) {
            return ((RevealActionCard)move).toNetworkString();
        }
        return null;
    }

    private String getMoveNetworkIdentifier(String data) {
        if (!HGBaseTools.hasContent(data)) {
            return "";
        }
        String[] parts = data.split(";");
        return parts.length > 0 ? parts[0] : "";
    }

    @Override
    public MoveInformation fromNetworkStringMove(String data) {
        this.setSelectedDiceField((String)null);
        this.setSelectedFigureField(null);
        switch (this.getMoveNetworkIdentifier(data)) {
            case "OG": {
                return OpenGate.fromNetworkString(data, this);
            }
            case "CG": {
                return CloseGate.fromNetworkString(data, this);
            }
            case "MG": {
                return MoveGuardian.fromNetworkString(data, this);
            }
            case "MPD": {
                return MovePredator.fromNetworkString(data, this);
            }
            case "MP": {
                return MovePrey.fromNetworkString(data, this);
            }
            case "PES": {
                return PreyEnterShelter.fromNetworkString(data);
            }
            case "PLS": {
                return PreyLeaveShelter.fromNetworkString(data);
            }
            case "RP": {
                return RelocatePrey.fromNetworkString(data);
            }
            case "AG": {
                return ActivateGuardian.fromNetworkString(data);
            }
            case "RAC": {
                return RevealActionCard.fromNetworkString(data);
            }
        }
        return null;
    }

    @Override
    public Object clone() {
        return null;
    }
}

