/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.game.move;

import com.tjger.goldensheep.desktop.game.SheepState;
import tjger.game.SplitableMove;

public class CloseGate
implements SplitableMove {
    public static final String NETWORK_IDENTIFIER = "CG";
    private final int diceIndex;

    public CloseGate(int diceIndex) {
        this.diceIndex = diceIndex;
    }

    public int getDiceIndex() {
        return this.diceIndex;
    }

    @Override
    public boolean isMoveComplete() {
        return SheepState.isPlayerMoveCompleted(this);
    }

    public String toNetworkString() {
        return "CG;" + this.diceIndex;
    }

    public static CloseGate fromNetworkString(String data, SheepState gameState) {
        String[] parts = data.split(";");
        int countParts = parts.length;
        int diceIndex = countParts > 1 ? Integer.parseInt(parts[1]) : 0;
        gameState.setGuardianSelected();
        gameState.setSelectedDiceField(diceIndex);
        return new CloseGate(diceIndex);
    }

    public int hashCode() {
        return Integer.hashCode(this.diceIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.diceIndex == ((CloseGate)obj).diceIndex;
    }
}

