/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.game.move;

import com.tjger.goldensheep.desktop.game.SheepPlayingField;
import com.tjger.goldensheep.desktop.game.SheepState;
import com.tjger.goldensheep.desktop.game.move.IToField;
import java.util.Objects;
import tjger.game.SplitableMove;
import tjger.game.completed.playingfield.SingleField;

public class MoveGuardian
implements SplitableMove,
IToField {
    public static final String NETWORK_IDENTIFIER = "MG";
    private final SingleField to;
    private final int diceIndex;

    public MoveGuardian(SingleField to, int diceIndex) {
        this.to = to;
        this.diceIndex = diceIndex;
    }

    @Override
    public SingleField getTo() {
        return this.to;
    }

    public int getDiceIndex() {
        return this.diceIndex;
    }

    @Override
    public boolean isMoveComplete() {
        return SheepState.isPlayerMoveCompleted(this);
    }

    public String toNetworkString() {
        return "MG;" + this.to.getId() + ";" + this.diceIndex;
    }

    public static MoveGuardian fromNetworkString(String data, SheepState gameState) {
        String[] parts = data.split(";");
        int countParts = parts.length;
        SingleField to = countParts > 1 ? SheepPlayingField.getField(parts[1]) : null;
        int diceIndex = countParts > 2 ? Integer.parseInt(parts[2]) : 0;
        gameState.setGuardianSelected();
        gameState.setSelectedDiceField(diceIndex);
        return new MoveGuardian(to, diceIndex);
    }

    public int hashCode() {
        return Objects.hash(this.to, this.diceIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MoveGuardian other = (MoveGuardian)obj;
        return Objects.equals(this.to, other.to) && this.diceIndex == other.diceIndex;
    }
}

