/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.game.move;

import com.tjger.goldensheep.desktop.game.SheepPlayingField;
import com.tjger.goldensheep.desktop.game.SheepState;
import com.tjger.goldensheep.desktop.game.move.IFromField;
import com.tjger.goldensheep.desktop.game.move.IToField;
import java.util.Objects;
import tjger.game.SplitableMove;
import tjger.game.completed.playingfield.SingleField;

public class MovePrey
implements SplitableMove,
IFromField,
IToField {
    public static final String NETWORK_IDENTIFIER = "MP";
    private final SingleField from;
    private final SingleField to;
    private final int diceIndex;

    public MovePrey(SingleField from, SingleField to, int diceIndex) {
        this.to = to;
        this.from = from;
        this.diceIndex = diceIndex;
    }

    @Override
    public SingleField getTo() {
        return this.to;
    }

    @Override
    public SingleField getFrom() {
        return this.from;
    }

    public int getDiceIndex() {
        return this.diceIndex;
    }

    @Override
    public boolean isMoveComplete() {
        return SheepState.isPlayerMoveCompleted(this);
    }

    public String toNetworkString() {
        return "MP;" + this.from.getId() + ";" + this.to.getId() + ";" + this.diceIndex;
    }

    public static MovePrey fromNetworkString(String data, SheepState gameState) {
        String[] parts = data.split(";");
        int countParts = parts.length;
        SingleField from = countParts > 1 ? SheepPlayingField.getField(parts[1]) : null;
        SingleField to = countParts > 2 ? SheepPlayingField.getField(parts[2]) : null;
        int diceIndex = countParts > 3 ? Integer.parseInt(parts[3]) : 0;
        gameState.setSelectedFigureField(from != null ? from.getId() : null);
        gameState.setSelectedDiceField(diceIndex);
        return new MovePrey(from, to, diceIndex);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.diceIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MovePrey other = (MovePrey)obj;
        return Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && this.diceIndex == other.diceIndex;
    }
}

