/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.game.move;

import com.tjger.goldensheep.desktop.game.SheepState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import tjger.game.SplitableMove;

public class OpenGate
implements SplitableMove {
    public static final String NETWORK_IDENTIFIER = "OG";
    private final int diceIndex;
    private final int openDiceValue;
    private final int rerolledDiceValue;

    public OpenGate(int diceIndex, int openDiceValue, int rerolledDiceValue) {
        this.diceIndex = diceIndex;
        this.openDiceValue = openDiceValue;
        this.rerolledDiceValue = rerolledDiceValue;
    }

    public int getDiceIndex() {
        return this.diceIndex;
    }

    public int getOpenDiceValue() {
        return this.openDiceValue;
    }

    public int getRerolledDiceValue() {
        return this.rerolledDiceValue;
    }

    @Override
    public boolean isMoveComplete() {
        return false;
    }

    public String toNetworkString() {
        return "OG;" + this.diceIndex + ";" + this.openDiceValue + ";" + this.rerolledDiceValue;
    }

    public static OpenGate fromNetworkString(String data, SheepState gameState) {
        String[] parts = data.split(";");
        int countParts = parts.length;
        int diceIndex = countParts > 1 ? Integer.parseInt(parts[1]) : 0;
        int openDiceValue = countParts > 2 ? Integer.parseInt(parts[2]) : 0;
        int rerolledDiceValue = countParts > 3 ? Integer.parseInt(parts[3]) : 0;
        gameState.setRolledDice(new ArrayList<Integer>(List.of(Integer.valueOf(rerolledDiceValue))));
        gameState.setSelectedDiceField(diceIndex);
        return new OpenGate(diceIndex, openDiceValue, rerolledDiceValue);
    }

    public int hashCode() {
        return Objects.hash(this.diceIndex, this.openDiceValue, this.rerolledDiceValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OpenGate other = (OpenGate)obj;
        return this.diceIndex == other.diceIndex && this.openDiceValue == other.openDiceValue && this.rerolledDiceValue == other.rerolledDiceValue;
    }
}

