/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.game.move;

import com.tjger.goldensheep.desktop.game.SheepPlayingField;
import com.tjger.goldensheep.desktop.game.SheepState;
import com.tjger.goldensheep.desktop.game.move.IFromField;
import com.tjger.goldensheep.desktop.game.move.IToField;
import java.util.Objects;
import tjger.game.SplitableMove;
import tjger.game.completed.playingfield.SingleField;

public class RelocatePrey
implements SplitableMove,
IFromField,
IToField {
    public static final String NETWORK_IDENTIFIER = "RP";
    private final SingleField from;
    private final SingleField to;

    public RelocatePrey(SingleField from, SingleField to) {
        this.to = to;
        this.from = from;
    }

    @Override
    public SingleField getTo() {
        return this.to;
    }

    @Override
    public SingleField getFrom() {
        return this.from;
    }

    @Override
    public boolean isMoveComplete() {
        return SheepState.isPlayerMoveCompleted(this);
    }

    public String toNetworkString() {
        return "RP;" + this.from.getId() + ";" + this.to.getId();
    }

    public static RelocatePrey fromNetworkString(String data) {
        String[] parts = data.split(";");
        int countParts = parts.length;
        SingleField from = countParts > 1 ? SheepPlayingField.getField(parts[1]) : null;
        SingleField to = countParts > 2 ? SheepPlayingField.getField(parts[2]) : null;
        return new RelocatePrey(from, to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RelocatePrey other = (RelocatePrey)obj;
        return Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to);
    }
}

