/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.game.move;

import com.tjger.goldensheep.desktop.game.SheepState;
import java.util.Objects;
import tjger.game.SplitableMove;

public class RevealActionCard
implements SplitableMove {
    public static final String NETWORK_IDENTIFIER = "RAC";
    private final String fieldId;
    private final int diceIndex;

    public RevealActionCard(String fieldId, int diceIndex) {
        this.fieldId = fieldId;
        this.diceIndex = diceIndex;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public int getDiceIndex() {
        return this.diceIndex;
    }

    @Override
    public boolean isMoveComplete() {
        return SheepState.isPlayerMoveCompleted(this);
    }

    public String toNetworkString() {
        return "RAC;" + this.fieldId + ";" + this.diceIndex;
    }

    public static RevealActionCard fromNetworkString(String data) {
        String[] parts = data.split(";");
        int countParts = parts.length;
        String fieldId = countParts > 1 ? parts[1] : null;
        int diceIndex = countParts > 2 ? Integer.parseInt(parts[2]) : 0;
        return new RevealActionCard(fieldId, diceIndex);
    }

    public int hashCode() {
        return Objects.hash(this.fieldId, this.diceIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RevealActionCard other = (RevealActionCard)obj;
        return Objects.equals(this.fieldId, other.fieldId) && this.diceIndex == other.diceIndex;
    }
}

