/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.game.player.computer;

import com.tjger.goldensheep.desktop.game.SheepPlayerUtil;
import com.tjger.goldensheep.desktop.game.SheepPlayingField;
import com.tjger.goldensheep.desktop.game.SheepState;
import com.tjger.goldensheep.desktop.game.move.ActivateGuardian;
import com.tjger.goldensheep.desktop.game.move.CloseGate;
import com.tjger.goldensheep.desktop.game.move.IToField;
import com.tjger.goldensheep.desktop.game.move.MovePrey;
import com.tjger.goldensheep.desktop.game.move.OpenGate;
import com.tjger.goldensheep.desktop.game.move.PreyEnterShelter;
import com.tjger.goldensheep.desktop.game.move.PreyLeaveShelter;
import com.tjger.goldensheep.desktop.game.move.RelocatePrey;
import com.tjger.goldensheep.desktop.game.move.RevealActionCard;
import com.tjger.goldensheep.desktop.game.player.computer.SheepComputerPlayer;
import hgb.lib.HGBaseTools;
import hgb.lib.internal.SimpleHGBaseItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import tjger.game.MoveInformation;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.SingleField;

public class ComputerNormal
extends SheepComputerPlayer {
    public ComputerNormal(String playerType, String playerName, ImageIcon playerImage, String pieceColor) {
        super(playerType, playerName, playerImage, pieceColor);
    }

    private MoveInformation getBestPredatorWayMove(List<MoveInformation> possibleMoves) {
        return this.getFirstMoveOfClass(possibleMoves, OpenGate.class).orElseGet(() -> this.getState().isGateClosed() ? this.getBestPredatorMoveTowardsGateMove(possibleMoves) : this.getBestPredatorBattlegroundMove(possibleMoves));
    }

    private MoveInformation getBestPredatorMoveTowardsGateMove(List<MoveInformation> possibleMoves) {
        PlayingField playingField = SheepPlayingField.getPlayingField();
        SheepState gameState = this.getState();
        return this.getMoveTowardsPositions(this.getMovementMoves(possibleMoves), SheepPlayingField.getPredatorGateFields().stream().map(SimpleHGBaseItem::getId).collect(Collectors.toList()), (origin, target) -> SheepPlayingField.mayPredatorUseConnection(playingField, gameState, origin, target, true)).orElse(null);
    }

    private MoveInformation getBestPredatorBattlegroundMove(List<MoveInformation> possibleMoves) {
        Optional<MoveInformation> catchPreyOnHiddenActionMove;
        Optional<MoveInformation> catchSpecialPreyMove = this.getPredatorCatchSpecialPreyMove(possibleMoves);
        if (catchSpecialPreyMove.isPresent()) {
            return catchSpecialPreyMove.get();
        }
        Optional<MoveInformation> catchGuardianMove = this.getPredatorCatchGuardianMove(possibleMoves);
        if (catchGuardianMove.isPresent()) {
            return catchGuardianMove.get();
        }
        List<MoveInformation> savePossibleMoves = this.removeGuardianReachableFields(possibleMoves);
        if (!savePossibleMoves.isEmpty()) {
            possibleMoves = savePossibleMoves;
        }
        if ((catchPreyOnHiddenActionMove = this.getPredatorCatchPreyOnHiddenAction(possibleMoves)).isPresent()) {
            return catchPreyOnHiddenActionMove.get();
        }
        Optional<MoveInformation> catchPreyMove = this.getPredatorCatchNormalPreyMove(possibleMoves);
        if (catchPreyMove.isPresent()) {
            return catchPreyMove.get();
        }
        return this.getPredatorMoveTowardsSpecialPreyMove(possibleMoves);
    }

    private Optional<MoveInformation> getPredatorCatchSpecialPreyMove(List<MoveInformation> possibleMoves) {
        return this.getMoveToPositionMove(possibleMoves, this.getState().getBattlegroundSpecialPreyPosition());
    }

    private Optional<MoveInformation> getPredatorCatchGuardianMove(List<MoveInformation> possibleMoves) {
        return this.getMoveToPositionMove(possibleMoves, this.getState().getGuardianPosition());
    }

    private List<MoveInformation> removeGuardianReachableFields(List<MoveInformation> possibleMoves) {
        SheepState gameState = this.getState();
        if (!gameState.isGuardianActive()) {
            return possibleMoves;
        }
        Collection<SingleField> reachableFields = SheepPlayingField.getGuardianReachableFields(this.getState(), 12);
        return possibleMoves.stream().filter(move -> !(move instanceof IToField) || !reachableFields.contains(((IToField)((Object)move)).getTo())).collect(Collectors.toList());
    }

    private Optional<MoveInformation> getPredatorCatchPreyOnHiddenAction(List<MoveInformation> possibleMoves) {
        return this.getMoveToPositionsMove(possibleMoves, this.getState().getBattlegroundPreyOnHiddenAction());
    }

    private Optional<MoveInformation> getPredatorCatchNormalPreyMove(List<MoveInformation> possibleMoves) {
        return this.getMoveToPositionsMove(possibleMoves, new ArrayList<String>(this.getState().getBattlegroundNormalPrey()));
    }

    private MoveInformation getPredatorMoveTowardsSpecialPreyMove(List<MoveInformation> possibleMoves) {
        PlayingField playingField = SheepPlayingField.getPlayingField();
        SheepState gameState = this.getState();
        return this.getMoveTowardsPosition(this.getMovementMoves(possibleMoves), this.getState().getBattlegroundSpecialPreyPosition(), (origin, target) -> SheepPlayingField.mayPredatorUseConnection(playingField, gameState, origin, target, true)).orElse(null);
    }

    private MoveInformation getBestPredatorMove(List<MoveInformation> possibleMoves) {
        return this.getState().isPredatorOnPredatorWay() ? this.getBestPredatorWayMove(possibleMoves) : this.getBestPredatorBattlegroundMove(possibleMoves);
    }

    private MoveInformation getBestGuardianMove(List<MoveInformation> possibleMoves) {
        Optional<MoveInformation> moveGuardianMove;
        Optional<MoveInformation> moveSpecialPreyMove;
        PlayingField playingField = SheepPlayingField.getPlayingField();
        Optional<MoveInformation> actionCardMove = this.getBestActionCardMove(possibleMoves, playingField);
        if (actionCardMove.isPresent()) {
            return actionCardMove.get();
        }
        Optional<MoveInformation> catchPredatorMove = this.getGuardianCatchPredatorMove(possibleMoves, playingField);
        if (catchPredatorMove.isPresent()) {
            return catchPredatorMove.get();
        }
        Collection<SingleField> predatorReachableFields = this.getPredatorReachableFields();
        if (this.isSpecialPreyCatchable(predatorReachableFields, playingField) && (moveSpecialPreyMove = this.getBestSpecialPreyEscapeMove(possibleMoves, playingField)).isPresent()) {
            return moveSpecialPreyMove.get();
        }
        if (this.isGuardianCatchable(predatorReachableFields, playingField) && (moveGuardianMove = this.getBestGuardianEscapeMove(possibleMoves, playingField)).isPresent()) {
            return moveGuardianMove.get();
        }
        return this.getCloseGateMove(possibleMoves).orElseGet(() -> this.getBestPreyMove(possibleMoves, playingField).orElse(null));
    }

    private Optional<MoveInformation> getBestActionCardMove(List<MoveInformation> possibleMoves, PlayingField playingField) {
        SheepState gameState = this.getState();
        if (!gameState.isActionCardRevealed()) {
            return Optional.empty();
        }
        switch (gameState.getRevealedAction()) {
            case ACTIVATE_GUARDIAN: {
                return this.getFirstMoveOfClass(possibleMoves, ActivateGuardian.class);
            }
            case ONE_PREY_ENTER_SHELTER: 
            case TWO_PREY_ENTER_SHELTER: {
                return this.getBestPreyEnterShelterMove(possibleMoves, playingField);
            }
            case ONE_PREY_LEAVE_SHELTER: 
            case TWO_PREY_LEAVE_SHELTER: {
                return this.getBestPreyLeaveShelterMove(possibleMoves, playingField);
            }
            case RELOCATE_PREY: {
                return this.getBestRelocatePreyMove(possibleMoves, playingField);
            }
        }
        return Optional.empty();
    }

    private Optional<MoveInformation> getBestPreyEnterShelterMove(List<MoveInformation> possibleMoves, PlayingField playingField) {
        SingleField preyClosestToPredator = playingField.getField(this.getPreyPositionClosestToPredator(playingField, false));
        return this.getMoveOfClass(possibleMoves, PreyEnterShelter.class).stream().map(PreyEnterShelter.class::cast).filter(move -> move != null && move.getFrom().equals(preyClosestToPredator)).findFirst().map(MoveInformation.class::cast);
    }

    private Optional<MoveInformation> getMoveAwayFromPredator(List<MoveInformation> moves, PlayingField playingField) {
        SheepState gameState = this.getState();
        return this.getMoveAwayFromPosition(moves.stream().filter(IToField.class::isInstance).map(IToField.class::cast).collect(Collectors.toList()), gameState.getPredatorPosition(), playingField, (origin, target) -> SheepPlayingField.mayPredatorUseConnection(playingField, gameState, origin, target, false)).map(MoveInformation.class::cast);
    }

    private Optional<MoveInformation> getBestPreyLeaveShelterMove(List<MoveInformation> possibleMoves, PlayingField playingField) {
        return this.getMoveAwayFromPredator(this.getMoveOfClass(possibleMoves, PreyLeaveShelter.class), playingField);
    }

    private Optional<MoveInformation> getBestRelocatePreyMove(List<MoveInformation> possibleMoves, PlayingField playingField) {
        SingleField preyClosestToPredator = playingField.getField(this.getPreyPositionClosestToPredator(playingField, true));
        List<MoveInformation> moves = this.getMoveOfClass(possibleMoves, RelocatePrey.class).stream().filter(move -> ((RelocatePrey)move).getFrom().equals(preyClosestToPredator)).collect(Collectors.toList());
        return this.getMoveAwayFromPredator(moves, playingField);
    }

    private Optional<MoveInformation> getGuardianCatchPredatorMove(List<MoveInformation> possibleMoves, PlayingField playingField) {
        SingleField predatorPosition = playingField.getField(this.getState().getPredatorPosition());
        return this.getGuardianMovementMoves(possibleMoves).stream().filter(move -> move.getTo().equals(predatorPosition)).map(MoveInformation.class::cast).filter(Objects::nonNull).findFirst();
    }

    private Collection<SingleField> getPredatorReachableFields() {
        return SheepPlayingField.getPredatorReachableFields(this.getState(), 6);
    }

    private boolean isSpecialPreyCatchable(Collection<SingleField> predatorReachableFields, PlayingField playingField) {
        return predatorReachableFields.contains(playingField.getField(this.getState().getBattlegroundSpecialPreyPosition()));
    }

    private Optional<MoveInformation> getBestSpecialPreyEscapeMove(List<MoveInformation> possibleMoves, PlayingField playingField) {
        return this.getBestPreyEscapeMove(this.getSpecialPreyMovementMoves(possibleMoves), playingField);
    }

    private Optional<MoveInformation> getBestPreyEscapeMove(List<MovePrey> possibleMoves, PlayingField playingField) {
        return this.getMoveAwayFromPredator(possibleMoves.stream().map(MoveInformation.class::cast).collect(Collectors.toList()), playingField);
    }

    private boolean isGuardianCatchable(Collection<SingleField> predatorReachableFields, PlayingField playingField) {
        return predatorReachableFields.contains(playingField.getField(this.getState().getGuardianPosition()));
    }

    private Optional<MoveInformation> getBestGuardianEscapeMove(List<MoveInformation> possibleMoves, PlayingField playingField) {
        List<IToField> moves = this.getGuardianMovementMoves(possibleMoves).stream().map(IToField.class::cast).collect(Collectors.toList());
        Optional<MoveInformation> homeMove = this.getMoveGuardianHomeMove(moves, playingField);
        if (homeMove.isPresent()) {
            return homeMove;
        }
        return this.getMoveAwayFromPredator(moves.stream().map(MoveInformation.class::cast).collect(Collectors.toList()), playingField);
    }

    private Optional<MoveInformation> getMoveGuardianHomeMove(List<IToField> guardianMoves, PlayingField playingField) {
        SingleField homeField = SheepPlayingField.getGuardianHomeField(playingField);
        return guardianMoves.stream().filter(move -> move.getTo().equals(homeField)).findFirst().map(MoveInformation.class::cast);
    }

    private Optional<MoveInformation> getCloseGateMove(List<MoveInformation> possibleMoves) {
        return this.getMoveOfClass(possibleMoves, CloseGate.class).stream().findFirst();
    }

    private Optional<MoveInformation> getBestPreyMove(List<MoveInformation> possibleMoves, PlayingField playingField) {
        MoveInformation revealActionCardMove = HGBaseTools.pickRandomElement(this.getMoveOfClass(possibleMoves, RevealActionCard.class), false);
        if (revealActionCardMove != null) {
            return Optional.of(revealActionCardMove);
        }
        MoveInformation moveToHiddenAction = HGBaseTools.pickRandomElement(this.getMoveNormalPreyToHiddenActionMoves(possibleMoves), false);
        if (moveToHiddenAction != null) {
            return Optional.of(moveToHiddenAction);
        }
        return this.getBestPreyEscapeMove(this.getPreyMoves(possibleMoves, this.getPreyPositionClosestToPredator(playingField, true), playingField), playingField);
    }

    private String getPreyPositionClosestToPredator(PlayingField playingField, boolean includeSpecialPrey) {
        SheepState gameState = this.getState();
        String predatorPosition = gameState.getPredatorPosition();
        Collection<String> preyPositions = includeSpecialPrey ? gameState.getBattlegroundPrey() : gameState.getBattlegroundNormalPrey();
        int lowestPathWeight = Integer.MAX_VALUE;
        String closestPreyPosition = null;
        for (String preyPosition : preyPositions) {
            int pathWeight = this.getLowestPathWeight(playingField.getField(preyPosition), List.of(predatorPosition), playingField, (origin, target) -> SheepPlayingField.mayPredatorUseConnection(playingField, gameState, origin, target, false));
            if (pathWeight >= lowestPathWeight) continue;
            lowestPathWeight = pathWeight;
            closestPreyPosition = preyPosition;
        }
        return closestPreyPosition;
    }

    private List<MovePrey> getPreyMoves(List<MoveInformation> possibleMoves, String preyPosition, PlayingField playingField) {
        SingleField preyField = playingField.getField(preyPosition);
        return this.getMoveOfClass(possibleMoves, MovePrey.class).stream().map(MovePrey.class::cast).filter(move -> move != null && move.getFrom().equals(preyField)).collect(Collectors.toList());
    }

    private List<MoveInformation> getMoveNormalPreyToHiddenActionMoves(List<MoveInformation> possibleMoves) {
        return this.getMoveToPositionsMoves(this.getNormalPreyMovementMoves(possibleMoves).stream().map(MoveInformation.class::cast).collect(Collectors.toList()), new ArrayList<String>(this.getState().getHiddenActionPositions()));
    }

    @Override
    protected MoveInformation calculateMove() {
        List<MoveInformation> possibleMoves = this.getRules().getPossibleMoves(this, this.getState());
        MoveInformation move = SheepPlayerUtil.isPlayerPredator(this) ? this.getBestPredatorMove(possibleMoves) : this.getBestGuardianMove(possibleMoves);
        return move != null ? move : HGBaseTools.pickRandomElement(possibleMoves, false);
    }
}

