/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.game.player.computer;

import com.tjger.goldensheep.desktop.game.SheepPlayingField;
import com.tjger.goldensheep.desktop.game.SheepRules;
import com.tjger.goldensheep.desktop.game.SheepState;
import com.tjger.goldensheep.desktop.game.move.IToField;
import com.tjger.goldensheep.desktop.game.move.MoveGuardian;
import com.tjger.goldensheep.desktop.game.move.MovePrey;
import hgb.lib.HGBaseTools;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import tjger.game.ComputerPlayer;
import tjger.game.MoveInformation;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.SingleField;
import tjger.lib.ShortestPath;

public abstract class SheepComputerPlayer
extends ComputerPlayer {
    private static final long MIN_TURN_DURATION = 500L;

    protected SheepComputerPlayer(String playerType, String playerName, ImageIcon playerImage, String pieceColor) {
        super(playerType, playerName, playerImage, pieceColor);
    }

    @Override
    protected long getTurnMinDuration() {
        return 500L;
    }

    protected final SheepRules getRules() {
        return (SheepRules)this.getGameRules();
    }

    protected final SheepState getState() {
        return (SheepState)this.getGameState();
    }

    protected final List<MoveInformation> getMoveOfClass(List<MoveInformation> moves, Class<?> clazz) {
        return moves.stream().filter(clazz::isInstance).collect(Collectors.toList());
    }

    protected final Optional<MoveInformation> getFirstMoveOfClass(List<MoveInformation> moves, Class<?> clazz) {
        return this.getMoveOfClass(moves, clazz).stream().findFirst();
    }

    protected final Optional<IToField> getFirstMoveToPosition(List<IToField> moves, String position) {
        return moves.stream().filter(move -> move.getTo().getId().equals(position)).findFirst();
    }

    protected final List<IToField> getMovementMoves(List<MoveInformation> moves) {
        return moves.stream().filter(IToField.class::isInstance).map(IToField.class::cast).collect(Collectors.toList());
    }

    protected final List<MoveGuardian> getGuardianMovementMoves(List<MoveInformation> moves) {
        return this.getMoveOfClass(moves, MoveGuardian.class).stream().map(MoveGuardian.class::cast).collect(Collectors.toList());
    }

    protected final List<MovePrey> getNormalPreyMovementMoves(List<MoveInformation> moves) {
        SingleField specialPreyPosition = SheepPlayingField.getField(this.getState().getBattlegroundSpecialPreyPosition());
        return this.getMoveOfClass(moves, MovePrey.class).stream().map(MovePrey.class::cast).filter(move -> move != null && !move.getFrom().equals(specialPreyPosition)).collect(Collectors.toList());
    }

    protected final List<MovePrey> getSpecialPreyMovementMoves(List<MoveInformation> moves) {
        SingleField specialPreyPosition = SheepPlayingField.getField(this.getState().getBattlegroundSpecialPreyPosition());
        return this.getMoveOfClass(moves, MovePrey.class).stream().map(MovePrey.class::cast).filter(move -> move != null && move.getFrom().equals(specialPreyPosition)).collect(Collectors.toList());
    }

    protected final Optional<MoveInformation> getMoveToPositionMove(List<MoveInformation> possibleMoves, String position) {
        Optional<IToField> moveToPosition = this.getFirstMoveToPosition(this.getMovementMoves(possibleMoves), position);
        return moveToPosition.isPresent() && moveToPosition.get() instanceof MoveInformation ? Optional.of((MoveInformation)((Object)moveToPosition.get())) : Optional.empty();
    }

    protected final List<MoveInformation> getMoveToPositionsMoves(List<MoveInformation> possibleMoves, List<String> positions) {
        return positions.stream().map(position -> this.getMoveToPositionMove(possibleMoves, (String)position)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    protected final Optional<MoveInformation> getMoveToPositionsMove(List<MoveInformation> possibleMoves, List<String> positions) {
        MoveInformation move = HGBaseTools.pickRandomElement(this.getMoveToPositionsMoves(possibleMoves, positions), false);
        return move != null ? Optional.of(move) : Optional.empty();
    }

    protected final int getLowestPathWeight(SingleField startField, List<String> targetPositions, PlayingField playingField, BiPredicate<SingleField, SingleField> condition) {
        return targetPositions.stream().map(playingField::getField).map(targetPos -> playingField.getShortestPath(startField, (SingleField)targetPos, 0, condition)).filter(Objects::nonNull).mapToInt(ShortestPath::getPathWeight).min().orElse(Integer.MAX_VALUE);
    }

    protected final Optional<IToField> getMoveTowardsPositions(List<IToField> possibleMoves, List<String> positions, BiPredicate<SingleField, SingleField> condition) {
        PlayingField playingField = SheepPlayingField.getPlayingField();
        Optional<IToField> bestMove = Optional.empty();
        int lowestWeight = Integer.MAX_VALUE;
        for (IToField move : possibleMoves) {
            int weight = this.getLowestPathWeight(move.getTo(), positions, playingField, condition);
            if (weight >= lowestWeight) continue;
            lowestWeight = weight;
            bestMove = Optional.of(move);
        }
        return bestMove;
    }

    protected final Optional<IToField> getMoveTowardsPosition(List<IToField> possibleMoves, String position, BiPredicate<SingleField, SingleField> condition) {
        return this.getMoveTowardsPositions(possibleMoves, List.of(position), condition);
    }

    protected final Optional<IToField> getMoveAwayFromPosition(List<IToField> possibleMoves, String position, PlayingField playingField, BiPredicate<SingleField, SingleField> condition) {
        Optional<IToField> bestMove = Optional.empty();
        int highestWeight = Integer.MIN_VALUE;
        for (IToField move : possibleMoves) {
            int weight = this.getLowestPathWeight(move.getTo(), List.of(position), playingField, condition);
            if (weight <= highestWeight) continue;
            highestWeight = weight;
            bestMove = Optional.of(move);
        }
        return bestMove;
    }
}

