/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.ui.game;

import com.tjger.goldensheep.desktop.game.SheepState;
import com.tjger.goldensheep.desktop.ui.game.FieldSelectionType;
import hgb.lib.HGBaseTools;
import java.awt.Color;
import java.awt.Graphics;
import tjger.game.completed.GameEngine;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.SingleField;
import tjger.gui.GamePanel;
import tjger.gui.completed.playingfield.PlayingFieldPaintUtil;
import tjger.gui.completed.playingfield.SingleFieldPainter;
import tjger.lib.PlayerUtil;

public class FieldPainter
implements SingleFieldPainter {
    private final SheepState gameState;

    public FieldPainter(SheepState gameState) {
        this.gameState = gameState;
    }

    @Override
    public void drawSingleField(PlayingField playField, SingleField field, GamePanel panel, Graphics g) {
        if (this.shouldPaint(field)) {
            PlayingFieldPaintUtil.drawSingleField(playField, field, Color.BLACK, null, panel, g);
        }
        if (this.shouldPaintSelected(field)) {
            this.drawSingleFieldSelection(playField, field, panel, g);
        }
    }

    private void drawSingleFieldSelection(PlayingField playField, SingleField field, GamePanel panel, Graphics g) {
        switch (this.getSelectionType(field)) {
            case COLOR: {
                PlayingFieldPaintUtil.drawSingleFieldSelected(playField, field, this.getSelectionColor(field), panel, g);
                break;
            }
            case CIRCLE: {
                Color oldColor = panel.changeColor(this.getSelectionColor(field), g);
                panel.drawOval(playField, field.getId(), 15, false, g);
                panel.changeColor(oldColor, g);
                break;
            }
        }
    }

    private FieldSelectionType getSelectionType(SingleField field) {
        return this.gameState.isSelectedFigureField(field.getId()) ? FieldSelectionType.CIRCLE : FieldSelectionType.COLOR;
    }

    private boolean shouldPaint(SingleField field) {
        return !HGBaseTools.isOneOf(field.getProperty("type"), "home", "dice", "card", "predator_reserve", "gate_action", "back");
    }

    private boolean shouldPaintSelected(SingleField field) {
        if (!PlayerUtil.isHumanPlaying(GameEngine.getInstance())) {
            return false;
        }
        String fieldId = field.getId();
        return this.gameState.isSelectedDiceField(fieldId) || this.gameState.isFieldReachable(field) || this.gameState.isSelectedFigureField(fieldId) || this.gameState.isActionCardActivityField(fieldId);
    }

    private Color getSelectionColor(SingleField field) {
        return this.gameState.isSelectedFigureField(field.getId()) ? Color.YELLOW : PlayingFieldPaintUtil.DEFAULT_SELECTION_COLOR;
    }
}

