/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.ui.game;

import com.tjger.goldensheep.desktop.game.HiddenAction;
import com.tjger.goldensheep.desktop.game.SheepPlayerUtil;
import com.tjger.goldensheep.desktop.game.SheepPlayingField;
import com.tjger.goldensheep.desktop.game.SheepState;
import com.tjger.goldensheep.desktop.ui.game.FieldPainter;
import com.tjger.goldensheep.desktop.ui.game.SheepGamePanelMouseListener;
import hgb.lib.HGBaseTools;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import tjger.game.GamePlayer;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.SingleField;
import tjger.gui.GamePanel;
import tjger.gui.completed.Background;
import tjger.gui.completed.Card;
import tjger.gui.completed.Part;
import tjger.gui.completed.playingfield.PlayingFieldPaintUtil;

public class SheepGamePanel
extends GamePanel {
    private static final String PARTSET_TYPE_PREY = "prey";
    private static final String PREY_TYPE_NORMAL = "normal";
    private static final String PREY_TYPE_SPECIAL = "special";
    private static final String PART_TYPE_GUARDIAN = "guardian";
    private static final String GUARDIAN_COLOR_ACTIVE = "active";
    private static final String GUARDIAN_COLOR_INACTIVE = "inactive";
    private static final String PART_TYPE_PREDATOR = "predator";
    private static final String PART_TYPE_FOOD = "food";
    private static final String PART_TYPE_DICE = "dice";
    private static final String DICE_COLOR_GUARDIAN = "guardian";
    private static final String DICE_COLOR_PREDATOR = "predator";
    private static final String PART_TYPE_GATE = "gate";
    private static final String GATE_COLOR_OPEN = "open";
    private static final String GATE_COLOR_CLOSED = "closed";
    private static final String PART_TYPE_GATE_ACTION = "gateaction";
    private static final String GATE_ACTION_COLOR_OPEN = "open";
    private static final String GATE_ACTION_COLOR_CLOSE = "close";

    public SheepGamePanel() {
        this.addMouseListener(new SheepGamePanelMouseListener(this, this.getSheepGameState()));
    }

    private SheepState getSheepGameState() {
        return (SheepState)this.getGameState();
    }

    private Part getPreyPart(String preyType) {
        return SheepGamePanel.getPreyPart(this.getGameConfig(), preyType);
    }

    private static Part getPreyPart(GameConfig config, String preyType) {
        return config.getActivePartFromSet(PARTSET_TYPE_PREY, preyType, 0);
    }

    private Part getNormalPreyPart() {
        return this.getPreyPart(PREY_TYPE_NORMAL);
    }

    private Part getSpecialPreyPart() {
        return this.getPreyPart(PREY_TYPE_SPECIAL);
    }

    public static Part getSpecialPreyPart(GameConfig config) {
        return SheepGamePanel.getPreyPart(config, PREY_TYPE_SPECIAL);
    }

    private Part getGuardianPart(boolean isActive) {
        return SheepGamePanel.getGuardianPart(this.getGameConfig(), isActive);
    }

    public static Part getGuardianPart(GameConfig config, boolean isActive) {
        return config.getActivePartSet("guardian").getPart(isActive ? GUARDIAN_COLOR_ACTIVE : GUARDIAN_COLOR_INACTIVE, 0);
    }

    private Part getPredatorPart() {
        return SheepGamePanel.getPredatorPart(this.getGameConfig());
    }

    public static Part getPredatorPart(GameConfig config) {
        return config.getActivePart("predator");
    }

    private Part getFoodPart() {
        return this.getGameConfig().getActivePart(PART_TYPE_FOOD);
    }

    private Part getActionCardCover() {
        return this.getGameConfig().getActiveCover();
    }

    private Card getActionCard(HiddenAction action) {
        return this.getGameConfig().getActiveCardSet().getCard(action.name().toLowerCase(), 1);
    }

    private String getDiceColor(GamePlayer player) {
        return SheepPlayerUtil.isPlayerGuardian(player) ? "guardian" : "predator";
    }

    private Part getDicePart(int diceValue, GamePlayer player) {
        return this.getGameConfig().getActivePartFromSet(PART_TYPE_DICE, this.getDiceColor(player), diceValue);
    }

    private Part getOpenGatePart() {
        return this.getGameConfig().getActivePartFromSet(PART_TYPE_GATE, "open", 0);
    }

    private Part getClosedGatePart() {
        return this.getGameConfig().getActivePartFromSet(PART_TYPE_GATE, GATE_COLOR_CLOSED, 0);
    }

    private Part getGatePart(SheepState gameState) {
        return gameState.isGateClosed() ? this.getClosedGatePart() : this.getOpenGatePart();
    }

    private Part getOpenGateActionPart() {
        return this.getGameConfig().getActivePartFromSet(PART_TYPE_GATE_ACTION, "open", 0);
    }

    private Part getCloseGateActionPart() {
        return this.getGameConfig().getActivePartFromSet(PART_TYPE_GATE_ACTION, GATE_ACTION_COLOR_CLOSE, 0);
    }

    private Part getGateActionPart(SheepState gameState, GamePlayer currentPlayer) {
        if (SheepPlayerUtil.isPlayerGuardian(currentPlayer) && gameState.isCloseGateAllowed()) {
            return this.getCloseGateActionPart();
        }
        if (SheepPlayerUtil.isPlayerPredator(currentPlayer) && gameState.isOpenGateAllowed()) {
            return this.getOpenGateActionPart();
        }
        return null;
    }

    private void drawFieldPart(PlayingField playingField, String fieldId, Part part, Graphics g) {
        if (fieldId == null) {
            return;
        }
        this.drawPart(playingField, fieldId, 0, 0, part, g);
    }

    private void drawFieldPart(PlayingField playingField, SingleField field, Part part, Graphics g) {
        if (field == null) {
            return;
        }
        this.drawFieldPart(playingField, field.getId(), part, g);
    }

    private void drawFieldParts(PlayingField playingField, String fieldId, Part[] parts, int xSpacing, int ySpacing, Graphics g) {
        if (fieldId == null) {
            return;
        }
        this.drawParts(playingField, fieldId, 0, 0, parts, xSpacing, ySpacing, g);
    }

    private void drawFieldParts(PlayingField playingField, SingleField field, Part[] parts, int xSpacing, int ySpacing, Graphics g) {
        if (field == null) {
            return;
        }
        this.drawFieldParts(playingField, field.getId(), parts, xSpacing, ySpacing, g);
    }

    @Override
    protected void paintBackground(Background back, Graphics g) {
        super.paintBackground(back, g);
        this.paintPlayingField(g);
    }

    private void paintPlayingField(Graphics g) {
        PlayingField playingField = SheepPlayingField.getPlayingField();
        PlayingFieldPaintUtil.drawAllFields(playingField, new FieldPainter(this.getSheepGameState()), this, g);
    }

    @Override
    protected void paintParts(Graphics g) {
        if (!this.getGameEngine().isActiveGame()) {
            return;
        }
        super.paintParts(g);
        SheepState gameState = this.getSheepGameState();
        PlayingField playingField = SheepPlayingField.getPlayingField();
        GameEngine engine = this.getGameEngine();
        GamePlayer currentPlayer = engine.getCurrentPlayer();
        this.paintHiddenActions(gameState, playingField, g);
        this.paintPrey(gameState, playingField, g);
        this.paintGuardian(gameState, playingField, g);
        this.paintPredator(gameState, playingField, g);
        this.paintDice(gameState, playingField, currentPlayer, g);
        this.paintActionCard(gameState, playingField, g);
        this.paintGate(gameState, playingField, g);
        this.paintGateAction(gameState, playingField, currentPlayer, g);
    }

    private void paintHiddenActions(SheepState gameState, PlayingField playingField, Graphics g) {
        Set<String> positions = gameState.getHiddenActionPositions();
        if (positions == null || positions.isEmpty()) {
            return;
        }
        Part foodPart = this.getFoodPart();
        positions.forEach(fieldId -> this.drawFieldPart(playingField, (String)fieldId, foodPart, g));
    }

    private void paintPrey(SheepState gameState, PlayingField playingField, Graphics g) {
        Part normalPreyPart = this.getNormalPreyPart();
        this.paintBattlegroundPrey(gameState, playingField, normalPreyPart, g);
        this.paintShelterPrey(gameState, playingField, normalPreyPart, g);
    }

    private void paintBattlegroundPrey(SheepState gameState, PlayingField playingField, Part normalPreyPart, Graphics g) {
        this.paintBattlegroundNormalPrey(gameState, playingField, normalPreyPart, g);
        this.paintBattlegroundSpecialPrey(gameState, playingField, g);
    }

    private void paintBattlegroundNormalPrey(SheepState gameState, PlayingField playingField, Part normalPreyPart, Graphics g) {
        Collection<String> preyPositions = gameState.getBattlegroundNormalPrey();
        if (preyPositions == null || preyPositions.isEmpty()) {
            return;
        }
        preyPositions.forEach(fieldId -> this.drawFieldPart(playingField, (String)fieldId, normalPreyPart, g));
    }

    private void paintBattlegroundSpecialPrey(SheepState gameState, PlayingField playingField, Graphics g) {
        String position = gameState.getBattlegroundSpecialPreyPosition();
        if (!HGBaseTools.hasContent(position)) {
            return;
        }
        this.drawFieldPart(playingField, position, this.getSpecialPreyPart(), g);
    }

    private void paintShelterPrey(SheepState gameState, PlayingField playingField, Part normalPreyPart, Graphics g) {
        Collection<SingleField> shelterFields = SheepPlayingField.getShelterFields(playingField);
        if (shelterFields == null || shelterFields.isEmpty()) {
            return;
        }
        SingleField[] shelterArray = shelterFields.toArray(new SingleField[0]);
        int countPrey = gameState.getCountShelterPrey();
        int sheepIndex = 0;
        while (sheepIndex < countPrey && sheepIndex < shelterArray.length) {
            this.drawFieldPart(playingField, shelterArray[sheepIndex], normalPreyPart, g);
            ++sheepIndex;
        }
    }

    private void paintGuardian(SheepState gameState, PlayingField playingField, Graphics g) {
        this.drawFieldPart(playingField, gameState.getGuardianPosition(), this.getGuardianPart(gameState.isGuardianActive()), g);
    }

    private void paintPredator(SheepState gameState, PlayingField playingField, Graphics g) {
        Part predatorPart = this.getPredatorPart();
        this.paintBattlefieldPredator(gameState, playingField, predatorPart, g);
        this.paintPredatorReserve(gameState, playingField, predatorPart, g);
    }

    private void paintBattlefieldPredator(SheepState gameState, PlayingField playingField, Part predatorPart, Graphics g) {
        this.drawFieldPart(playingField, gameState.getPredatorPosition(), predatorPart, g);
    }

    private void paintPredatorReserve(SheepState gameState, PlayingField playingField, Part predatorPart, Graphics g) {
        int countPredatorReserve = gameState.getCountPredatorReserve();
        if (countPredatorReserve == 0) {
            return;
        }
        Object[] parts = new Part[countPredatorReserve];
        Arrays.fill(parts, predatorPart);
        this.drawFieldParts(playingField, SheepPlayingField.getPredatorReserveField(playingField), (Part[])parts, 30, 30, g);
    }

    private void paintDice(SheepState gameState, PlayingField playingField, GamePlayer currentPlayer, Graphics g) {
        Collection<Integer> rolledDice = gameState.getRolledDice();
        if (rolledDice == null) {
            return;
        }
        SingleField[] fields = SheepPlayingField.getDiceFields(playingField).toArray(new SingleField[0]);
        int fieldIndex = 0;
        for (Integer diceValue : rolledDice) {
            this.drawFieldPart(playingField, fields[fieldIndex++], this.getDicePart(diceValue, currentPlayer), g);
        }
    }

    private void paintActionCard(SheepState gameState, PlayingField playingField, Graphics g) {
        Part part = null;
        if (gameState.isActionCardRevealable()) {
            part = this.getActionCardCover();
        } else if (gameState.isActionCardRevealed()) {
            part = this.getActionCard(gameState.getRevealedAction());
        }
        if (part != null) {
            this.drawFieldPart(playingField, SheepPlayingField.getActionCardField(playingField), part, g);
        }
    }

    private void paintGate(SheepState gameState, PlayingField playingField, Graphics g) {
        this.drawPart(playingField, SheepPlayingField.getGateField(playingField).getId(), 1, gameState.isGateClosed() ? 0 : -1, this.getGatePart(gameState), g);
    }

    private void paintGateAction(SheepState gameState, PlayingField playingField, GamePlayer currentPlayer, Graphics g) {
        if (currentPlayer == null || !currentPlayer.isHuman()) {
            return;
        }
        Part part = this.getGateActionPart(gameState, currentPlayer);
        if (part == null) {
            return;
        }
        this.drawFieldPart(playingField, SheepPlayingField.getGateActionField(playingField), part, g);
    }
}

