/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.goldensheep.desktop.ui.game;

import com.tjger.goldensheep.desktop.game.SheepPlayerUtil;
import com.tjger.goldensheep.desktop.game.SheepPlayingField;
import com.tjger.goldensheep.desktop.game.SheepState;
import com.tjger.goldensheep.desktop.game.move.ActivateGuardian;
import com.tjger.goldensheep.desktop.game.move.CloseGate;
import com.tjger.goldensheep.desktop.game.move.MoveGuardian;
import com.tjger.goldensheep.desktop.game.move.MovePredator;
import com.tjger.goldensheep.desktop.game.move.MovePrey;
import com.tjger.goldensheep.desktop.game.move.OpenGate;
import com.tjger.goldensheep.desktop.game.move.PreyEnterShelter;
import com.tjger.goldensheep.desktop.game.move.PreyLeaveShelter;
import com.tjger.goldensheep.desktop.game.move.RelocatePrey;
import com.tjger.goldensheep.desktop.game.move.RevealActionCard;
import com.tjger.goldensheep.desktop.ui.game.SheepGamePanel;
import hgb.lib.HGBaseTools;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import tjger.game.MoveInformation;
import tjger.game.completed.GameEngine;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.SingleField;
import tjger.lib.DiceUtil;
import tjger.lib.PlayerUtil;

public class SheepGamePanelMouseListener
implements MouseListener {
    private final SheepGamePanel gamePanel;
    private final SheepState gameState;
    private final GameEngine gameEngine;

    protected SheepGamePanelMouseListener(SheepGamePanel gamePanel, SheepState gameState) {
        this.gamePanel = gamePanel;
        this.gameState = gameState;
        this.gameEngine = GameEngine.getInstance();
    }

    protected boolean isHumanPlayer() {
        return PlayerUtil.isHumanPlaying(this.gameEngine);
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        String selectedFieldId;
        if (!this.gameEngine.isActiveGame() || !this.isHumanPlayer()) {
            return;
        }
        PlayingField playingField = SheepPlayingField.getPlayingField();
        SingleField selectedField = playingField.getFieldAtPosition(this.gamePanel.getMouseX(), this.gamePanel.getMouseY());
        String string = selectedFieldId = selectedField != null ? selectedField.getId() : null;
        if (this.gameState.isActionCardRevealed()) {
            if (this.gameState.isActionCardActivityField(selectedFieldId) || this.gameState.isSelectedFigureField(selectedFieldId)) {
                this.performActionCardMove(playingField, selectedField);
            }
        } else if (SheepPlayingField.isDiceField(playingField, selectedFieldId)) {
            this.setSelectedDice(playingField, selectedFieldId);
        } else if (this.gameState.isFieldReachable(selectedField)) {
            this.performMoveFigureMove(playingField, selectedField);
        } else if (this.isSelectableFigure(selectedFieldId)) {
            this.setSelectedFigureField(selectedFieldId);
        } else if (this.isRevealableActionCard(playingField, selectedFieldId)) {
            this.performRevealActionCardMove();
        } else if (SheepPlayingField.isGateActionField(selectedField) && this.isGateActionAllowed()) {
            this.performGateAction();
        }
    }

    private void setSelectedDice(PlayingField playingField, String fieldId) {
        if (SheepPlayerUtil.isCurrentPlayerPredator()) {
            return;
        }
        this.gameState.setSelectedDiceField(SheepPlayingField.isDiceField(playingField, fieldId) ? fieldId : null);
        this.gamePanel.repaint();
    }

    private boolean isSelectableFigure(String fieldId) {
        if (SheepPlayerUtil.isCurrentPlayerPredator()) {
            return false;
        }
        return this.gameState.isSelectableFigureGuardian(fieldId);
    }

    private boolean isRevealableActionCard(PlayingField playingField, String fieldId) {
        return SheepPlayingField.isActionCardField(playingField, fieldId) && this.gameState.isActionCardRevealable();
    }

    private boolean isGateActionAllowed() {
        return this.gameState.isCloseGateAllowed() || this.gameState.isOpenGateAllowed();
    }

    private void setSelectedFigureField(String fieldId) {
        this.gameState.setSelectedFigureField(fieldId);
        this.gamePanel.repaint();
    }

    private void performActionCardMove(PlayingField playingField, SingleField field) {
        switch (this.gameState.getRevealedAction()) {
            case ONE_PREY_ENTER_SHELTER: 
            case TWO_PREY_ENTER_SHELTER: {
                this.performMove(new PreyEnterShelter(field));
                break;
            }
            case ONE_PREY_LEAVE_SHELTER: 
            case TWO_PREY_LEAVE_SHELTER: {
                this.performMove(new PreyLeaveShelter(field));
                break;
            }
            case RELOCATE_PREY: {
                String selectedFigureField = this.gameState.getSelectedFigureField();
                if (!HGBaseTools.hasContent(selectedFigureField)) {
                    this.setSelectedFigureField(field != null ? field.getId() : null);
                    break;
                }
                if (selectedFigureField.equals(field != null ? field.getId() : null)) {
                    this.setSelectedFigureField(null);
                    break;
                }
                this.performMove(new RelocatePrey(playingField.getField(selectedFigureField), field));
                break;
            }
            case ACTIVATE_GUARDIAN: {
                this.performMove(new ActivateGuardian());
                break;
            }
        }
    }

    private void performMoveFigureMove(PlayingField playingField, SingleField field) {
        if (SheepPlayerUtil.isCurrentPlayerPredator()) {
            this.performMovePredatorMove(field);
        } else if (this.gameState.isGuardianSelected()) {
            this.performMoveGuardianMove(field);
        } else {
            this.performMovePreyMove(playingField, field);
        }
    }

    private void performMovePredatorMove(SingleField target) {
        this.performMove(new MovePredator(target));
    }

    private void performMoveGuardianMove(SingleField target) {
        this.performMove(new MoveGuardian(target, this.gameState.getSelectedDiceIndex()));
    }

    private void performMovePreyMove(PlayingField playingField, SingleField target) {
        this.performMove(new MovePrey(playingField.getField(this.gameState.getSelectedFigureField()), target, this.gameState.getSelectedDiceIndex()));
    }

    private void performRevealActionCardMove() {
        this.performMove(new RevealActionCard(this.gameState.getSelectedFigureField(), this.gameState.getSelectedDiceIndex()));
    }

    private void performGateAction() {
        if (this.gameState.isOpenGateAllowed()) {
            this.performMove(new OpenGate(this.gameState.getSelectedDiceIndex(), this.gameState.getSelectedDiceValue(), DiceUtil.throwDice()));
        } else if (this.gameState.isCloseGateAllowed()) {
            this.performMove(new CloseGate(this.gameState.getSelectedDiceIndex()));
        }
    }

    private void performMove(MoveInformation move) {
        if (move == null) {
            return;
        }
        this.gameEngine.performMove(move);
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }
}

