/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui;

import hgb.gui.EditTextField;
import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseGui;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBasePanel;
import hgb.gui.HGBaseStatusBar;
import hgb.gui.HGBaseWelcome;
import hgb.gui.IActualizeTextListener;
import hgb.gui.ProgressPanel;
import hgb.gui.menu.HGBaseMenu;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import hgb.lib.HGBaseVerify;
import hgb.lib.internal.protocolhandler.resource.Handler;
import hgb.lib.update.HGBaseUpdate;
import hgb.lib.update.UpdateFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class HGBaseFrame
extends JFrame
implements HGBaseGui {
    private static final long serialVersionUID = 424781073L;
    private static final int DELAY_FOR_AUTO_UPDATE = 5000;
    public static final int PROGRESS_NORMAL = 0;
    public static final int PROGRESS_FINISHED = 2;
    public static final int PROGRESS_WAITING = 1;
    private static HGBaseFrame mainFrame;
    private HGBaseMenu menu = null;
    private HGBasePanel panel = null;
    private HGBasePanel mainPanel = null;
    private HGBaseStatusBar statusBar = null;
    private HGBaseUpdate update = null;
    private File currentFile = null;
    private boolean changed = false;
    private List<IActualizeTextListener> actualizeTextList;

    public HGBaseFrame(String settingsFile) {
        this(settingsFile, false);
        Thread.setDefaultUncaughtExceptionHandler(new ExitOnUncaughtExceptionWithDialog());
    }

    public HGBaseFrame(String settingsFile, boolean keepWelcomeScreen) {
        mainFrame = this;
        this.initializeStaticClasses(settingsFile);
        this.actualizeTextList = new ArrayList<IActualizeTextListener>();
        this.initializeUpdate();
        if (this.update != null) {
            this.update.installNewVersion(settingsFile);
        }
        this.setInitialPanel();
        this.setInitialTitle();
        this.setInitialSize();
        this.setInitialLocation();
        this.setInitialLookAndFeel();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new OnWindowCloseTermination());
        if (!keepWelcomeScreen) {
            HGBaseWelcome.getInstance().removeWelcomeScreen();
        }
        this.autoCheckUpdate();
        Handler.install();
    }

    private void initializeStaticClasses(String settingsFile) {
        int ret = HGBaseSettings.fromFile(settingsFile);
        if (ret != 0) {
            System.out.println("No settings file found or file is wrong!");
        }
        HGBaseWelcome.getInstance().initWelcomeScreen();
        HGBaseConfig.fromFile();
        HGBaseText.setLanguage();
        int logMode = this.getLogModeFromConfig();
        HGBaseLog.setLogMode(logMode);
    }

    private void initializeUpdate() {
        String classPath = HGBaseSettings.get("updateClass");
        if (HGBaseTools.hasContent(classPath)) {
            UpdateFactory.getInstance().setUpdateClass(classPath);
            this.update = UpdateFactory.getInstance().createUpdate();
        }
    }

    private void setInitialPanel() {
        this.getRootPane().setFocusable(false);
        Container cp = this.getContentPane();
        this.panel = new HGBasePanel(new BorderLayout());
        this.panel.setFocusable(false);
        this.panel.setBorder(null);
        cp.add(this.panel);
    }

    private void setInitialTitle() {
        this.setTitle();
        ImageIcon img = HGBaseGuiTools.loadImage(HGBaseSettings.get("appIcon"));
        if (img != null) {
            this.setIconImage(img.getImage());
        }
        if (!HGBaseSettings.getBoolean("appFrame", true)) {
            this.setUndecorated(true);
        }
    }

    private void setInitialSize() {
        int width = HGBaseConfig.getInt("last_width");
        int height = HGBaseConfig.getInt("last_height");
        if (width == -2147483631) {
            width = HGBaseSettings.getInt("standard_width");
        }
        if (width == -2147483631) {
            width = 600;
        }
        if (height == -2147483631) {
            height = HGBaseSettings.getInt("standard_height");
        }
        if (height == -2147483631) {
            height = 400;
        }
        this.setSize(width, height);
    }

    private void setInitialLocation() {
        int x = HGBaseTools.toInt(HGBaseConfig.get("last_x"));
        int y = HGBaseTools.toInt(HGBaseConfig.get("last_y"));
        if (x == -2147483631) {
            x = 0;
        }
        if (y == -2147483631) {
            y = 0;
        }
        this.setLocation(x, y);
    }

    private void setInitialLookAndFeel() {
        String laf = HGBaseSettings.getLaf(HGBaseConfig.get("laf"));
        if (laf != null) {
            try {
                UIManager.setLookAndFeel(laf);
                SwingUtilities.updateComponentTreeUI(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected int getLogModeFromConfig() {
        int logMode = 0;
        if (HGBaseConfig.getBoolean("logging")) {
            logMode = Integer.MAX_VALUE;
        } else if (!HGBaseConfig.existsKey("logging")) {
            logMode = 1;
        }
        return logMode;
    }

    public static void main(String[] args) {
        HGBaseFrame mainFrame = new HGBaseFrame("/hgb/lib/xml/settings.xml");
        mainFrame.setMenu(new HGBaseMenu(mainFrame));
        boolean verify = args.length > 0 && HGBaseFrame.isVerifyParameter(args[0]);
        HGBasePanel p = HGBaseFrame.createMyPanel(verify);
        mainFrame.setPanel(p);
        int[] nArray = new int[4];
        nArray[0] = 130;
        nArray[2] = 70;
        nArray[3] = 40;
        mainFrame.setStatusBar(new HGBaseStatusBar(nArray));
        HGBaseFrame.initStatusBar();
    }

    private static boolean isVerifyParameter(String param) {
        HashSet<String> verifyParams = new HashSet<String>(Arrays.asList("/verify", "-verify", "--verify"));
        return verifyParams.contains(param.toLowerCase());
    }

    private static HGBasePanel createMyPanel(boolean withVerify) {
        HGBasePanel p = new HGBasePanel(new BorderLayout());
        HGBasePanel m = new HGBasePanel(new FlowLayout());
        m.add(new JLabel("Remove this element by using setPanel(...)"));
        p.add((Component)m, "North");
        if (withVerify) {
            HGBasePanel v = new HGBasePanel(new FlowLayout());
            final EditTextField tfNumber = new EditTextField("<number>");
            tfNumber.setPreferredSize(new Dimension(100, HGBaseGuiTools.getFieldHeight()));
            v.add(tfNumber);
            final EditTextField tfKey = new EditTextField("<verification key>");
            tfKey.setPreferredSize(new Dimension(150, HGBaseGuiTools.getFieldHeight()));
            v.add(tfKey);
            final EditTextField tfAppKey = new EditTextField("<application key>");
            tfAppKey.setPreferredSize(new Dimension(150, HGBaseGuiTools.getFieldHeight()));
            v.add(tfAppKey);
            JButton btVerify = new JButton("Verify");
            btVerify.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String appKey;
                    String key;
                    int number = HGBaseTools.toInt(tfNumber.getText());
                    if (HGBaseVerify.verifyNumber(number, key = tfKey.getText(), appKey = tfAppKey.getText())) {
                        HGBaseDialog.printInfo("dlg.ok", (JFrame)HGBaseFrame.getInstance());
                    } else {
                        HGBaseDialog.printError("dlg.error", (JFrame)HGBaseFrame.getInstance());
                    }
                }
            });
            v.add(btVerify);
            p.add((Component)v, "Center");
        }
        return p;
    }

    private static void initStatusBar() {
        HGBaseFrame.getInstance().setStatusText(0, "ready");
        HGBaseFrame.getInstance().setStatusText("this is just a test");
        ProgressPanel pnProgress = new ProgressPanel();
        HGBasePanel pn2 = HGBaseFrame.getInstance().getStatusPanel(2);
        pn2.remove(HGBaseFrame.getInstance().getStatusLabel(2));
        pn2.add(pnProgress);
        pnProgress.setState(1);
    }

    public static HGBaseFrame getInstance() {
        return mainFrame;
    }

    public void setMenu(HGBaseMenu menu) {
        this.menu = menu;
        this.setJMenuBar(this.menu);
        JToolBar toolbar = this.menu.getToolbar();
        JPanel p = new JPanel(new BorderLayout());
        toolbar.setBorder(null);
        p.add((Component)toolbar, "West");
        this.panel.add((Component)p, "North");
    }

    public HGBaseMenu getMenu() {
        return this.menu;
    }

    public JToolBar getToolbar() {
        if (this.menu != null) {
            return this.menu.getToolbar();
        }
        return null;
    }

    public void setPanel(HGBasePanel p) {
        if (this.mainPanel != null) {
            this.panel.remove(this.mainPanel);
        }
        this.mainPanel = p;
        this.mainPanel.setFocusable(false);
        this.panel.add((Component)this.mainPanel, "Center");
        this.setVisible(true);
        int state = HGBaseConfig.getInt("last_state");
        if (state != -2147483631) {
            this.setExtendedState(state);
        }
    }

    public HGBasePanel getPanel() {
        return this.mainPanel;
    }

    public void setStatusBar(HGBaseStatusBar s) {
        if (this.statusBar != null) {
            this.panel.remove(this.statusBar);
        }
        this.statusBar = s;
        if (this.statusBar != null) {
            this.panel.add((Component)this.statusBar, "South");
        }
        this.panel.updateUI();
    }

    public HGBaseStatusBar getStatusBar() {
        return this.statusBar;
    }

    public HGBasePanel getStatusPanel(int index) {
        if (this.statusBar != null) {
            return this.statusBar.getPanel(index);
        }
        return null;
    }

    public JLabel getStatusLabel(int index) {
        if (this.statusBar != null) {
            return this.statusBar.getLabel(index);
        }
        return null;
    }

    public void setStatusText(int index, String text) {
        if (this.statusBar != null) {
            this.statusBar.setText(index, text);
        }
    }

    public void setStatusText(String text) {
        if (this.statusBar != null) {
            this.statusBar.setText(text);
        }
    }

    public void setStatusProgress(int state) {
        if (this.statusBar != null) {
            this.statusBar.setProgressState(state);
        }
    }

    @Override
    public void actualizeText() {
        JMenuBar menu = this.getJMenuBar();
        if (menu instanceof HGBaseGui) {
            ((HGBaseGui)((Object)menu)).actualizeText();
        }
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof HGBaseGui) {
                ((HGBaseGui)((Object)c)).actualizeText();
            }
            ++i;
        }
        if (this.panel != null) {
            this.panel.actualizeText();
        }
        for (IActualizeTextListener listener : this.actualizeTextList) {
            listener.actualizeText();
        }
    }

    public void actualizeLaf(String laf) {
        try {
            UIManager.setLookAndFeel(laf);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.actualizeLaf();
    }

    @Override
    public void actualizeLaf() {
        JMenuBar m = this.getJMenuBar();
        if (m instanceof HGBaseGui) {
            ((HGBaseGui)((Object)m)).actualizeLaf();
        }
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof HGBaseGui) {
                ((HGBaseGui)((Object)c)).actualizeLaf();
            }
            ++i;
        }
        if (this.panel != null) {
            this.panel.actualizeLaf();
        }
        if (this.getMenu() != null) {
            this.getMenu().setToolbarIcons();
        }
    }

    public void setCursorDefault() {
        this.setCursor(new Cursor(0));
    }

    public void setCursorWait() {
        this.setCursor(new Cursor(3));
    }

    public void setCursorMove() {
        this.setCursor(new Cursor(13));
    }

    public void setTitle() {
        StringBuilder title = new StringBuilder();
        this.appendTitle(title);
        String titleStr = title.toString();
        this.setTitle(titleStr);
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Field awtAppClassNameField = toolkit.getClass().getDeclaredField("awtAppClassName");
                awtAppClassNameField.setAccessible(true);
                awtAppClassNameField.set(toolkit, titleStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void appendTitle(StringBuilder title) {
        title.append(HGBaseSettings.get("appName"));
        if (this.currentFile != null) {
            String changed;
            boolean hideUnnamed = HGBaseSettings.getBoolean("titleHideUnnamed");
            String fileName = this.currentFile.getName();
            if (fileName.length() > 0) {
                hideUnnamed = false;
                title.append(" - [");
                title.append(fileName);
            } else if (!hideUnnamed) {
                title.append(" - [");
                title.append(HGBaseText.getText("file.unnamed", new String[0]));
            }
            if (this.isChanged() && (changed = HGBaseSettings.get("titleWasChanged")) != null) {
                title.append(changed);
            }
            if (!hideUnnamed) {
                title.append(']');
            }
        }
    }

    public void setFile(File file) {
        this.currentFile = file;
        this.setChanged(false);
    }

    public File getFile() {
        return this.currentFile;
    }

    public void setChanged(boolean change) {
        if (this.getFile() != null) {
            this.changed = change;
            if (this.menu != null) {
                this.menu.setFileMenuStates();
            }
        }
    }

    public boolean isChanged() {
        return this.currentFile != null && this.changed;
    }

    public int onFileNew() {
        return 0;
    }

    public int onFileClose() {
        return 0;
    }

    public int onFileSave(File file) {
        return 0;
    }

    public int onFileOpen(File file) {
        return 0;
    }

    public Printable onFilePrint() {
        return null;
    }

    public void addActualizeTextListener(IActualizeTextListener listener) {
        this.actualizeTextList.add(listener);
    }

    public void removeActualizeTextListener(IActualizeTextListener listener) {
        this.actualizeTextList.remove(listener);
    }

    protected boolean testCommandLineForFile(String[] args) {
        File f;
        String fileName;
        String string = fileName = args.length > 0 ? args[0] : null;
        if (fileName != null && fileName.length() > 0 && (f = new File(HGBaseFileTools.getCurrentDir(), fileName)).exists()) {
            return this.getMenu().onFileOpen(f);
        }
        return false;
    }

    public void onCheckUpdate() {
        if (this.update != null) {
            this.update.doCheck(false);
        }
    }

    protected void autoCheckUpdate() {
        boolean autoCheckUpdate = HGBaseConfig.getBoolean("autocheckupdate", false);
        if (this.update != null && autoCheckUpdate) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    HGBaseTools.sleep(5000L);
                    HGBaseFrame.this.update.doCheck(true);
                }
            }).start();
        }
    }

    public void toggleFullscreen() {
        GraphicsDevice device = this.getGraphicsConfiguration().getDevice();
        if (device.isFullScreenSupported()) {
            this.setFullscreen(device.getFullScreenWindow() == null);
        }
    }

    public void setFullscreen(boolean fullscreen) {
        GraphicsDevice device = this.getGraphicsConfiguration().getDevice();
        if (device.isFullScreenSupported()) {
            device.setFullScreenWindow(fullscreen ? this : null);
        }
    }

    protected class ExitOnUncaughtExceptionWithDialog
    implements Thread.UncaughtExceptionHandler {
        protected ExitOnUncaughtExceptionWithDialog() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            throwable.printStackTrace();
            HGBaseDialog.printError(throwable, (JFrame)HGBaseFrame.this);
            System.exit(-1);
        }
    }

    private class OnWindowCloseTermination
    extends WindowAdapter {
        private OnWindowCloseTermination() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (HGBaseFrame.this.menu != null) {
                HGBaseFrame.this.menu.onExit();
            }
        }
    }
}

