/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui;

import hgb.gui.HGBaseGuiTools;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HGBaseHTMLPage
extends JEditorPane {
    private static final long serialVersionUID = 424781074L;

    public HGBaseHTMLPage(URL url) throws IOException {
        super(url);
        this.init();
    }

    public HGBaseHTMLPage(String htmlText) {
        super("text/html", htmlText);
        this.init();
    }

    private void init() {
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent ev) {
                if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = ev.getURL();
                    String urlStr = url.toString();
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    cb.setContents(new StringSelection(urlStr), new ClipboardOwner(){

                        @Override
                        public void lostOwnership(Clipboard cb, Transferable t) {
                        }
                    });
                    HGBaseGuiTools.openURLwithBrowser(url);
                }
            }
        });
        this.setEditable(false);
        this.setOpaque(false);
    }

    public static boolean showDocument(URL url) {
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = serviceManagerClass.getMethod("lookup", String.class);
            Object basicServiceObject = lookupMethod.invoke(null, "javax.jnlp.BasicService");
            Class<?> basicServiceClass = Class.forName("javax.jnlp.BasicService");
            Method method = basicServiceClass.getMethod("showDocument", URL.class);
            Boolean resultBoolean = (Boolean)method.invoke(basicServiceObject, url);
            return resultBoolean;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return false;
        }
    }
}

