/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui;

import hgb.gui.HGBaseGuiTools;
import hgb.lib.HGBaseSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;

public final class HGBaseWelcome {
    private static final int HEIGHT_GAMEINFO = 14;
    private static final float FONTSIZE_GAMEINFO = 12.0f;
    private static final HGBaseWelcome welcomePanel = new HGBaseWelcome();
    private static final JWindow contentWindow = new JWindow();
    ImageIcon imgWelcome;
    ImageIcon imgWelcomeBottom;

    private HGBaseWelcome() {
    }

    public static HGBaseWelcome getInstance() {
        return welcomePanel;
    }

    public void initWelcomeScreen() {
        this.imgWelcome = HGBaseGuiTools.loadImage(HGBaseSettings.get("welcomeImage"));
        if (this.imgWelcome != null) {
            this.imgWelcomeBottom = HGBaseGuiTools.loadImage(HGBaseSettings.get("welcomeImageBottom"));
            JPanel contentPane = this.createPanel();
            this.setPosition(contentPane);
        }
    }

    public void removeWelcomeScreen() {
        if (contentWindow.isVisible()) {
            contentWindow.setVisible(false);
            contentWindow.removeAll();
        }
    }

    private JPanel createPanel() {
        JPanel contentPane = new JPanel(){
            private static final long serialVersionUID = 179869718100602674L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                int y = HGBaseWelcome.this.imgWelcome == null ? 0 : HGBaseWelcome.this.imgWelcome.getIconHeight();
                y = y + 14 + 1;
                if (HGBaseWelcome.this.imgWelcome != null) {
                    g.drawImage(HGBaseWelcome.this.imgWelcome.getImage(), 1, 1, HGBaseWelcome.this.imgWelcome.getImageObserver());
                    if (HGBaseWelcome.this.imgWelcomeBottom != null) {
                        double factor = HGBaseWelcome.this.calculateFactor();
                        int w = (int)((double)HGBaseWelcome.this.imgWelcomeBottom.getIconWidth() / factor);
                        int h = (int)((double)HGBaseWelcome.this.imgWelcomeBottom.getIconHeight() / factor);
                        g.drawImage(HGBaseWelcome.this.imgWelcomeBottom.getImage(), 1, y, w, h, HGBaseWelcome.this.imgWelcomeBottom.getImageObserver());
                    }
                }
                String appName = HGBaseSettings.get("appName", "");
                String appVersion = HGBaseSettings.get("appVersion", "");
                Font oldFont = g.getFont();
                g.setColor(Color.BLACK);
                g.setFont(oldFont.deriveFont(1, 12.0f));
                g.drawString(appName + " " + appVersion, 10, y - 2);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                g.setFont(oldFont);
            }
        };
        contentPane.setBackground(Color.WHITE);
        contentWindow.setContentPane(contentPane);
        return contentPane;
    }

    private void setPosition(JPanel contentPane) {
        if (contentPane != null) {
            int width = this.calculateWidth();
            int height = this.calculateHeight();
            contentWindow.setSize(width, height);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            contentWindow.setLocation((dim.width - width) / 2, (dim.height - height) / 2);
            contentWindow.setVisible(true);
        }
    }

    private int calculateWidth() {
        int w = 0;
        if (this.imgWelcome != null) {
            w = this.imgWelcome.getIconWidth();
        }
        if (w > 0) {
            w += 2;
        }
        return w;
    }

    private int calculateHeight() {
        int h = 0;
        if (this.imgWelcome != null) {
            h = this.imgWelcome.getIconHeight();
            if (this.imgWelcomeBottom != null) {
                double factor = this.calculateFactor();
                h += (int)((double)this.imgWelcomeBottom.getIconHeight() / factor);
            }
        }
        if (h > 0) {
            h = h + 14 + 2;
        }
        return h;
    }

    private double calculateFactor() {
        return 1.0 * (double)this.imgWelcomeBottom.getIconWidth() / (1.0 * (double)this.imgWelcome.getIconWidth());
    }
}

