/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui;

import hgb.lib.HGBaseTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NumberSelector
extends JPanel {
    private static final long serialVersionUID = 6772832056683938108L;
    private static final int MIN_LABEL_WIDTH = 12;
    private JSlider slider;
    private JLabel label;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();

    public NumberSelector() {
        this((JSlider)null);
    }

    public NumberSelector(JSlider sliderToUse) {
        super(new FlowLayout());
        this.slider = sliderToUse == null ? new JSlider() : sliderToUse;
        this.label = new JLabel("", 11);
        this.updateLabelSizeByMaximum();
        this.add(this.label);
        this.label.setBackground(Color.BLUE);
        this.add(this.slider);
        this.actualizeLabelValue();
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                NumberSelector.this.actualizeLabelValue();
            }
        });
    }

    protected final void updateLabelSizeByMaximum() {
        int width = 12 * HGBaseTools.getNumberDigits(this.slider.getMaximum());
        this.label.setPreferredSize(new Dimension(width, this.slider.getPreferredSize().height));
    }

    private void actualizeLabelValue() {
        int value = this.slider.getValue();
        this.label.setText(String.valueOf(value));
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public int getSelectedValue() {
        return this.slider.getValue();
    }

    @Override
    public void setEnabled(boolean enable) {
        this.slider.setEnabled(enable);
        this.label.setEnabled(enable);
        super.setEnabled(enable);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NumberSelector.this.performAction(new ActionEvent(e.getSource(), 1001, "stateChanged"));
            }
        });
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    private void performAction(ActionEvent ev) {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(ev);
        }
    }
}

